/*
 * Decompiled with CFR 0.152.
 */
package diglol.crypto;

import diglol.crypto.AesCbc;
import diglol.crypto.Error;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\u001a\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\f\u0010\b\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\u0014\u0010\t\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"AES_CBC_IV_SIZE", "", "checkCiphertext", "", "Ldiglol/crypto/AesCbc;", "ciphertext", "", "checkIv", "checkKey", "checkPlaintext", "plaintext", "cipher"})
public final class AesCbcKt {
    public static final int AES_CBC_IV_SIZE = 16;

    public static final void checkKey(@NotNull AesCbc $this$checkKey) {
        Intrinsics.checkNotNullParameter((Object)$this$checkKey, (String)"<this>");
        if ($this$checkKey.getKey$cipher().length != 16 && $this$checkKey.getKey$cipher().length != 32) {
            throw new Error("Invalid AES key size, expected 16 or 32, but got " + $this$checkKey.getKey$cipher().length);
        }
    }

    public static final void checkIv(@NotNull AesCbc $this$checkIv) {
        Intrinsics.checkNotNullParameter((Object)$this$checkIv, (String)"<this>");
        if ($this$checkIv.getIv$cipher() != null && $this$checkIv.getIv$cipher().length != AesCbc.IV_SIZE) {
            throw new Error("Iv must have 16 bytes");
        }
    }

    public static final void checkPlaintext(@NotNull AesCbc $this$checkPlaintext, @NotNull byte[] plaintext) {
        Intrinsics.checkNotNullParameter((Object)$this$checkPlaintext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        if (plaintext.length > Integer.MAX_VALUE - AesCbc.IV_SIZE) {
            throw new Error("Plaintext size can not exceed " + (Integer.MAX_VALUE - AesCbc.IV_SIZE));
        }
    }

    public static final void checkCiphertext(@NotNull AesCbc $this$checkCiphertext, @NotNull byte[] ciphertext) {
        Intrinsics.checkNotNullParameter((Object)$this$checkCiphertext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ciphertext, (String)"ciphertext");
        if (ciphertext.length < AesCbc.IV_SIZE) {
            throw new Error("Ciphertext too shoot");
        }
    }
}

