/*
 * Decompiled with CFR 0.152.
 */
package diglol.crypto;

import diglol.crypto.AesCbc;
import diglol.crypto.AesCbcKt;
import diglol.crypto.Cipher;
import diglol.crypto.Error;
import diglol.crypto.random.Random;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Ldiglol/crypto/AesCbc;", "Ldiglol/crypto/Cipher;", "key", "", "iv", "([B[B)V", "getIv$cipher", "()[B", "getKey$cipher", "keySpec", "Ljavax/crypto/spec/SecretKeySpec;", "decrypt", "ciphertext", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "encrypt", "plaintext", "Companion", "cipher"})
public final class AesCbc
implements Cipher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] key;
    @Nullable
    private final byte[] iv;
    @NotNull
    private final SecretKeySpec keySpec;
    @NotNull
    private static final Companion.localCipher.1 localCipher = new ThreadLocal<javax.crypto.Cipher>(){

        @NotNull
        protected javax.crypto.Cipher initialValue() {
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance("AES/CBC/PKCS5Padding");
            Intrinsics.checkNotNullExpressionValue((Object)cipher, (String)"getInstance(\"AES/CBC/PKCS5Padding\")");
            return cipher;
        }
    };
    @JvmField
    public static final int IV_SIZE = 16;

    @JvmOverloads
    public AesCbc(@NotNull byte[] key, @Nullable byte[] iv) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
        this.iv = iv;
        AesCbcKt.checkKey(this);
        AesCbcKt.checkIv(this);
        this.keySpec = new SecretKeySpec(this.key, "AES");
    }

    public /* synthetic */ AesCbc(byte[] byArray, byte[] byArray2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            byArray2 = null;
        }
        this(byArray, byArray2);
    }

    @NotNull
    public final byte[] getKey$cipher() {
        return this.key;
    }

    @Nullable
    public final byte[] getIv$cipher() {
        return this.iv;
    }

    @Override
    @Nullable
    public Object encrypt(@NotNull byte[] plaintext, @NotNull Continuation<? super byte[]> $completion) {
        AesCbcKt.checkPlaintext(this, plaintext);
        try {
            javax.crypto.Cipher cipher = (javax.crypto.Cipher)localCipher.get();
            byte[] byArray = this.iv;
            if (this.iv == null) {
                byArray = Random.nextBytes((int)IV_SIZE);
            }
            byte[] realIv = byArray;
            cipher.init(1, (Key)this.keySpec, new IvParameterSpec(realIv));
            byte[] byArray2 = cipher.doFinal(plaintext);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.doFinal(plaintext)");
            return ArraysKt.plus((byte[])realIv, (byte[])byArray2);
        }
        catch (Exception e) {
            throw new Error("Aes cbc encrypt error", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public Object decrypt(@NotNull byte[] ciphertext, @NotNull Continuation<? super byte[]> $completion) {
        AesCbcKt.checkCiphertext(this, ciphertext);
        byte[] byArray = Arrays.copyOf(ciphertext, IV_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
        byte[] iv = byArray;
        byte[] byArray2 = ciphertext;
        int n = IV_SIZE;
        int n2 = ciphertext.length;
        byte[] rawCiphertext = ArraysKt.copyOfRange((byte[])byArray2, (int)n, (int)n2);
        try {
            javax.crypto.Cipher cipher = (javax.crypto.Cipher)localCipher.get();
            cipher.init(2, (Key)this.keySpec, new IvParameterSpec(iv));
            byte[] byArray3 = cipher.doFinal(rawCiphertext);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"cipher.doFinal(rawCiphertext)");
            return byArray3;
        }
        catch (Exception e) {
            throw new Error("Aes cbc decrypt error", (Throwable)e);
        }
    }

    @JvmOverloads
    public AesCbc(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this(key, null, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003*\u0001\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Ldiglol/crypto/AesCbc$Companion;", "", "()V", "IV_SIZE", "", "localCipher", "diglol/crypto/AesCbc$Companion$localCipher$1", "Ldiglol/crypto/AesCbc$Companion$localCipher$1;", "cipher"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

