/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.util;

import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.types.builtin.ExtensionObject;
import com.digitalpetri.opcua.stack.core.types.enumerated.FilterOperator;
import com.digitalpetri.opcua.stack.core.types.structured.AttributeOperand;
import com.digitalpetri.opcua.stack.core.types.structured.ContentFilter;
import com.digitalpetri.opcua.stack.core.types.structured.ContentFilterElement;
import com.digitalpetri.opcua.stack.core.types.structured.FilterOperand;
import com.digitalpetri.opcua.stack.core.types.structured.SimpleAttributeOperand;
import java.util.Arrays;

public class ContentFilterUtil {
    public void apply(ContentFilter filter) throws UaException {
        int i = 0;
        ContentFilterElement[] elements = filter.getElements();
        if (i < elements.length) {
            ContentFilterElement element = elements[i];
            FilterOperator operator = element.getFilterOperator();
            SimpleAttributeOperand[] operands = this.extract(element.getFilterOperands());
            throw new UaException(2152267776L);
        }
    }

    private SimpleAttributeOperand[] extract(ExtensionObject[] operandXos) {
        return (SimpleAttributeOperand[])Arrays.stream(operandXos).map(xo -> (SimpleAttributeOperand)xo.decode()).toArray(SimpleAttributeOperand[]::new);
    }

    private boolean apply(FilterOperator operator, FilterOperand[] operands) {
        if (operator == FilterOperator.Equals) {
            SimpleAttributeOperand op0 = (SimpleAttributeOperand)operands[0];
            AttributeOperand op1 = (AttributeOperand)operands[1];
            op0.getAttributeId();
            op0.getBrowsePath();
            op0.getIndexRange();
            op0.getTypeDefinitionId();
        }
        return false;
    }

    private class EqualsOperator {
        private EqualsOperator() {
        }

        public void apply(FilterOperand[] operands) throws UaException {
        }
    }
}

