/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.util;

import com.digitalpetri.opcua.sdk.core.NumericRange;
import com.digitalpetri.opcua.sdk.core.nodes.DataTypeNode;
import com.digitalpetri.opcua.sdk.core.nodes.MethodNode;
import com.digitalpetri.opcua.sdk.core.nodes.Node;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectNode;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectTypeNode;
import com.digitalpetri.opcua.sdk.core.nodes.ReferenceTypeNode;
import com.digitalpetri.opcua.sdk.core.nodes.VariableNode;
import com.digitalpetri.opcua.sdk.core.nodes.VariableTypeNode;
import com.digitalpetri.opcua.stack.core.AttributeId;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DateTime;
import com.digitalpetri.opcua.stack.core.types.builtin.StatusCode;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.enumerated.TimestampsToReturn;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class AttributeReader {
    private static final Supplier<UaException> ATTRIBUTE_ID_INVALID_EXCEPTION = () -> new UaException(2150957056L);

    public static DataValue readAttribute(Node node, AttributeId attributeId, @Nullable TimestampsToReturn timestamps, @Nullable String indexRange) {
        try {
            DataValue value = AttributeReader.readAttribute(node, attributeId);
            if (indexRange != null) {
                NumericRange range = NumericRange.parse(indexRange);
                Object valueAtRange = NumericRange.readFromValueAtRange(value.getValue(), range);
                value = new DataValue(new Variant(valueAtRange), value.getStatusCode(), value.getSourceTime(), value.getServerTime());
            }
            if (timestamps != null) {
                value = attributeId == AttributeId.Value ? DataValue.derivedValue((DataValue)value, (TimestampsToReturn)timestamps) : DataValue.derivedNonValue((DataValue)value, (TimestampsToReturn)timestamps);
            }
            return value;
        }
        catch (UaException e) {
            return new DataValue(e.getStatusCode());
        }
    }

    private static DataValue readAttribute(Node node, AttributeId attributeId) throws UaException {
        switch (node.getNodeClass()) {
            case DataType: {
                return AttributeReader.readDataTypeAttribute((DataTypeNode)node, attributeId);
            }
            case Method: {
                return AttributeReader.readMethodAttribute((MethodNode)node, attributeId);
            }
            case Object: {
                return AttributeReader.readObjectAttribute((ObjectNode)node, attributeId);
            }
            case ObjectType: {
                return AttributeReader.readObjectTypeAttribute((ObjectTypeNode)node, attributeId);
            }
            case ReferenceType: {
                return AttributeReader.readReferenceTypeAttribute((ReferenceTypeNode)node, attributeId);
            }
            case Variable: {
                return AttributeReader.readVariableAttribute((VariableNode)node, attributeId);
            }
            case VariableType: {
                return AttributeReader.readVariableTypeAttribute((VariableTypeNode)node, attributeId);
            }
        }
        throw new UaException(2153709568L);
    }

    private static DataValue readNodeAttribute(Node node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case NodeId: {
                return AttributeReader.dv(node.getNodeId());
            }
            case NodeClass: {
                return AttributeReader.dv(node.getNodeClass());
            }
            case BrowseName: {
                return AttributeReader.dv(node.getBrowseName());
            }
            case DisplayName: {
                return AttributeReader.dv(node.getDisplayName());
            }
            case Description: {
                return node.getDescription().map(AttributeReader::dv).orElseThrow(ATTRIBUTE_ID_INVALID_EXCEPTION);
            }
            case WriteMask: {
                return node.getWriteMask().map(AttributeReader::dv).orElseThrow(ATTRIBUTE_ID_INVALID_EXCEPTION);
            }
            case UserWriteMask: {
                return node.getUserWriteMask().map(AttributeReader::dv).orElseThrow(ATTRIBUTE_ID_INVALID_EXCEPTION);
            }
        }
        throw ATTRIBUTE_ID_INVALID_EXCEPTION.get();
    }

    private static DataValue readDataTypeAttribute(DataTypeNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case IsAbstract: {
                return AttributeReader.dv(node.getIsAbstract());
            }
        }
        return AttributeReader.readNodeAttribute(node, attributeId);
    }

    private static DataValue readMethodAttribute(MethodNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case Executable: {
                return AttributeReader.dv(node.isExecutable());
            }
            case UserExecutable: {
                return AttributeReader.dv(node.isUserExecutable());
            }
        }
        return AttributeReader.readNodeAttribute(node, attributeId);
    }

    private static DataValue readObjectAttribute(ObjectNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case EventNotifier: {
                return AttributeReader.dv(node.getEventNotifier());
            }
        }
        return AttributeReader.readNodeAttribute(node, attributeId);
    }

    private static DataValue readObjectTypeAttribute(ObjectTypeNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case IsAbstract: {
                return AttributeReader.dv(node.getIsAbstract());
            }
        }
        return AttributeReader.readNodeAttribute(node, attributeId);
    }

    private static DataValue readReferenceTypeAttribute(ReferenceTypeNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case IsAbstract: {
                return AttributeReader.dv(node.getIsAbstract());
            }
            case Symmetric: {
                return AttributeReader.dv(node.getSymmetric());
            }
            case InverseName: {
                return node.getInverseName().map(AttributeReader::dv).orElseThrow(ATTRIBUTE_ID_INVALID_EXCEPTION);
            }
        }
        return AttributeReader.readNodeAttribute(node, attributeId);
    }

    private static DataValue readVariableAttribute(VariableNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case Value: {
                return new DataValue(node.getValue().getValue(), node.getValue().getStatusCode(), node.getValue().getSourceTime(), DateTime.now());
            }
            case DataType: {
                return AttributeReader.dv(node.getDataType());
            }
            case ValueRank: {
                return AttributeReader.dv(node.getValueRank());
            }
            case ArrayDimensions: {
                return node.getArrayDimensions().map(AttributeReader::dv).orElseThrow(ATTRIBUTE_ID_INVALID_EXCEPTION);
            }
            case AccessLevel: {
                return AttributeReader.dv(node.getAccessLevel());
            }
            case UserAccessLevel: {
                return AttributeReader.dv(node.getUserAccessLevel());
            }
            case MinimumSamplingInterval: {
                return node.getMinimumSamplingInterval().map(AttributeReader::dv).orElseThrow(ATTRIBUTE_ID_INVALID_EXCEPTION);
            }
            case Historizing: {
                return AttributeReader.dv(node.getHistorizing());
            }
        }
        return AttributeReader.readNodeAttribute(node, attributeId);
    }

    private static DataValue readVariableTypeAttribute(VariableTypeNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case Value: {
                return node.getValue().orElseThrow(ATTRIBUTE_ID_INVALID_EXCEPTION);
            }
            case DataType: {
                return AttributeReader.dv(node.getDataType());
            }
            case ValueRank: {
                return AttributeReader.dv(node.getValueRank());
            }
            case ArrayDimensions: {
                return node.getArrayDimensions().map(AttributeReader::dv).orElseThrow(ATTRIBUTE_ID_INVALID_EXCEPTION);
            }
            case IsAbstract: {
                return AttributeReader.dv(node.getIsAbstract());
            }
        }
        return AttributeReader.readNodeAttribute(node, attributeId);
    }

    private static DataValue dv(Object o) {
        return new DataValue(new Variant(o), StatusCode.GOOD, null, DateTime.now());
    }
}

