/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.services.helpers;

import com.digitalpetri.opcua.sdk.core.Reference;
import com.digitalpetri.opcua.sdk.server.DiagnosticsContext;
import com.digitalpetri.opcua.sdk.server.NamespaceManager;
import com.digitalpetri.opcua.sdk.server.OpcUaServer;
import com.digitalpetri.opcua.sdk.server.api.AttributeManager;
import com.digitalpetri.opcua.sdk.server.api.Namespace;
import com.digitalpetri.opcua.sdk.server.services.ServiceAttributes;
import com.digitalpetri.opcua.sdk.server.util.FutureUtils;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.application.services.ServiceRequest;
import com.digitalpetri.opcua.stack.core.serialization.UaResponseMessage;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DiagnosticInfo;
import com.digitalpetri.opcua.stack.core.types.builtin.ExpandedNodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.StatusCode;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.Unsigned;
import com.digitalpetri.opcua.stack.core.types.enumerated.TimestampsToReturn;
import com.digitalpetri.opcua.stack.core.types.structured.BrowsePath;
import com.digitalpetri.opcua.stack.core.types.structured.BrowsePathResult;
import com.digitalpetri.opcua.stack.core.types.structured.BrowsePathTarget;
import com.digitalpetri.opcua.stack.core.types.structured.ReadValueId;
import com.digitalpetri.opcua.stack.core.types.structured.RelativePath;
import com.digitalpetri.opcua.stack.core.types.structured.RelativePathElement;
import com.digitalpetri.opcua.stack.core.types.structured.ResponseHeader;
import com.digitalpetri.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import com.digitalpetri.opcua.stack.core.util.ConversionUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class BrowsePathsHelper {
    private final OpcUaServer server;
    private final NamespaceManager namespaceManager;

    public BrowsePathsHelper(OpcUaServer server, NamespaceManager namespaceManager) {
        this.server = server;
        this.namespaceManager = namespaceManager;
    }

    public void onTranslateBrowsePaths(ServiceRequest<TranslateBrowsePathsToNodeIdsRequest, TranslateBrowsePathsToNodeIdsResponse> service) {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        BrowsePath[] browsePaths = ((TranslateBrowsePathsToNodeIdsRequest)service.getRequest()).getBrowsePaths();
        if (browsePaths.length > server.getConfig().getLimits().getMaxNodesPerTranslateBrowsePathsToNodeIds().intValue()) {
            service.setServiceFault(0x80100000L);
        } else {
            ArrayList futures = Lists.newArrayListWithCapacity((int)browsePaths.length);
            for (BrowsePath browsePath : browsePaths) {
                futures.add(this.translate(browsePath));
            }
            FutureUtils.sequence(futures).thenAcceptAsync(results -> {
                ResponseHeader header = service.createResponseHeader();
                TranslateBrowsePathsToNodeIdsResponse response = new TranslateBrowsePathsToNodeIdsResponse(header, (BrowsePathResult[])ConversionUtil.a((List)results, BrowsePathResult.class), new DiagnosticInfo[0]);
                service.setResponse((UaResponseMessage)response);
            }, (Executor)server.getExecutorService());
        }
    }

    private CompletableFuture<BrowsePathResult> translate(BrowsePath browsePath) {
        CompletableFuture<BrowsePathResult> future = new CompletableFuture<BrowsePathResult>();
        NodeId startingNode = browsePath.getStartingNode();
        RelativePath relativePath = browsePath.getRelativePath();
        this.follow(startingNode, Lists.newArrayList((Object[])relativePath.getElements())).whenComplete((targets, ex) -> {
            if (targets != null) {
                BrowsePathResult result = !targets.isEmpty() ? new BrowsePathResult(StatusCode.GOOD, (BrowsePathTarget[])ConversionUtil.a((List)targets, BrowsePathTarget.class)) : new BrowsePathResult(new StatusCode(2154758144L), new BrowsePathTarget[0]);
                future.complete(result);
            } else {
                StatusCode statusCode = new StatusCode(2154758144L);
                if (ex instanceof UaException) {
                    statusCode = ((UaException)((Object)ex)).getStatusCode();
                }
                BrowsePathResult result = new BrowsePathResult(statusCode, new BrowsePathTarget[0]);
                future.complete(result);
            }
        });
        return future;
    }

    private CompletableFuture<List<BrowsePathTarget>> follow(NodeId nodeId, List<RelativePathElement> elements) {
        if (elements.size() == 1) {
            return this.target(nodeId, elements.get(0)).thenApply(targets -> targets.stream().map(n -> new BrowsePathTarget(n, Unsigned.uint((int)0))).collect(Collectors.toList()));
        }
        RelativePathElement e = elements.remove(0);
        return this.next(nodeId, e).thenCompose(nextExId -> {
            Optional<NodeId> nextId = this.namespaceManager.toNodeId((ExpandedNodeId)nextExId);
            if (nextId.isPresent()) {
                return this.follow(nextId.get(), elements);
            }
            ArrayList targets = Lists.newArrayList((Object[])new BrowsePathTarget[]{new BrowsePathTarget(nextExId, Unsigned.uint((int)elements.size()))});
            return CompletableFuture.completedFuture(targets);
        });
    }

    private CompletableFuture<ExpandedNodeId> next(NodeId nodeId, RelativePathElement element) {
        NodeId referenceTypeId = element.getReferenceTypeId();
        boolean includeSubtypes = element.getIncludeSubtypes();
        QualifiedName targetName = element.getTargetName();
        Namespace namespace = this.namespaceManager.getNamespace(nodeId.getNamespaceIndex());
        CompletableFuture<List<Reference>> future = namespace.getReferences(nodeId);
        return future.thenCompose(references -> {
            List<ExpandedNodeId> targetNodeIds = references.stream().filter(r -> referenceTypeId.isNull() || r.getReferenceTypeId().equals((Object)referenceTypeId) || includeSubtypes && r.subtypeOf(referenceTypeId, this.server.getReferenceTypes())).filter(r -> r.isInverse() == element.getIsInverse().booleanValue()).map(Reference::getTargetNodeId).collect(Collectors.toList());
            return this.readTargetBrowseNames(targetNodeIds).thenApply(browseNames -> {
                for (int i = 0; i < targetNodeIds.size(); ++i) {
                    ExpandedNodeId targetNodeId = (ExpandedNodeId)targetNodeIds.get(i);
                    QualifiedName browseName = (QualifiedName)browseNames.get(i);
                    if (!browseName.equals((Object)targetName)) continue;
                    return targetNodeId;
                }
                return ExpandedNodeId.NULL_VALUE;
            });
        });
    }

    private CompletableFuture<List<ExpandedNodeId>> target(NodeId nodeId, RelativePathElement element) {
        NodeId referenceTypeId = element.getReferenceTypeId();
        boolean includeSubtypes = element.getIncludeSubtypes();
        QualifiedName targetName = element.getTargetName();
        Namespace namespace = this.namespaceManager.getNamespace(nodeId.getNamespaceIndex());
        CompletableFuture<List<Reference>> future = namespace.getReferences(nodeId);
        return future.thenCompose(references -> {
            List<ExpandedNodeId> targetNodeIds = references.stream().filter(r -> referenceTypeId.isNull() || r.getReferenceTypeId().equals((Object)referenceTypeId) || includeSubtypes && r.subtypeOf(referenceTypeId, this.server.getReferenceTypes())).filter(r -> r.isInverse() == element.getIsInverse().booleanValue()).map(Reference::getTargetNodeId).collect(Collectors.toList());
            return this.readTargetBrowseNames(targetNodeIds).thenApply(browseNames -> {
                ArrayList targets = Lists.newArrayList();
                for (int i = 0; i < targetNodeIds.size(); ++i) {
                    ExpandedNodeId targetNodeId = (ExpandedNodeId)targetNodeIds.get(i);
                    QualifiedName browseName = (QualifiedName)browseNames.get(i);
                    if (!this.matchesTarget(browseName, targetName)) continue;
                    targets.add(targetNodeId);
                }
                return targets;
            });
        });
    }

    private CompletableFuture<List<QualifiedName>> readTargetBrowseNames(List<ExpandedNodeId> targetNodeIds) {
        ArrayList futures = Lists.newArrayListWithCapacity((int)targetNodeIds.size());
        for (ExpandedNodeId xni : targetNodeIds) {
            CompletableFuture<ArrayList> future = xni.local().map(nodeId -> {
                Namespace namespace = this.namespaceManager.getNamespace(nodeId.getNamespaceIndex());
                ReadValueId readValueId = new ReadValueId(nodeId, Unsigned.uint((int)3), null, QualifiedName.NULL_VALUE);
                CompletableFuture<List<DataValue>> readFuture = new CompletableFuture<List<DataValue>>();
                AttributeManager.ReadContext context = new AttributeManager.ReadContext(this.server, null, readFuture, new DiagnosticsContext<ReadValueId>());
                namespace.read(context, 0.0, TimestampsToReturn.Neither, Lists.newArrayList((Object[])new ReadValueId[]{readValueId}));
                return readFuture;
            }).orElse(CompletableFuture.completedFuture(Lists.newArrayList((Object[])new DataValue[]{new DataValue(2150891520L)})));
            futures.add(future);
        }
        return FutureUtils.sequence(futures).thenApply(values -> values.stream().map(l -> {
            DataValue v = (DataValue)l.get(0);
            return (QualifiedName)v.getValue().getValue();
        }).collect(Collectors.toList()));
    }

    private boolean matchesTarget(QualifiedName browseName, QualifiedName targetName) {
        return targetName == null || targetName.equals((Object)QualifiedName.NULL_VALUE) || targetName.equals((Object)browseName);
    }
}

