/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.services;

import com.digitalpetri.opcua.sdk.server.DiagnosticsContext;
import com.digitalpetri.opcua.sdk.server.OpcUaServer;
import com.digitalpetri.opcua.sdk.server.Session;
import com.digitalpetri.opcua.sdk.server.api.AttributeManager;
import com.digitalpetri.opcua.sdk.server.api.Namespace;
import com.digitalpetri.opcua.sdk.server.services.ServiceAttributes;
import com.digitalpetri.opcua.sdk.server.services.ServiceMetric;
import com.digitalpetri.opcua.sdk.server.util.FutureUtils;
import com.digitalpetri.opcua.sdk.server.util.PendingRead;
import com.digitalpetri.opcua.sdk.server.util.PendingWrite;
import com.digitalpetri.opcua.stack.core.application.services.AttributeServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.ServiceRequest;
import com.digitalpetri.opcua.stack.core.serialization.UaResponseMessage;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DiagnosticInfo;
import com.digitalpetri.opcua.stack.core.types.builtin.StatusCode;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UShort;
import com.digitalpetri.opcua.stack.core.types.structured.ReadRequest;
import com.digitalpetri.opcua.stack.core.types.structured.ReadResponse;
import com.digitalpetri.opcua.stack.core.types.structured.ReadValueId;
import com.digitalpetri.opcua.stack.core.types.structured.ResponseHeader;
import com.digitalpetri.opcua.stack.core.types.structured.WriteRequest;
import com.digitalpetri.opcua.stack.core.types.structured.WriteResponse;
import com.digitalpetri.opcua.stack.core.types.structured.WriteValue;
import com.digitalpetri.opcua.stack.core.util.ConversionUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class AttributeServices
implements AttributeServiceSet {
    private final ServiceMetric readMetric = new ServiceMetric();
    private final ServiceMetric writeMetric = new ServiceMetric();

    public void onRead(ServiceRequest<ReadRequest, ReadResponse> service) {
        this.readMetric.record(service);
        ReadRequest request = (ReadRequest)service.getRequest();
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        if (request.getNodesToRead().length == 0) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if ((long)request.getNodesToRead().length > server.getConfig().getLimits().getMaxNodesPerRead().longValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        if (request.getMaxAge() < 0.0) {
            service.setServiceFault(0x80700000L);
            return;
        }
        if (request.getTimestampsToReturn() == null) {
            service.setServiceFault(2150301696L);
            return;
        }
        ReadValueId[] nodesToRead = request.getNodesToRead();
        ArrayList pendingReads = Lists.newArrayListWithCapacity((int)nodesToRead.length);
        ArrayList futures = Lists.newArrayListWithCapacity((int)nodesToRead.length);
        for (ReadValueId id : nodesToRead) {
            PendingRead pending2 = new PendingRead(id);
            pendingReads.add(pending2);
            futures.add(pending2.getFuture());
        }
        Map<UShort, List<PendingRead>> byNamespace = pendingReads.stream().collect(Collectors.groupingBy(pending -> pending.getInput().getNodeId().getNamespaceIndex()));
        byNamespace.keySet().forEach(index -> {
            List pending = (List)byNamespace.get(index);
            CompletableFuture<List<DataValue>> future = new CompletableFuture<List<DataValue>>();
            AttributeManager.ReadContext context = new AttributeManager.ReadContext(server, session, future, diagnosticsContext);
            server.getExecutorService().execute(() -> {
                Namespace namespace = server.getNamespaceManager().getNamespace((UShort)index);
                List<ReadValueId> readValueIds = pending.stream().map(PendingRead::getInput).collect(Collectors.toList());
                namespace.read(context, request.getMaxAge(), request.getTimestampsToReturn(), readValueIds);
            });
            future.thenAccept(values -> {
                for (int i = 0; i < values.size(); ++i) {
                    ((PendingRead)pending.get(i)).getFuture().complete((DataValue)values.get(i));
                }
            });
        });
        FutureUtils.sequence(futures).thenAcceptAsync(values -> {
            ResponseHeader header = service.createResponseHeader();
            DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToRead);
            ReadResponse response = new ReadResponse(header, (DataValue[])ConversionUtil.a((List)values, DataValue.class), diagnosticInfos);
            service.setResponse((UaResponseMessage)response);
        }, (Executor)server.getExecutorService());
    }

    public void onWrite(ServiceRequest<WriteRequest, WriteResponse> service) {
        this.writeMetric.record(service);
        WriteRequest request = (WriteRequest)service.getRequest();
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        if (request.getNodesToWrite().length == 0) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if (request.getNodesToWrite().length > server.getConfig().getLimits().getMaxNodesPerWrite().intValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        WriteValue[] nodesToWrite = request.getNodesToWrite();
        ArrayList pendingWrites = Lists.newArrayListWithCapacity((int)nodesToWrite.length);
        ArrayList futures = Lists.newArrayListWithCapacity((int)nodesToWrite.length);
        for (WriteValue value : nodesToWrite) {
            PendingWrite pending2 = new PendingWrite(value);
            pendingWrites.add(pending2);
            futures.add(pending2.getFuture());
        }
        Map<UShort, List<PendingWrite>> byNamespace = pendingWrites.stream().collect(Collectors.groupingBy(pending -> pending.getInput().getNodeId().getNamespaceIndex()));
        byNamespace.keySet().forEach(index -> {
            List pending = (List)byNamespace.get(index);
            CompletableFuture<List<StatusCode>> future = new CompletableFuture<List<StatusCode>>();
            AttributeManager.WriteContext context = new AttributeManager.WriteContext(server, session, future, diagnosticsContext);
            server.getExecutorService().execute(() -> {
                Namespace namespace = server.getNamespaceManager().getNamespace((UShort)index);
                List<WriteValue> writeValues = pending.stream().map(PendingWrite::getInput).collect(Collectors.toList());
                namespace.write(context, writeValues);
            });
            future.thenAccept(statusCodes -> {
                for (int i = 0; i < statusCodes.size(); ++i) {
                    ((PendingWrite)pending.get(i)).getFuture().complete((StatusCode)statusCodes.get(i));
                }
            });
        });
        FutureUtils.sequence(futures).thenAcceptAsync(values -> {
            ResponseHeader header = service.createResponseHeader();
            DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToWrite);
            WriteResponse response = new WriteResponse(header, (StatusCode[])ConversionUtil.a((List)values, StatusCode.class), diagnosticInfos);
            service.setResponse((UaResponseMessage)response);
        }, (Executor)server.getExecutorService());
    }
}

