/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.variables;

import com.digitalpetri.opcua.sdk.core.model.UaMandatory;
import com.digitalpetri.opcua.sdk.core.model.variables.SessionSecurityDiagnosticsType;
import com.digitalpetri.opcua.sdk.core.nodes.VariableNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.variables.BaseDataVariableNode;
import com.digitalpetri.opcua.sdk.server.util.UaVariableType;
import com.digitalpetri.opcua.stack.core.types.builtin.ByteString;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.enumerated.MessageSecurityMode;
import com.digitalpetri.opcua.stack.core.types.structured.SessionSecurityDiagnosticsDataType;
import java.util.Optional;

@UaVariableType(name="SessionSecurityDiagnosticsType")
public class SessionSecurityDiagnosticsNode
extends BaseDataVariableNode
implements SessionSecurityDiagnosticsType {
    public SessionSecurityDiagnosticsNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, DataValue value, NodeId dataType, Integer valueRank, Optional<UInteger[]> arrayDimensions, UByte accessLevel, UByte userAccessLevel, Optional<Double> minimumSamplingInterval, boolean historizing) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public DataValue getValue() {
        SessionSecurityDiagnosticsDataType value = new SessionSecurityDiagnosticsDataType(this.getSessionId(), this.getClientUserIdOfSession(), this.getClientUserIdHistory(), this.getAuthenticationMechanism(), this.getEncoding(), this.getTransportProtocol(), this.getSecurityMode(), this.getSecurityPolicyUri(), this.getClientCertificate());
        return new DataValue(new Variant((Object)value));
    }

    @Override
    public synchronized void setValue(DataValue value) {
        SessionSecurityDiagnosticsDataType v = (SessionSecurityDiagnosticsDataType)value.getValue().getValue();
        this.setSessionId(v.getSessionId());
        this.setClientUserIdOfSession(v.getClientUserIdOfSession());
        this.setClientUserIdHistory(v.getClientUserIdHistory());
        this.setAuthenticationMechanism(v.getAuthenticationMechanism());
        this.setEncoding(v.getEncoding());
        this.setTransportProtocol(v.getTransportProtocol());
        this.setSecurityMode(v.getSecurityMode());
        this.setSecurityPolicyUri(v.getSecurityPolicyUri());
        this.setClientCertificate(v.getClientCertificate());
        this.fireAttributeChanged(13, value);
    }

    @Override
    @UaMandatory(value="SessionId")
    public NodeId getSessionId() {
        Optional<VariableNode> node = this.getVariableComponent("SessionId");
        return node.map(n -> (NodeId)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ClientUserIdOfSession")
    public String getClientUserIdOfSession() {
        Optional<VariableNode> node = this.getVariableComponent("ClientUserIdOfSession");
        return node.map(n -> (String)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ClientUserIdHistory")
    public String[] getClientUserIdHistory() {
        Optional<VariableNode> node = this.getVariableComponent("ClientUserIdHistory");
        return node.map(n -> (String[])n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="AuthenticationMechanism")
    public String getAuthenticationMechanism() {
        Optional<VariableNode> node = this.getVariableComponent("AuthenticationMechanism");
        return node.map(n -> (String)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="Encoding")
    public String getEncoding() {
        Optional<VariableNode> node = this.getVariableComponent("Encoding");
        return node.map(n -> (String)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="TransportProtocol")
    public String getTransportProtocol() {
        Optional<VariableNode> node = this.getVariableComponent("TransportProtocol");
        return node.map(n -> (String)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="SecurityMode")
    public MessageSecurityMode getSecurityMode() {
        Optional<VariableNode> node = this.getVariableComponent("SecurityMode");
        return node.map(n -> {
            Integer value = (Integer)n.getValue().getValue().getValue();
            return MessageSecurityMode.from((Integer)value);
        }).orElse(null);
    }

    @Override
    @UaMandatory(value="SecurityPolicyUri")
    public String getSecurityPolicyUri() {
        Optional<VariableNode> node = this.getVariableComponent("SecurityPolicyUri");
        return node.map(n -> (String)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ClientCertificate")
    public ByteString getClientCertificate() {
        Optional<VariableNode> node = this.getVariableComponent("ClientCertificate");
        return node.map(n -> (ByteString)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public synchronized void setSessionId(NodeId sessionId) {
        this.getVariableComponent("SessionId").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)sessionId)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setClientUserIdOfSession(String clientUserIdOfSession) {
        this.getVariableComponent("ClientUserIdOfSession").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)clientUserIdOfSession)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setClientUserIdHistory(String[] clientUserIdHistory) {
        this.getVariableComponent("ClientUserIdHistory").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)clientUserIdHistory)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setAuthenticationMechanism(String authenticationMechanism) {
        this.getVariableComponent("AuthenticationMechanism").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)authenticationMechanism)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setEncoding(String encoding) {
        this.getVariableComponent("Encoding").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)encoding)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setTransportProtocol(String transportProtocol) {
        this.getVariableComponent("TransportProtocol").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)transportProtocol)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setSecurityMode(MessageSecurityMode securityMode) {
        this.getVariableComponent("SecurityMode").ifPresent(n -> {
            Integer value = securityMode.getValue();
            n.setValue(new DataValue(new Variant((Object)value)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setSecurityPolicyUri(String securityPolicyUri) {
        this.getVariableComponent("SecurityPolicyUri").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)securityPolicyUri)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setClientCertificate(ByteString clientCertificate) {
        this.getVariableComponent("ClientCertificate").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)clientCertificate)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }
}

