/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.variables;

import com.digitalpetri.opcua.sdk.core.model.UaMandatory;
import com.digitalpetri.opcua.sdk.core.model.variables.SamplingIntervalDiagnosticsType;
import com.digitalpetri.opcua.sdk.core.nodes.VariableNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.variables.BaseDataVariableNode;
import com.digitalpetri.opcua.sdk.server.util.UaVariableType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.structured.SamplingIntervalDiagnosticsDataType;
import java.util.Optional;

@UaVariableType(name="SamplingIntervalDiagnosticsType")
public class SamplingIntervalDiagnosticsNode
extends BaseDataVariableNode
implements SamplingIntervalDiagnosticsType {
    public SamplingIntervalDiagnosticsNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, DataValue value, NodeId dataType, Integer valueRank, Optional<UInteger[]> arrayDimensions, UByte accessLevel, UByte userAccessLevel, Optional<Double> minimumSamplingInterval, boolean historizing) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public DataValue getValue() {
        SamplingIntervalDiagnosticsDataType value = new SamplingIntervalDiagnosticsDataType(this.getSamplingInterval(), this.getSampledMonitoredItemsCount(), this.getMaxSampledMonitoredItemsCount(), this.getDisabledMonitoredItemsSamplingCount());
        return new DataValue(new Variant((Object)value));
    }

    @Override
    public synchronized void setValue(DataValue value) {
        SamplingIntervalDiagnosticsDataType v = (SamplingIntervalDiagnosticsDataType)value.getValue().getValue();
        this.setSamplingInterval(v.getSamplingInterval());
        this.setSampledMonitoredItemsCount(v.getMonitoredItemCount());
        this.setMaxSampledMonitoredItemsCount(v.getMaxMonitoredItemCount());
        this.setDisabledMonitoredItemsSamplingCount(v.getDisabledMonitoredItemCount());
        this.fireAttributeChanged(13, value);
    }

    @Override
    @UaMandatory(value="SamplingInterval")
    public Double getSamplingInterval() {
        Optional<VariableNode> node = this.getVariableComponent("SamplingInterval");
        return node.map(n -> (Double)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="SampledMonitoredItemsCount")
    public UInteger getSampledMonitoredItemsCount() {
        Optional<VariableNode> node = this.getVariableComponent("SampledMonitoredItemsCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="MaxSampledMonitoredItemsCount")
    public UInteger getMaxSampledMonitoredItemsCount() {
        Optional<VariableNode> node = this.getVariableComponent("MaxSampledMonitoredItemsCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="DisabledMonitoredItemsSamplingCount")
    public UInteger getDisabledMonitoredItemsSamplingCount() {
        Optional<VariableNode> node = this.getVariableComponent("DisabledMonitoredItemsSamplingCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public synchronized void setSamplingInterval(Double samplingInterval) {
        this.getVariableComponent("SamplingInterval").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)samplingInterval)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setSampledMonitoredItemsCount(UInteger sampledMonitoredItemsCount) {
        this.getVariableComponent("SampledMonitoredItemsCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)sampledMonitoredItemsCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setMaxSampledMonitoredItemsCount(UInteger maxSampledMonitoredItemsCount) {
        this.getVariableComponent("MaxSampledMonitoredItemsCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)maxSampledMonitoredItemsCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setDisabledMonitoredItemsSamplingCount(UInteger disabledMonitoredItemsSamplingCount) {
        this.getVariableComponent("DisabledMonitoredItemsSamplingCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)disabledMonitoredItemsSamplingCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }
}

