/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.variables;

import com.digitalpetri.opcua.sdk.core.model.UaMandatory;
import com.digitalpetri.opcua.sdk.core.model.variables.ProgramDiagnosticType;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.variables.BaseDataVariableNode;
import com.digitalpetri.opcua.sdk.server.util.UaVariableType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DateTime;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.structured.Argument;
import com.digitalpetri.opcua.stack.core.types.structured.ProgramDiagnosticDataType;
import com.digitalpetri.opcua.stack.core.types.structured.StatusResult;
import java.util.Optional;

@UaVariableType(name="ProgramDiagnosticType")
public class ProgramDiagnosticNode
extends BaseDataVariableNode
implements ProgramDiagnosticType {
    public ProgramDiagnosticNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, DataValue value, NodeId dataType, Integer valueRank, Optional<UInteger[]> arrayDimensions, UByte accessLevel, UByte userAccessLevel, Optional<Double> minimumSamplingInterval, boolean historizing) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public DataValue getValue() {
        ProgramDiagnosticDataType value = new ProgramDiagnosticDataType(this.getCreateSessionId(), this.getCreateClientName(), this.getInvocationCreationTime(), this.getLastTransitionTime(), this.getLastMethodCall(), this.getLastMethodSessionId(), this.getLastMethodInputArguments(), this.getLastMethodOutputArguments(), this.getLastMethodCallTime(), this.getLastMethodReturnStatus());
        return new DataValue(new Variant((Object)value));
    }

    @Override
    public synchronized void setValue(DataValue value) {
        ProgramDiagnosticDataType v = (ProgramDiagnosticDataType)value.getValue().getValue();
        this.setCreateSessionId(v.getCreateSessionId());
        this.setCreateClientName(v.getCreateClientName());
        this.setInvocationCreationTime(v.getInvocationCreationTime());
        this.setLastTransitionTime(v.getLastTransitionTime());
        this.setLastMethodCall(v.getLastMethodCall());
        this.setLastMethodSessionId(v.getLastMethodSessionId());
        this.setLastMethodInputArguments(v.getLastMethodInputArguments());
        this.setLastMethodOutputArguments(v.getLastMethodOutputArguments());
        this.setLastMethodCallTime(v.getLastMethodCallTime());
        this.setLastMethodReturnStatus(v.getLastMethodReturnStatus());
        this.fireAttributeChanged(13, value);
    }

    @Override
    @UaMandatory(value="CreateSessionId")
    public NodeId getCreateSessionId() {
        Optional<Object> createSessionId = this.getProperty("CreateSessionId");
        return createSessionId.orElse(null);
    }

    @Override
    @UaMandatory(value="CreateClientName")
    public String getCreateClientName() {
        Optional<Object> createClientName = this.getProperty("CreateClientName");
        return createClientName.orElse(null);
    }

    @Override
    @UaMandatory(value="InvocationCreationTime")
    public DateTime getInvocationCreationTime() {
        Optional<Object> invocationCreationTime = this.getProperty("InvocationCreationTime");
        return invocationCreationTime.orElse(null);
    }

    @Override
    @UaMandatory(value="LastTransitionTime")
    public DateTime getLastTransitionTime() {
        Optional<Object> lastTransitionTime = this.getProperty("LastTransitionTime");
        return lastTransitionTime.orElse(null);
    }

    @Override
    @UaMandatory(value="LastMethodCall")
    public String getLastMethodCall() {
        Optional<Object> lastMethodCall = this.getProperty("LastMethodCall");
        return lastMethodCall.orElse(null);
    }

    @Override
    @UaMandatory(value="LastMethodSessionId")
    public NodeId getLastMethodSessionId() {
        Optional<Object> lastMethodSessionId = this.getProperty("LastMethodSessionId");
        return lastMethodSessionId.orElse(null);
    }

    @Override
    @UaMandatory(value="LastMethodInputArguments")
    public Argument[] getLastMethodInputArguments() {
        Optional<Object> lastMethodInputArguments = this.getProperty("LastMethodInputArguments");
        return lastMethodInputArguments.orElse(null);
    }

    @Override
    @UaMandatory(value="LastMethodOutputArguments")
    public Argument[] getLastMethodOutputArguments() {
        Optional<Object> lastMethodOutputArguments = this.getProperty("LastMethodOutputArguments");
        return lastMethodOutputArguments.orElse(null);
    }

    @Override
    @UaMandatory(value="LastMethodCallTime")
    public DateTime getLastMethodCallTime() {
        Optional<Object> lastMethodCallTime = this.getProperty("LastMethodCallTime");
        return lastMethodCallTime.orElse(null);
    }

    @Override
    @UaMandatory(value="LastMethodReturnStatus")
    public StatusResult getLastMethodReturnStatus() {
        Optional<Object> lastMethodReturnStatus = this.getProperty("LastMethodReturnStatus");
        return lastMethodReturnStatus.orElse(null);
    }

    @Override
    public synchronized void setCreateSessionId(NodeId createSessionId) {
        this.getPropertyNode("CreateSessionId").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)createSessionId))));
    }

    @Override
    public synchronized void setCreateClientName(String createClientName) {
        this.getPropertyNode("CreateClientName").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)createClientName))));
    }

    @Override
    public synchronized void setInvocationCreationTime(DateTime invocationCreationTime) {
        this.getPropertyNode("InvocationCreationTime").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)invocationCreationTime))));
    }

    @Override
    public synchronized void setLastTransitionTime(DateTime lastTransitionTime) {
        this.getPropertyNode("LastTransitionTime").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)lastTransitionTime))));
    }

    @Override
    public synchronized void setLastMethodCall(String lastMethodCall) {
        this.getPropertyNode("LastMethodCall").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)lastMethodCall))));
    }

    @Override
    public synchronized void setLastMethodSessionId(NodeId lastMethodSessionId) {
        this.getPropertyNode("LastMethodSessionId").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)lastMethodSessionId))));
    }

    @Override
    public synchronized void setLastMethodInputArguments(Argument[] lastMethodInputArguments) {
        this.getPropertyNode("LastMethodInputArguments").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)lastMethodInputArguments))));
    }

    @Override
    public synchronized void setLastMethodOutputArguments(Argument[] lastMethodOutputArguments) {
        this.getPropertyNode("LastMethodOutputArguments").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)lastMethodOutputArguments))));
    }

    @Override
    public synchronized void setLastMethodCallTime(DateTime lastMethodCallTime) {
        this.getPropertyNode("LastMethodCallTime").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)lastMethodCallTime))));
    }

    @Override
    public synchronized void setLastMethodReturnStatus(StatusResult lastMethodReturnStatus) {
        this.getPropertyNode("LastMethodReturnStatus").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)lastMethodReturnStatus))));
    }
}

