/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.variables;

import com.digitalpetri.opcua.sdk.core.model.UaMandatory;
import com.digitalpetri.opcua.sdk.core.model.variables.BuildInfoType;
import com.digitalpetri.opcua.sdk.core.nodes.VariableNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.variables.BaseDataVariableNode;
import com.digitalpetri.opcua.sdk.server.util.UaVariableType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DateTime;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.structured.BuildInfo;
import java.util.Optional;

@UaVariableType(name="BuildInfoType")
public class BuildInfoNode
extends BaseDataVariableNode
implements BuildInfoType {
    public BuildInfoNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, DataValue value, NodeId dataType, Integer valueRank, Optional<UInteger[]> arrayDimensions, UByte accessLevel, UByte userAccessLevel, Optional<Double> minimumSamplingInterval, boolean historizing) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public DataValue getValue() {
        BuildInfo value = new BuildInfo(this.getProductUri(), this.getManufacturerName(), this.getProductName(), this.getSoftwareVersion(), this.getBuildNumber(), this.getBuildDate());
        return new DataValue(new Variant((Object)value));
    }

    @Override
    public synchronized void setValue(DataValue value) {
        BuildInfo v = (BuildInfo)value.getValue().getValue();
        this.setProductUri(v.getProductUri());
        this.setManufacturerName(v.getManufacturerName());
        this.setProductName(v.getProductName());
        this.setSoftwareVersion(v.getSoftwareVersion());
        this.setBuildNumber(v.getBuildNumber());
        this.setBuildDate(v.getBuildDate());
        this.fireAttributeChanged(13, value);
    }

    @Override
    @UaMandatory(value="ProductUri")
    public String getProductUri() {
        Optional<VariableNode> node = this.getVariableComponent("ProductUri");
        return node.map(n -> (String)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ManufacturerName")
    public String getManufacturerName() {
        Optional<VariableNode> node = this.getVariableComponent("ManufacturerName");
        return node.map(n -> (String)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ProductName")
    public String getProductName() {
        Optional<VariableNode> node = this.getVariableComponent("ProductName");
        return node.map(n -> (String)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="SoftwareVersion")
    public String getSoftwareVersion() {
        Optional<VariableNode> node = this.getVariableComponent("SoftwareVersion");
        return node.map(n -> (String)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="BuildNumber")
    public String getBuildNumber() {
        Optional<VariableNode> node = this.getVariableComponent("BuildNumber");
        return node.map(n -> (String)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="BuildDate")
    public DateTime getBuildDate() {
        Optional<VariableNode> node = this.getVariableComponent("BuildDate");
        return node.map(n -> (DateTime)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public synchronized void setProductUri(String productUri) {
        this.getVariableComponent("ProductUri").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)productUri)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setManufacturerName(String manufacturerName) {
        this.getVariableComponent("ManufacturerName").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)manufacturerName)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setProductName(String productName) {
        this.getVariableComponent("ProductName").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)productName)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setSoftwareVersion(String softwareVersion) {
        this.getVariableComponent("SoftwareVersion").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)softwareVersion)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setBuildNumber(String buildNumber) {
        this.getVariableComponent("BuildNumber").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)buildNumber)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setBuildDate(DateTime buildDate) {
        this.getVariableComponent("BuildDate").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)buildDate)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }
}

