/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.variables;

import com.digitalpetri.opcua.sdk.core.model.UaMandatory;
import com.digitalpetri.opcua.sdk.core.model.UaOptional;
import com.digitalpetri.opcua.sdk.core.model.variables.ArrayItemType;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.variables.DataItemNode;
import com.digitalpetri.opcua.sdk.server.util.UaVariableType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.enumerated.AxisScaleEnumeration;
import com.digitalpetri.opcua.stack.core.types.structured.EUInformation;
import com.digitalpetri.opcua.stack.core.types.structured.Range;
import java.util.Optional;

@UaVariableType(name="ArrayItemType")
public class ArrayItemNode
extends DataItemNode
implements ArrayItemType {
    public ArrayItemNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, DataValue value, NodeId dataType, Integer valueRank, Optional<UInteger[]> arrayDimensions, UByte accessLevel, UByte userAccessLevel, Optional<Double> minimumSamplingInterval, boolean historizing) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    @UaOptional(value="InstrumentRange")
    public Range getInstrumentRange() {
        Optional<Object> instrumentRange = this.getProperty("InstrumentRange");
        return instrumentRange.orElse(null);
    }

    @Override
    @UaMandatory(value="EURange")
    public Range getEURange() {
        Optional<Object> eURange = this.getProperty("EURange");
        return eURange.orElse(null);
    }

    @Override
    @UaMandatory(value="EngineeringUnits")
    public EUInformation getEngineeringUnits() {
        Optional<Object> engineeringUnits = this.getProperty("EngineeringUnits");
        return engineeringUnits.orElse(null);
    }

    @Override
    @UaMandatory(value="Title")
    public LocalizedText getTitle() {
        Optional<Object> title = this.getProperty("Title");
        return title.orElse(null);
    }

    @Override
    @UaMandatory(value="AxisScaleType")
    public AxisScaleEnumeration getAxisScaleType() {
        Optional<Integer> axisScaleType = this.getProperty("AxisScaleType");
        return axisScaleType.map(AxisScaleEnumeration::from).orElse(null);
    }

    @Override
    public synchronized void setInstrumentRange(Range instrumentRange) {
        this.getPropertyNode("InstrumentRange").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)instrumentRange))));
    }

    @Override
    public synchronized void setEURange(Range eURange) {
        this.getPropertyNode("EURange").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)eURange))));
    }

    @Override
    public synchronized void setEngineeringUnits(EUInformation engineeringUnits) {
        this.getPropertyNode("EngineeringUnits").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)engineeringUnits))));
    }

    @Override
    public synchronized void setTitle(LocalizedText title) {
        this.getPropertyNode("Title").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)title))));
    }

    @Override
    public synchronized void setAxisScaleType(AxisScaleEnumeration axisScaleType) {
        this.getPropertyNode("AxisScaleType").ifPresent(n -> {
            Integer value = axisScaleType.getValue();
            n.setValue(new DataValue(new Variant((Object)value)));
        });
    }
}

