/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.variables;

import com.digitalpetri.opcua.sdk.core.model.UaMandatory;
import com.digitalpetri.opcua.sdk.core.model.UaOptional;
import com.digitalpetri.opcua.sdk.core.model.variables.AnalogItemType;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.variables.DataItemNode;
import com.digitalpetri.opcua.sdk.server.util.UaVariableType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.structured.EUInformation;
import com.digitalpetri.opcua.stack.core.types.structured.Range;
import java.util.Optional;

@UaVariableType(name="AnalogItemType")
public class AnalogItemNode
extends DataItemNode
implements AnalogItemType {
    public AnalogItemNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, DataValue value, NodeId dataType, Integer valueRank, Optional<UInteger[]> arrayDimensions, UByte accessLevel, UByte userAccessLevel, Optional<Double> minimumSamplingInterval, boolean historizing) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    @UaOptional(value="InstrumentRange")
    public Range getInstrumentRange() {
        Optional<Object> instrumentRange = this.getProperty("InstrumentRange");
        return instrumentRange.orElse(null);
    }

    @Override
    @UaMandatory(value="EURange")
    public Range getEURange() {
        Optional<Object> eURange = this.getProperty("EURange");
        return eURange.orElse(null);
    }

    @Override
    @UaOptional(value="EngineeringUnits")
    public EUInformation getEngineeringUnits() {
        Optional<Object> engineeringUnits = this.getProperty("EngineeringUnits");
        return engineeringUnits.orElse(null);
    }

    @Override
    public synchronized void setInstrumentRange(Range instrumentRange) {
        this.getPropertyNode("InstrumentRange").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)instrumentRange))));
    }

    @Override
    public synchronized void setEURange(Range eURange) {
        this.getPropertyNode("EURange").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)eURange))));
    }

    @Override
    public synchronized void setEngineeringUnits(EUInformation engineeringUnits) {
        this.getPropertyNode("EngineeringUnits").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)engineeringUnits))));
    }
}

