/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.objects;

import com.digitalpetri.opcua.sdk.core.model.objects.AggregateConfigurationType;
import com.digitalpetri.opcua.sdk.core.model.objects.FolderType;
import com.digitalpetri.opcua.sdk.core.model.objects.HistoricalDataConfigurationType;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.objects.BaseObjectNode;
import com.digitalpetri.opcua.sdk.server.util.UaObjectType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DateTime;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.enumerated.ExceptionDeviationFormat;
import java.util.Optional;

@UaObjectType(name="HistoricalDataConfigurationType")
public class HistoricalDataConfigurationNode
extends BaseObjectNode
implements HistoricalDataConfigurationType {
    public HistoricalDataConfigurationNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, UByte eventNotifier) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public AggregateConfigurationType getAggregateConfiguration() {
        Optional<ObjectNode> aggregateConfiguration = this.getObjectComponent("AggregateConfiguration");
        return aggregateConfiguration.map(node -> (AggregateConfigurationType)((Object)node)).orElse(null);
    }

    @Override
    public FolderType getAggregateFunctions() {
        Optional<ObjectNode> aggregateFunctions = this.getObjectComponent("AggregateFunctions");
        return aggregateFunctions.map(node -> (FolderType)((Object)node)).orElse(null);
    }

    @Override
    public Boolean getStepped() {
        Optional<Object> stepped = this.getProperty("Stepped");
        return stepped.orElse(null);
    }

    @Override
    public String getDefinition() {
        Optional<Object> definition = this.getProperty("Definition");
        return definition.orElse(null);
    }

    @Override
    public Double getMaxTimeInterval() {
        Optional<Object> maxTimeInterval = this.getProperty("MaxTimeInterval");
        return maxTimeInterval.orElse(null);
    }

    @Override
    public Double getMinTimeInterval() {
        Optional<Object> minTimeInterval = this.getProperty("MinTimeInterval");
        return minTimeInterval.orElse(null);
    }

    @Override
    public Double getExceptionDeviation() {
        Optional<Object> exceptionDeviation = this.getProperty("ExceptionDeviation");
        return exceptionDeviation.orElse(null);
    }

    @Override
    public ExceptionDeviationFormat getExceptionDeviationFormat() {
        Optional<Integer> exceptionDeviationFormat = this.getProperty("ExceptionDeviationFormat");
        return exceptionDeviationFormat.map(ExceptionDeviationFormat::from).orElse(null);
    }

    @Override
    public DateTime getStartOfArchive() {
        Optional<Object> startOfArchive = this.getProperty("StartOfArchive");
        return startOfArchive.orElse(null);
    }

    @Override
    public DateTime getStartOfOnlineArchive() {
        Optional<Object> startOfOnlineArchive = this.getProperty("StartOfOnlineArchive");
        return startOfOnlineArchive.orElse(null);
    }

    @Override
    public synchronized void setStepped(Boolean stepped) {
        this.getPropertyNode("Stepped").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)stepped))));
    }

    @Override
    public synchronized void setDefinition(String definition) {
        this.getPropertyNode("Definition").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)definition))));
    }

    @Override
    public synchronized void setMaxTimeInterval(Double maxTimeInterval) {
        this.getPropertyNode("MaxTimeInterval").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)maxTimeInterval))));
    }

    @Override
    public synchronized void setMinTimeInterval(Double minTimeInterval) {
        this.getPropertyNode("MinTimeInterval").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)minTimeInterval))));
    }

    @Override
    public synchronized void setExceptionDeviation(Double exceptionDeviation) {
        this.getPropertyNode("ExceptionDeviation").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)exceptionDeviation))));
    }

    @Override
    public synchronized void setExceptionDeviationFormat(ExceptionDeviationFormat exceptionDeviationFormat) {
        this.getPropertyNode("ExceptionDeviationFormat").ifPresent(n -> {
            Integer value = exceptionDeviationFormat.getValue();
            n.setValue(new DataValue(new Variant((Object)value)));
        });
    }

    @Override
    public synchronized void setStartOfArchive(DateTime startOfArchive) {
        this.getPropertyNode("StartOfArchive").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)startOfArchive))));
    }

    @Override
    public synchronized void setStartOfOnlineArchive(DateTime startOfOnlineArchive) {
        this.getPropertyNode("StartOfOnlineArchive").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)startOfOnlineArchive))));
    }
}

