/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.objects;

import com.digitalpetri.opcua.sdk.core.model.objects.FileType;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.objects.BaseObjectNode;
import com.digitalpetri.opcua.sdk.server.util.UaObjectType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.ULong;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UShort;
import java.util.Optional;

@UaObjectType(name="FileType")
public class FileNode
extends BaseObjectNode
implements FileType {
    public FileNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, UByte eventNotifier) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public ULong getSize() {
        Optional<Object> size = this.getProperty("Size");
        return size.orElse(null);
    }

    @Override
    public Boolean getWriteable() {
        Optional<Object> writeable = this.getProperty("Writeable");
        return writeable.orElse(null);
    }

    @Override
    public Boolean getUserWriteable() {
        Optional<Object> userWriteable = this.getProperty("UserWriteable");
        return userWriteable.orElse(null);
    }

    @Override
    public UShort getOpenCount() {
        Optional<Object> openCount = this.getProperty("OpenCount");
        return openCount.orElse(null);
    }

    @Override
    public synchronized void setSize(ULong size) {
        this.getPropertyNode("Size").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)size))));
    }

    @Override
    public synchronized void setWriteable(Boolean writeable) {
        this.getPropertyNode("Writeable").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)writeable))));
    }

    @Override
    public synchronized void setUserWriteable(Boolean userWriteable) {
        this.getPropertyNode("UserWriteable").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)userWriteable))));
    }

    @Override
    public synchronized void setOpenCount(UShort openCount) {
        this.getPropertyNode("OpenCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)openCount))));
    }
}

