/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model;

import com.digitalpetri.opcua.sdk.core.model.UaOptional;
import com.digitalpetri.opcua.sdk.core.nodes.VariableTypeNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.Property;
import com.digitalpetri.opcua.sdk.server.model.UaNode;
import com.digitalpetri.opcua.stack.core.Identifiers;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.enumerated.NodeClass;
import java.util.Optional;

public class UaVariableTypeNode
extends UaNode
implements VariableTypeNode {
    private volatile Optional<DataValue> value;
    private volatile NodeId dataType;
    private volatile int valueRank;
    private volatile Optional<UInteger[]> arrayDimensions;
    private volatile boolean isAbstract;
    public static final Property<String> NodeVersion = new Property.BasicProperty<String>(new QualifiedName(0, "NodeVersion"), Identifiers.String, -1, String.class);

    public UaVariableTypeNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, Optional<DataValue> value, NodeId dataType, int valueRank, Optional<UInteger[]> arrayDimensions, boolean isAbstract) {
        super(namespace, nodeId, NodeClass.VariableType, browseName, displayName, description, writeMask, userWriteMask);
        this.value = value;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.isAbstract = isAbstract;
    }

    @Override
    public Optional<DataValue> getValue() {
        return this.value;
    }

    @Override
    public NodeId getDataType() {
        return this.dataType;
    }

    @Override
    public Integer getValueRank() {
        return this.valueRank;
    }

    @Override
    public Optional<UInteger[]> getArrayDimensions() {
        return this.arrayDimensions;
    }

    @Override
    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    @Override
    public synchronized void setValue(Optional<DataValue> value) {
        this.value = value;
        value.ifPresent(v -> this.fireAttributeChanged(13, v));
    }

    @Override
    public synchronized void setDataType(NodeId dataType) {
        this.dataType = dataType;
        this.fireAttributeChanged(13, dataType);
    }

    @Override
    public synchronized void setValueRank(int valueRank) {
        this.valueRank = valueRank;
        this.fireAttributeChanged(15, valueRank);
    }

    @Override
    public synchronized void setArrayDimensions(Optional<UInteger[]> arrayDimensions) {
        this.arrayDimensions = arrayDimensions;
        arrayDimensions.ifPresent(v -> this.fireAttributeChanged(16, v));
    }

    @Override
    public synchronized void setIsAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        this.fireAttributeChanged(8, isAbstract);
    }

    @UaOptional(value="NodeVersion")
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }
}

