/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model;

import com.digitalpetri.opcua.sdk.core.Reference;
import com.digitalpetri.opcua.sdk.core.model.UaOptional;
import com.digitalpetri.opcua.sdk.core.nodes.Node;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectNode;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectTypeNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.Property;
import com.digitalpetri.opcua.sdk.server.model.UaNode;
import com.digitalpetri.opcua.sdk.server.util.StreamUtil;
import com.digitalpetri.opcua.stack.core.Identifiers;
import com.digitalpetri.opcua.stack.core.types.builtin.ByteString;
import com.digitalpetri.opcua.stack.core.types.builtin.ExpandedNodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.Unsigned;
import com.digitalpetri.opcua.stack.core.types.enumerated.NamingRuleType;
import com.digitalpetri.opcua.stack.core.types.enumerated.NodeClass;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class UaObjectNode
extends UaNode
implements ObjectNode {
    private volatile UByte eventNotifier = Unsigned.ubyte((int)0);
    public static final Property<String> NodeVersion = new Property.BasicProperty<String>(new QualifiedName(0, "NodeVersion"), Identifiers.String, -1, String.class);
    public static final Property<ByteString> Icon = new Property.BasicProperty<ByteString>(new QualifiedName(0, "Icon"), Identifiers.Image, -1, ByteString.class);
    public static final Property<NamingRuleType> NamingRule = new Property.BasicProperty<NamingRuleType>(new QualifiedName(0, "NamingRule"), Identifiers.NamingRuleType, -1, NamingRuleType.class);

    public UaObjectNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName) {
        super(namespace, nodeId, NodeClass.Object, browseName, displayName);
    }

    public UaObjectNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, UByte eventNotifier) {
        super(namespace, nodeId, NodeClass.Object, browseName, displayName, description, writeMask, userWriteMask);
        this.eventNotifier = eventNotifier;
    }

    @Override
    public UByte getEventNotifier() {
        return this.eventNotifier;
    }

    @Override
    public synchronized void setEventNotifier(UByte eventNotifier) {
        this.eventNotifier = eventNotifier;
        this.fireAttributeChanged(12, eventNotifier);
    }

    public List<Node> getComponentNodes() {
        return this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public List<Node> getPropertyNodes() {
        return this.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public ObjectTypeNode getTypeDefinitionNode() {
        Node node = this.getReferences().stream().filter(Reference.HAS_TYPE_DEFINITION_PREDICATE).findFirst().flatMap(r -> this.getNode(r.getTargetNodeId())).orElse(null);
        return node instanceof ObjectTypeNode ? (ObjectTypeNode)node : null;
    }

    public List<Node> getEventSourceNodes() {
        return this.getReferences().stream().filter(Reference.HAS_EVENT_SOURCE_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public List<Node> getNotifierNodes() {
        return this.getReferences().stream().filter(Reference.HAS_NOTIFIER_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public List<Node> getOrganizesNodes() {
        return this.getReferences().stream().filter(Reference.ORGANIZES_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public Optional<Node> getDescriptionNode() {
        Optional<Node> node = this.getReferences().stream().filter(Reference.HAS_DESCRIPTION_PREDICATE).findFirst().flatMap(r -> this.getNode(r.getTargetNodeId()));
        return node.map(n -> n);
    }

    public void addComponent(UaNode node) {
        this.addReference(new Reference(this.getNodeId(), Identifiers.HasComponent, node.getNodeId().expanded(), node.getNodeClass(), true));
        node.addReference(new Reference(node.getNodeId(), Identifiers.HasComponent, this.getNodeId().expanded(), this.getNodeClass(), false));
    }

    public void removeComponent(UaNode node) {
        this.removeReference(new Reference(this.getNodeId(), Identifiers.HasComponent, node.getNodeId().expanded(), node.getNodeClass(), true));
        node.removeReference(new Reference(node.getNodeId(), Identifiers.HasComponent, this.getNodeId().expanded(), this.getNodeClass(), false));
    }

    @UaOptional(value="NodeVersion")
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    @UaOptional(value="Icon")
    public ByteString getIcon() {
        return this.getProperty(Icon).orElse(null);
    }

    @UaOptional(value="NamingRule")
    public NamingRuleType getNamingRule() {
        return this.getProperty(NamingRule).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }

    public void setIcon(ByteString icon) {
        this.setProperty(Icon, icon);
    }

    public void setNamingRule(NamingRuleType namingRule) {
        this.setProperty(NamingRule, namingRule);
    }

    public static UaObjectNodeBuilder builder(UaNamespace nodeManager) {
        return new UaObjectNodeBuilder(nodeManager);
    }

    public static class UaObjectNodeBuilder
    implements Supplier<UaObjectNode> {
        private final List<Reference> references = Lists.newArrayList();
        private NodeId nodeId;
        private QualifiedName browseName;
        private LocalizedText displayName;
        private Optional<LocalizedText> description = Optional.empty();
        private Optional<UInteger> writeMask = Optional.of(Unsigned.uint((int)0));
        private Optional<UInteger> userWriteMask = Optional.of(Unsigned.uint((int)0));
        private UByte eventNotifier = Unsigned.ubyte((int)0);
        private final UaNamespace nodeManager;

        public UaObjectNodeBuilder(UaNamespace nodeManager) {
            this.nodeManager = nodeManager;
        }

        @Override
        public UaObjectNode get() {
            return this.build();
        }

        public UaObjectNode build() {
            Preconditions.checkNotNull((Object)this.nodeId, (Object)"NodeId cannot be null");
            Preconditions.checkNotNull((Object)this.browseName, (Object)"BrowseName cannot be null");
            Preconditions.checkNotNull((Object)this.displayName, (Object)"DisplayName cannot be null");
            long hasTypeDefinitionCount = this.references.stream().filter(r -> Identifiers.HasTypeDefinition.equals((Object)r.getReferenceTypeId())).count();
            Preconditions.checkState((hasTypeDefinitionCount == 1L ? 1 : 0) != 0, (Object)"Object Node must have exactly one HasTypeDefinition reference.");
            UaObjectNode node = new UaObjectNode(this.nodeManager, this.nodeId, this.browseName, this.displayName, this.description, this.writeMask, this.userWriteMask, this.eventNotifier);
            node.addReferences(this.references);
            return node;
        }

        public UaObjectNodeBuilder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public UaObjectNodeBuilder setBrowseName(QualifiedName browseName) {
            this.browseName = browseName;
            return this;
        }

        public UaObjectNodeBuilder setDisplayName(LocalizedText displayName) {
            this.displayName = displayName;
            return this;
        }

        public UaObjectNodeBuilder setDescription(LocalizedText description) {
            this.description = Optional.of(description);
            return this;
        }

        public UaObjectNodeBuilder setWriteMask(UInteger writeMask) {
            this.writeMask = Optional.of(writeMask);
            return this;
        }

        public UaObjectNodeBuilder setUserWriteMask(UInteger userWriteMask) {
            this.userWriteMask = Optional.of(userWriteMask);
            return this;
        }

        public UaObjectNodeBuilder setEventNotifier(UByte eventNotifier) {
            this.eventNotifier = eventNotifier;
            return this;
        }

        public UaObjectNodeBuilder addReference(Reference reference) {
            this.references.add(reference);
            return this;
        }

        public UaObjectNodeBuilder setTypeDefinition(NodeId typeDefinition) {
            Objects.requireNonNull(this.nodeId, "NodeId cannot be null");
            this.references.add(new Reference(this.nodeId, Identifiers.HasTypeDefinition, new ExpandedNodeId(typeDefinition), NodeClass.ObjectType, true));
            return this;
        }
    }
}

