/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model;

import com.digitalpetri.opcua.sdk.core.model.UaOptional;
import com.digitalpetri.opcua.sdk.core.nodes.DataTypeNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.Property;
import com.digitalpetri.opcua.sdk.server.model.UaNode;
import com.digitalpetri.opcua.stack.core.Identifiers;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.enumerated.NodeClass;
import com.digitalpetri.opcua.stack.core.types.structured.EnumValueType;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public class UaDataTypeNode
extends UaNode
implements DataTypeNode {
    private final AtomicBoolean isAbstract;
    public static final Property<String> NodeVersion = new Property.BasicProperty<String>(new QualifiedName(0, "NodeVersion"), Identifiers.String, -1, String.class);
    public static final Property<LocalizedText[]> EnumStrings = new Property.BasicProperty<LocalizedText[]>(new QualifiedName(0, "EnumStrings"), Identifiers.LocalizedText, 1, LocalizedText[].class);
    public static final Property<EnumValueType[]> EnumValues = new Property.BasicProperty<EnumValueType[]>(new QualifiedName(0, "EnumValues"), Identifiers.EnumValueType, 1, EnumValueType[].class);

    public UaDataTypeNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, boolean isAbstract) {
        super(namespace, nodeId, NodeClass.DataType, browseName, displayName, description, writeMask, userWriteMask);
        this.isAbstract = new AtomicBoolean(isAbstract);
    }

    @Override
    public Boolean getIsAbstract() {
        return this.isAbstract.get();
    }

    @Override
    public synchronized void setIsAbstract(boolean isAbstract) {
        this.isAbstract.set(isAbstract);
        this.fireAttributeChanged(8, isAbstract);
    }

    @UaOptional(value="NodeVersion")
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    @UaOptional(value="EnumStrings")
    public LocalizedText[] getEnumStrings() {
        return this.getProperty(EnumStrings).orElse(null);
    }

    @UaOptional(value="EnumValues")
    public EnumValueType[] getEnumValues() {
        return this.getProperty(EnumValues).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }

    public void setEnumStrings(LocalizedText[] enumStrings) {
        this.setProperty(EnumStrings, enumStrings);
    }

    public void setEnumValues(EnumValueType[] enumValues) {
        this.setProperty(EnumValues, enumValues);
    }
}

