/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.api;

import com.digitalpetri.opcua.sdk.core.Reference;
import com.digitalpetri.opcua.sdk.server.DiagnosticsContext;
import com.digitalpetri.opcua.sdk.server.OpcUaServer;
import com.digitalpetri.opcua.sdk.server.Session;
import com.digitalpetri.opcua.sdk.server.api.OperationContext;
import com.digitalpetri.opcua.sdk.server.services.helpers.BrowseHelper;
import com.digitalpetri.opcua.sdk.server.util.FutureUtils;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.structured.BrowseDescription;
import com.digitalpetri.opcua.stack.core.types.structured.BrowseResult;
import com.digitalpetri.opcua.stack.core.types.structured.ViewDescription;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public interface ViewManager {
    default public void browse(BrowseContext context, ViewDescription view, UInteger maxReferencesPerNode, List<BrowseDescription> nodesToBrowse) {
        OpcUaServer server = context.getServer();
        List futures = nodesToBrowse.stream().map(browseDescription -> BrowseHelper.browse(server, view, maxReferencesPerNode, browseDescription)).collect(Collectors.toList());
        FutureUtils.sequence(futures).thenAccept(context::complete);
    }

    public CompletableFuture<List<Reference>> getReferences(NodeId var1);

    public static final class BrowseContext
    extends OperationContext<BrowseDescription, BrowseResult> {
        public BrowseContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<BrowseDescription> diagnosticsContext) {
            super(server, session, diagnosticsContext);
        }

        public BrowseContext(OpcUaServer server, @Nullable Session session, CompletableFuture<List<BrowseResult>> future, DiagnosticsContext<BrowseDescription> diagnosticsContext) {
            super(server, session, future, diagnosticsContext);
        }
    }
}

