/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server;

import com.digitalpetri.opcua.sdk.server.OpcUaServer;
import com.digitalpetri.opcua.sdk.server.Session;
import com.digitalpetri.opcua.sdk.server.identity.IdentityValidator;
import com.digitalpetri.opcua.sdk.server.services.ServiceAttributes;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.UaRuntimeException;
import com.digitalpetri.opcua.stack.core.application.services.AttributeServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.MethodServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.MonitoredItemServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.NodeManagementServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.QueryServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.ServiceRequest;
import com.digitalpetri.opcua.stack.core.application.services.SessionServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.SubscriptionServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.ViewServiceSet;
import com.digitalpetri.opcua.stack.core.channel.SecureChannel;
import com.digitalpetri.opcua.stack.core.channel.ServerSecureChannel;
import com.digitalpetri.opcua.stack.core.security.SecurityAlgorithm;
import com.digitalpetri.opcua.stack.core.security.SecurityPolicy;
import com.digitalpetri.opcua.stack.core.serialization.UaResponseMessage;
import com.digitalpetri.opcua.stack.core.types.builtin.ByteString;
import com.digitalpetri.opcua.stack.core.types.builtin.DiagnosticInfo;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.StatusCode;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.Unsigned;
import com.digitalpetri.opcua.stack.core.types.structured.ActivateSessionRequest;
import com.digitalpetri.opcua.stack.core.types.structured.ActivateSessionResponse;
import com.digitalpetri.opcua.stack.core.types.structured.AddNodesRequest;
import com.digitalpetri.opcua.stack.core.types.structured.AddNodesResponse;
import com.digitalpetri.opcua.stack.core.types.structured.AddReferencesRequest;
import com.digitalpetri.opcua.stack.core.types.structured.AddReferencesResponse;
import com.digitalpetri.opcua.stack.core.types.structured.AnonymousIdentityToken;
import com.digitalpetri.opcua.stack.core.types.structured.BrowseNextRequest;
import com.digitalpetri.opcua.stack.core.types.structured.BrowseNextResponse;
import com.digitalpetri.opcua.stack.core.types.structured.BrowseRequest;
import com.digitalpetri.opcua.stack.core.types.structured.BrowseResponse;
import com.digitalpetri.opcua.stack.core.types.structured.CallRequest;
import com.digitalpetri.opcua.stack.core.types.structured.CallResponse;
import com.digitalpetri.opcua.stack.core.types.structured.CancelRequest;
import com.digitalpetri.opcua.stack.core.types.structured.CancelResponse;
import com.digitalpetri.opcua.stack.core.types.structured.CloseSessionRequest;
import com.digitalpetri.opcua.stack.core.types.structured.CloseSessionResponse;
import com.digitalpetri.opcua.stack.core.types.structured.CreateMonitoredItemsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.CreateMonitoredItemsResponse;
import com.digitalpetri.opcua.stack.core.types.structured.CreateSessionRequest;
import com.digitalpetri.opcua.stack.core.types.structured.CreateSessionResponse;
import com.digitalpetri.opcua.stack.core.types.structured.CreateSubscriptionRequest;
import com.digitalpetri.opcua.stack.core.types.structured.CreateSubscriptionResponse;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteMonitoredItemsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteMonitoredItemsResponse;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteNodesRequest;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteNodesResponse;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteReferencesRequest;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteReferencesResponse;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteSubscriptionsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteSubscriptionsResponse;
import com.digitalpetri.opcua.stack.core.types.structured.EndpointDescription;
import com.digitalpetri.opcua.stack.core.types.structured.HistoryReadRequest;
import com.digitalpetri.opcua.stack.core.types.structured.HistoryReadResponse;
import com.digitalpetri.opcua.stack.core.types.structured.HistoryUpdateRequest;
import com.digitalpetri.opcua.stack.core.types.structured.HistoryUpdateResponse;
import com.digitalpetri.opcua.stack.core.types.structured.IssuedIdentityToken;
import com.digitalpetri.opcua.stack.core.types.structured.ModifyMonitoredItemsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.ModifyMonitoredItemsResponse;
import com.digitalpetri.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import com.digitalpetri.opcua.stack.core.types.structured.ModifySubscriptionResponse;
import com.digitalpetri.opcua.stack.core.types.structured.PublishRequest;
import com.digitalpetri.opcua.stack.core.types.structured.PublishResponse;
import com.digitalpetri.opcua.stack.core.types.structured.QueryFirstRequest;
import com.digitalpetri.opcua.stack.core.types.structured.QueryFirstResponse;
import com.digitalpetri.opcua.stack.core.types.structured.QueryNextRequest;
import com.digitalpetri.opcua.stack.core.types.structured.QueryNextResponse;
import com.digitalpetri.opcua.stack.core.types.structured.ReadRequest;
import com.digitalpetri.opcua.stack.core.types.structured.ReadResponse;
import com.digitalpetri.opcua.stack.core.types.structured.RegisterNodesRequest;
import com.digitalpetri.opcua.stack.core.types.structured.RegisterNodesResponse;
import com.digitalpetri.opcua.stack.core.types.structured.RepublishRequest;
import com.digitalpetri.opcua.stack.core.types.structured.RepublishResponse;
import com.digitalpetri.opcua.stack.core.types.structured.SetMonitoringModeRequest;
import com.digitalpetri.opcua.stack.core.types.structured.SetMonitoringModeResponse;
import com.digitalpetri.opcua.stack.core.types.structured.SetPublishingModeRequest;
import com.digitalpetri.opcua.stack.core.types.structured.SetPublishingModeResponse;
import com.digitalpetri.opcua.stack.core.types.structured.SetTriggeringRequest;
import com.digitalpetri.opcua.stack.core.types.structured.SetTriggeringResponse;
import com.digitalpetri.opcua.stack.core.types.structured.SignatureData;
import com.digitalpetri.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import com.digitalpetri.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.TransferSubscriptionsResponse;
import com.digitalpetri.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import com.digitalpetri.opcua.stack.core.types.structured.UnregisterNodesRequest;
import com.digitalpetri.opcua.stack.core.types.structured.UnregisterNodesResponse;
import com.digitalpetri.opcua.stack.core.types.structured.UserIdentityToken;
import com.digitalpetri.opcua.stack.core.types.structured.UserNameIdentityToken;
import com.digitalpetri.opcua.stack.core.types.structured.UserTokenPolicy;
import com.digitalpetri.opcua.stack.core.types.structured.WriteRequest;
import com.digitalpetri.opcua.stack.core.types.structured.WriteResponse;
import com.digitalpetri.opcua.stack.core.types.structured.X509IdentityToken;
import com.digitalpetri.opcua.stack.core.util.CertificateUtil;
import com.digitalpetri.opcua.stack.core.util.NonceUtil;
import com.digitalpetri.opcua.stack.core.util.SignatureUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.Bytes;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager
implements AttributeServiceSet,
MethodServiceSet,
MonitoredItemServiceSet,
NodeManagementServiceSet,
QueryServiceSet,
SessionServiceSet,
SubscriptionServiceSet,
ViewServiceSet {
    private static final int MAX_SESSION_TIMEOUT_MS = 120000;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<NodeId, Session> createdSessions = Maps.newConcurrentMap();
    private final Map<NodeId, Session> activeSessions = Maps.newConcurrentMap();
    private final Map<NodeId, Session> inactiveSessions = Maps.newConcurrentMap();
    private final List<ByteString> clientNonces = Lists.newCopyOnWriteArrayList();
    private final OpcUaServer server;

    public SessionManager(OpcUaServer server) {
        this.server = server;
    }

    public List<Session> getActiveSessions() {
        return Lists.newArrayList(this.activeSessions.values());
    }

    public List<Session> getInactiveSessions() {
        return Lists.newArrayList(this.inactiveSessions.values());
    }

    public void killSession(NodeId nodeId, boolean deleteSubscriptions) {
        this.activeSessions.values().stream().filter(s -> s.getSessionId().equals((Object)nodeId)).findFirst().ifPresent(s -> s.close(deleteSubscriptions));
    }

    private Session session(ServiceRequest<?, ?> service) throws UaException {
        long secureChannelId = service.getSecureChannel().getChannelId();
        NodeId authToken = service.getRequest().getRequestHeader().getAuthenticationToken();
        Session session = this.activeSessions.get(authToken);
        if (session == null) {
            session = this.createdSessions.remove(authToken);
            if (session == null) {
                throw new UaException(2149908480L);
            }
            if (session.getSecureChannelId() != secureChannelId) {
                this.createdSessions.put(authToken, session);
                throw new UaException(2148728832L);
            }
            throw new UaException(2150039552L);
        }
        if (session.getSecureChannelId() != secureChannelId) {
            throw new UaException(0x80220000L);
        }
        session.updateLastActivity();
        service.attr(ServiceAttributes.SERVER_KEY).set((Object)this.server);
        service.attr(ServiceAttributes.SESSION_KEY).set((Object)session);
        return session;
    }

    public void onCreateSession(ServiceRequest<CreateSessionRequest, CreateSessionResponse> serviceRequest) throws UaException {
        ByteString clientCertificate;
        CreateSessionRequest request = (CreateSessionRequest)serviceRequest.getRequest();
        long maxSessionCount = this.server.getConfig().getLimits().getMaxSessionCount().longValue();
        if ((long)(this.createdSessions.size() + this.activeSessions.size()) >= maxSessionCount) {
            serviceRequest.setServiceFault(2153119744L);
            return;
        }
        ByteString serverNonce = NonceUtil.generateNonce((int)32);
        NodeId authenticationToken = new NodeId(0, NonceUtil.generateNonce((int)32));
        long maxRequestMessageSize = serviceRequest.getServer().getChannelConfig().getMaxMessageSize();
        double revisedSessionTimeout = Math.max(5000.0, Math.min(120000.0, request.getRequestedSessionTimeout()));
        ServerSecureChannel secureChannel = serviceRequest.getSecureChannel();
        SecurityPolicy securityPolicy = secureChannel.getSecurityPolicy();
        ByteString serverCertificate = serviceRequest.getSecureChannel().getEndpointDescription().getServerCertificate();
        SignedSoftwareCertificate[] serverSoftwareCertificates = this.server.getSoftwareCertificates();
        EndpointDescription[] serverEndpoints = this.server.getEndpointDescriptions();
        ByteString clientNonce = request.getClientNonce();
        if (clientNonce.isNotNull() && clientNonce.length() < 32) {
            throw new UaException(2149842944L);
        }
        if (securityPolicy != SecurityPolicy.None && this.clientNonces.contains(clientNonce)) {
            throw new UaException(2149842944L);
        }
        if (securityPolicy != SecurityPolicy.None && clientNonce.isNotNull()) {
            this.clientNonces.add(clientNonce);
            while (this.clientNonces.size() > 64) {
                this.clientNonces.remove(0);
            }
        }
        if ((clientCertificate = request.getClientCertificate()).isNotNull() && secureChannel.getSecurityPolicy() != SecurityPolicy.None) {
            String applicationUri = request.getClientDescription().getApplicationUri();
            X509Certificate certificate = CertificateUtil.decodeCertificate((byte[])clientCertificate.bytes());
            this.validateApplicationUri(applicationUri, certificate);
        }
        SignatureData serverSignature = this.getServerSignature(clientNonce, clientCertificate, securityPolicy, secureChannel.getKeyPair());
        NodeId sessionId = new NodeId(1, "Session:" + UUID.randomUUID());
        String sessionName = request.getSessionName();
        String endpointUrl = request.getEndpointUrl();
        Duration sessionTimeout = Duration.ofMillis(DoubleMath.roundToLong((double)revisedSessionTimeout, (RoundingMode)RoundingMode.UP));
        Session session = new Session(this.server, sessionId, sessionName, sessionTimeout, secureChannel.getChannelId());
        this.createdSessions.put(authenticationToken, session);
        session.addLifecycleListener((s, remove) -> {
            this.createdSessions.remove(authenticationToken);
            this.activeSessions.remove(authenticationToken);
        });
        session.setLastNonce(serverNonce);
        CreateSessionResponse response = new CreateSessionResponse(serviceRequest.createResponseHeader(), sessionId, authenticationToken, Double.valueOf(revisedSessionTimeout), serverNonce, serverCertificate, serverEndpoints, serverSoftwareCertificates, serverSignature, Unsigned.uint((long)maxRequestMessageSize));
        serviceRequest.setResponse((UaResponseMessage)response);
    }

    private void validateApplicationUri(String applicationUri, X509Certificate certificate) throws UaException {
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames == null) {
                subjectAltNames = Collections.emptyList();
            }
            for (List<?> idAndValue : subjectAltNames) {
                if (idAndValue == null || idAndValue.size() != 2 || !idAndValue.get(0).equals(6)) continue;
                String certificateUri = (String)idAndValue.get(1);
                if (!applicationUri.equals(certificateUri)) {
                    String message = String.format("Certificate URI does not match. certificateUri=%s, applicationUri=%s", certificateUri, applicationUri);
                    this.logger.warn(message);
                    throw new UaException(2148990976L, message);
                }
                return;
            }
            String message = "Certificate does not contain a SubjectAlternativeName URI entry.";
            throw new UaException(2148990976L, message);
        }
        catch (CertificateParsingException e) {
            this.logger.warn("Error parsing client certificate.", (Throwable)e);
            throw new UaException(2148663296L);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onActivateSession(ServiceRequest<ActivateSessionRequest, ActivateSessionResponse> serviceRequest) throws UaException {
        ActivateSessionRequest request = (ActivateSessionRequest)serviceRequest.getRequest();
        ServerSecureChannel secureChannel = serviceRequest.getSecureChannel();
        long secureChannelId = secureChannel.getChannelId();
        NodeId authToken = request.getRequestHeader().getAuthenticationToken();
        SignedSoftwareCertificate[] clientSoftwareCertificates = request.getClientSoftwareCertificates();
        Session session = this.createdSessions.get(authToken);
        if (session == null) {
            session = this.activeSessions.get(authToken);
            if (session == null) {
                throw new UaException(2149908480L);
            }
            if (session.getSecureChannelId() == secureChannelId) {
                Object tokenObject = request.getUserIdentityToken().decode();
                Object identityObject = this.validateIdentityToken(secureChannel, session, tokenObject);
                session.setIdentityObject(identityObject);
                Object[] results = new StatusCode[clientSoftwareCertificates.length];
                Arrays.fill(results, StatusCode.GOOD);
                ByteString serverNonce = NonceUtil.generateNonce((int)32);
                session.setLastNonce(serverNonce);
                ActivateSessionResponse response = new ActivateSessionResponse(serviceRequest.createResponseHeader(), serverNonce, (StatusCode[])results, new DiagnosticInfo[0]);
                serviceRequest.setResponse((UaResponseMessage)response);
                return;
            } else {
                ByteString certificateBytes = secureChannel.getRemoteCertificateBytes();
                if (request.getUserIdentityToken() == null || request.getUserIdentityToken().decode() == null) {
                    throw new UaException(0x80200000L, "identity token not provided");
                }
                Object tokenObject = request.getUserIdentityToken().decode();
                Object identityObject = this.validateIdentityToken(secureChannel, session, tokenObject);
                if (!identityObject.equals(session.getIdentityObject()) || !certificateBytes.equals((Object)session.getClientCertificateBytes())) throw new UaException(2148728832L);
                session.setSecureChannelId(secureChannelId);
                this.logger.debug("Session id={} is now associated with secureChannelId={}", (Object)session.getSessionId(), (Object)secureChannelId);
                Object[] results = new StatusCode[clientSoftwareCertificates.length];
                Arrays.fill(results, StatusCode.GOOD);
                ByteString serverNonce = NonceUtil.generateNonce((int)32);
                session.setLastNonce(serverNonce);
                ActivateSessionResponse response = new ActivateSessionResponse(serviceRequest.createResponseHeader(), serverNonce, (StatusCode[])results, new DiagnosticInfo[0]);
                serviceRequest.setResponse((UaResponseMessage)response);
            }
            return;
        } else {
            if (secureChannelId != session.getSecureChannelId()) {
                throw new UaException(2148728832L);
            }
            if (request.getUserIdentityToken() == null || request.getUserIdentityToken().decode() == null) {
                throw new UaException(0x80200000L, "identity token not provided");
            }
            Object tokenObject = request.getUserIdentityToken().decode();
            Object identityObject = this.validateIdentityToken(secureChannel, session, tokenObject);
            session.setIdentityObject(identityObject);
            this.createdSessions.remove(authToken);
            this.activeSessions.put(authToken, session);
            session.setClientCertificateBytes(secureChannel.getRemoteCertificateBytes());
            Object[] results = new StatusCode[clientSoftwareCertificates.length];
            Arrays.fill(results, StatusCode.GOOD);
            ByteString serverNonce = NonceUtil.generateNonce((int)32);
            session.setLastNonce(serverNonce);
            ActivateSessionResponse response = new ActivateSessionResponse(serviceRequest.createResponseHeader(), serverNonce, (StatusCode[])results, new DiagnosticInfo[0]);
            serviceRequest.setResponse((UaResponseMessage)response);
        }
    }

    private Object validateIdentityToken(ServerSecureChannel secureChannel, Session session, Object tokenObject) throws UaException {
        IdentityValidator identityValidator = this.server.getConfig().getIdentityValidator();
        UserTokenPolicy tokenPolicy = this.validatePolicyId(tokenObject);
        if (tokenObject instanceof AnonymousIdentityToken) {
            AnonymousIdentityToken token = (AnonymousIdentityToken)tokenObject;
            return identityValidator.validateAnonymousToken(token, tokenPolicy, (SecureChannel)secureChannel, session);
        }
        if (tokenObject instanceof UserNameIdentityToken) {
            UserNameIdentityToken token = (UserNameIdentityToken)tokenObject;
            return identityValidator.validateUsernameToken(token, tokenPolicy, (SecureChannel)secureChannel, session);
        }
        if (tokenObject instanceof X509IdentityToken) {
            X509IdentityToken token = (X509IdentityToken)tokenObject;
            return identityValidator.validateX509Token(token, tokenPolicy, (SecureChannel)secureChannel, session);
        }
        if (tokenObject instanceof IssuedIdentityToken) {
            IssuedIdentityToken token = (IssuedIdentityToken)tokenObject;
            return identityValidator.validateIssuedIdentityToken(token, tokenPolicy, (SecureChannel)secureChannel, session);
        }
        throw new UaException(0x80200000L);
    }

    private UserTokenPolicy validatePolicyId(Object tokenObject) throws UaException {
        if (tokenObject instanceof UserIdentityToken) {
            UserIdentityToken token = (UserIdentityToken)tokenObject;
            String policyId = token.getPolicyId();
            for (UserTokenPolicy policy : this.server.getUserTokenPolicies()) {
                if (!policyId.equals(policy.getPolicyId())) continue;
                return policy;
            }
            throw new UaException(0x80200000L, "policy not found: " + policyId);
        }
        throw new UaException(0x80200000L);
    }

    public void onCloseSession(ServiceRequest<CloseSessionRequest, CloseSessionResponse> service) throws UaException {
        this.session(service).onCloseSession(service);
        this.activeSessions.remove(((CloseSessionRequest)service.getRequest()).getRequestHeader().getAuthenticationToken());
    }

    public void onCancel(ServiceRequest<CancelRequest, CancelResponse> service) throws UaException {
        this.session(service).onCancel(service);
    }

    private SignatureData getServerSignature(ByteString clientNonce, ByteString clientCertificate, SecurityPolicy securityPolicy, KeyPair keyPair) throws UaException {
        if (clientNonce.isNull() || clientCertificate.isNull() || keyPair == null) {
            return new SignatureData(null, null);
        }
        try {
            SecurityAlgorithm algorithm = securityPolicy.getAsymmetricSignatureAlgorithm();
            byte[] data = Bytes.concat((byte[][])new byte[][]{clientCertificate.bytes(), clientNonce.bytes()});
            byte[] signature = SignatureUtil.sign((SecurityAlgorithm)algorithm, (PrivateKey)keyPair.getPrivate(), (ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(data)});
            return new SignatureData(algorithm.getUri(), ByteString.of((byte[])signature));
        }
        catch (UaRuntimeException e) {
            throw new UaException(2148728832L);
        }
    }

    public void onRead(ServiceRequest<ReadRequest, ReadResponse> service) throws UaException {
        Session session = this.session(service);
        session.getAttributeServices().onRead(service);
    }

    public void onWrite(ServiceRequest<WriteRequest, WriteResponse> service) throws UaException {
        Session session = this.session(service);
        session.getAttributeServices().onWrite(service);
    }

    public void onHistoryRead(ServiceRequest<HistoryReadRequest, HistoryReadResponse> service) throws UaException {
        Session session = this.session(service);
        session.getAttributeServices().onHistoryRead(service);
    }

    public void onHistoryUpdate(ServiceRequest<HistoryUpdateRequest, HistoryUpdateResponse> service) throws UaException {
        Session session = this.session(service);
        session.getAttributeServices().onHistoryUpdate(service);
    }

    public void onBrowse(ServiceRequest<BrowseRequest, BrowseResponse> service) throws UaException {
        Session session = this.session(service);
        session.getViewServices().onBrowse(service);
    }

    public void onBrowseNext(ServiceRequest<BrowseNextRequest, BrowseNextResponse> service) throws UaException {
        Session session = this.session(service);
        session.getViewServices().onBrowseNext(service);
    }

    public void onTranslateBrowsePaths(ServiceRequest<TranslateBrowsePathsToNodeIdsRequest, TranslateBrowsePathsToNodeIdsResponse> service) throws UaException {
        Session session = this.session(service);
        session.getViewServices().onTranslateBrowsePaths(service);
    }

    public void onRegisterNodes(ServiceRequest<RegisterNodesRequest, RegisterNodesResponse> service) throws UaException {
        Session session = this.session(service);
        session.getViewServices().onRegisterNodes(service);
    }

    public void onUnregisterNodes(ServiceRequest<UnregisterNodesRequest, UnregisterNodesResponse> service) throws UaException {
        Session session = this.session(service);
        session.getViewServices().onUnregisterNodes(service);
    }

    public void onAddNodes(ServiceRequest<AddNodesRequest, AddNodesResponse> service) throws UaException {
        Session session = this.session(service);
        session.getNodeManagementServices().onAddNodes(service);
    }

    public void onAddReferences(ServiceRequest<AddReferencesRequest, AddReferencesResponse> service) throws UaException {
        Session session = this.session(service);
        session.getNodeManagementServices().onAddReferences(service);
    }

    public void onDeleteNodes(ServiceRequest<DeleteNodesRequest, DeleteNodesResponse> service) throws UaException {
        Session session = this.session(service);
        session.getNodeManagementServices().onDeleteNodes(service);
    }

    public void onDeleteReferences(ServiceRequest<DeleteReferencesRequest, DeleteReferencesResponse> service) throws UaException {
        Session session = this.session(service);
        session.getNodeManagementServices().onDeleteReferences(service);
    }

    public void onCreateSubscription(ServiceRequest<CreateSubscriptionRequest, CreateSubscriptionResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onCreateSubscription(service);
    }

    public void onModifySubscription(ServiceRequest<ModifySubscriptionRequest, ModifySubscriptionResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onModifySubscription(service);
    }

    public void onSetPublishingMode(ServiceRequest<SetPublishingModeRequest, SetPublishingModeResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onSetPublishingMode(service);
    }

    public void onPublish(ServiceRequest<PublishRequest, PublishResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onPublish(service);
    }

    public void onRepublish(ServiceRequest<RepublishRequest, RepublishResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onRepublish(service);
    }

    public void onTransferSubscriptions(ServiceRequest<TransferSubscriptionsRequest, TransferSubscriptionsResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onTransferSubscriptions(service);
    }

    public void onDeleteSubscriptions(ServiceRequest<DeleteSubscriptionsRequest, DeleteSubscriptionsResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onDeleteSubscriptions(service);
    }

    public void onCreateMonitoredItems(ServiceRequest<CreateMonitoredItemsRequest, CreateMonitoredItemsResponse> service) throws UaException {
        Session session = this.session(service);
        session.getMonitoredItemServices().onCreateMonitoredItems(service);
    }

    public void onModifyMonitoredItems(ServiceRequest<ModifyMonitoredItemsRequest, ModifyMonitoredItemsResponse> service) throws UaException {
        Session session = this.session(service);
        session.getMonitoredItemServices().onModifyMonitoredItems(service);
    }

    public void onSetMonitoringMode(ServiceRequest<SetMonitoringModeRequest, SetMonitoringModeResponse> service) throws UaException {
        Session session = this.session(service);
        session.getMonitoredItemServices().onSetMonitoringMode(service);
    }

    public void onSetTriggering(ServiceRequest<SetTriggeringRequest, SetTriggeringResponse> service) throws UaException {
        Session session = this.session(service);
        session.getMonitoredItemServices().onSetTriggering(service);
    }

    public void onDeleteMonitoredItems(ServiceRequest<DeleteMonitoredItemsRequest, DeleteMonitoredItemsResponse> service) throws UaException {
        Session session = this.session(service);
        session.getMonitoredItemServices().onDeleteMonitoredItems(service);
    }

    public void onCall(ServiceRequest<CallRequest, CallResponse> service) throws UaException {
        Session session = this.session(service);
        session.getMethodServices().onCall(service);
    }

    public void onQueryFirst(ServiceRequest<QueryFirstRequest, QueryFirstResponse> service) throws UaException {
        Session session = this.session(service);
        session.getQueryServices().onQueryFirst(service);
    }

    public void onQueryNext(ServiceRequest<QueryNextRequest, QueryNextResponse> service) throws UaException {
        Session session = this.session(service);
        session.getQueryServices().onQueryNext(service);
    }
}

