/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.core;

import com.digitalpetri.opcua.sdk.core.AccessLevel;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import java.util.EnumSet;

public enum WriteMask {
    AccessLevel(1),
    ArrayDimensions(2),
    BrowseName(4),
    ContainsNoLoops(8),
    DataType(16),
    Description(32),
    DisplayName(64),
    EventNotifier(128),
    Executable(256),
    Historizing(512),
    InverseName(1024),
    IsAbstract(2048),
    MinimumSamplingInterval(4096),
    NodeClass(8192),
    NodeId(16384),
    Symmetric(32768),
    UserAccessLevel(65536),
    UserExecutable(131072),
    UserWriteMask(262144),
    ValueRank(524288),
    WriteMask(0x100000),
    ValueForVariableType(0x200000);

    public static final EnumSet<AccessLevel> None;
    private final int value;

    private WriteMask(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static EnumSet<WriteMask> fromMask(int accessLevel) {
        EnumSet<WriteMask> e = EnumSet.noneOf(WriteMask.class);
        for (WriteMask wm : com.digitalpetri.opcua.sdk.core.WriteMask.values()) {
            if ((wm.value & accessLevel) == 0) continue;
            e.add(wm);
        }
        return e;
    }

    public static EnumSet<WriteMask> fromMask(UInteger accessLevel) {
        return com.digitalpetri.opcua.sdk.core.WriteMask.fromMask(accessLevel.intValue());
    }

    static {
        None = EnumSet.noneOf(AccessLevel.class);
    }
}

