/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.core;

import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import java.util.EnumSet;

public enum AccessLevel {
    CurrentRead(1),
    CurrentWrite(2),
    HistoryRead(4),
    HistoryWrite(8),
    SemanticChange(16);

    public static final EnumSet<AccessLevel> NONE;
    public static final EnumSet<AccessLevel> READ_ONLY;
    public static final EnumSet<AccessLevel> READ_WRITE;
    public static final EnumSet<AccessLevel> HISTORY_READ_ONLY;
    public static final EnumSet<AccessLevel> HISTORY_READ_WRITE;
    private final int value;

    private AccessLevel(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static short getMask(AccessLevel ... levels) {
        short result = 0;
        for (AccessLevel level : levels) {
            result = (short)(result | level.value);
        }
        return result;
    }

    public static short getMask(EnumSet<AccessLevel> levels) {
        short result = 0;
        for (AccessLevel level : levels) {
            result = (short)(result | level.value);
        }
        return result;
    }

    public static EnumSet<AccessLevel> fromMask(int accessLevel) {
        EnumSet<AccessLevel> e = EnumSet.noneOf(AccessLevel.class);
        for (AccessLevel al : AccessLevel.values()) {
            if ((al.value & accessLevel) == 0) continue;
            e.add(al);
        }
        return e;
    }

    public static EnumSet<AccessLevel> fromMask(UByte accessLevel) {
        return AccessLevel.fromMask(accessLevel.intValue());
    }

    static {
        NONE = EnumSet.noneOf(AccessLevel.class);
        READ_ONLY = EnumSet.of(CurrentRead);
        READ_WRITE = EnumSet.of(CurrentRead, CurrentWrite);
        HISTORY_READ_ONLY = EnumSet.of(HistoryRead);
        HISTORY_READ_WRITE = EnumSet.of(HistoryRead, HistoryWrite);
    }
}

