/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.util;

import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.types.builtin.StatusCode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class FutureUtils {
    public static <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture[] fa = futures.toArray(new CompletableFuture[futures.size()]);
        return CompletableFuture.allOf(fa).thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<List<T>> sequence(CompletableFuture<T>[] futures) {
        if (futures.length == 0) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.allOf(futures).thenApply(v -> Arrays.stream(futures).map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable ex) {
        CompletableFuture f = new CompletableFuture();
        f.completeExceptionally(ex);
        return f;
    }

    public static <T> CompletableFuture<T> failedUaFuture(long statusCode) {
        return FutureUtils.failedUaFuture(new StatusCode(statusCode));
    }

    public static <T> CompletableFuture<T> failedUaFuture(StatusCode statusCode) {
        return FutureUtils.failedFuture(new UaException(statusCode));
    }
}

