/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.subscriptions;

import com.digitalpetri.opcua.sdk.core.AccessLevel;
import com.digitalpetri.opcua.sdk.core.NumericRange;
import com.digitalpetri.opcua.sdk.server.DiagnosticsContext;
import com.digitalpetri.opcua.sdk.server.OpcUaServer;
import com.digitalpetri.opcua.sdk.server.Session;
import com.digitalpetri.opcua.sdk.server.api.AttributeManager;
import com.digitalpetri.opcua.sdk.server.api.DataItem;
import com.digitalpetri.opcua.sdk.server.api.EventItem;
import com.digitalpetri.opcua.sdk.server.api.MonitoredItem;
import com.digitalpetri.opcua.sdk.server.api.Namespace;
import com.digitalpetri.opcua.sdk.server.items.BaseMonitoredItem;
import com.digitalpetri.opcua.sdk.server.items.MonitoredDataItem;
import com.digitalpetri.opcua.sdk.server.items.MonitoredEventItem;
import com.digitalpetri.opcua.sdk.server.subscriptions.PendingItemCreation;
import com.digitalpetri.opcua.sdk.server.subscriptions.PendingItemModification;
import com.digitalpetri.opcua.sdk.server.subscriptions.PublishQueue;
import com.digitalpetri.opcua.sdk.server.subscriptions.Subscription;
import com.digitalpetri.opcua.sdk.server.util.FutureUtils;
import com.digitalpetri.opcua.stack.core.AttributeId;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.application.services.ServiceRequest;
import com.digitalpetri.opcua.stack.core.serialization.UaResponseMessage;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DiagnosticInfo;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.StatusCode;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UShort;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.Unsigned;
import com.digitalpetri.opcua.stack.core.types.enumerated.MonitoringMode;
import com.digitalpetri.opcua.stack.core.types.enumerated.TimestampsToReturn;
import com.digitalpetri.opcua.stack.core.types.structured.CreateMonitoredItemsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.CreateMonitoredItemsResponse;
import com.digitalpetri.opcua.stack.core.types.structured.CreateSubscriptionRequest;
import com.digitalpetri.opcua.stack.core.types.structured.CreateSubscriptionResponse;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteMonitoredItemsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteMonitoredItemsResponse;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteSubscriptionsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteSubscriptionsResponse;
import com.digitalpetri.opcua.stack.core.types.structured.ModifyMonitoredItemsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.ModifyMonitoredItemsResponse;
import com.digitalpetri.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import com.digitalpetri.opcua.stack.core.types.structured.ModifySubscriptionResponse;
import com.digitalpetri.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import com.digitalpetri.opcua.stack.core.types.structured.MonitoredItemCreateResult;
import com.digitalpetri.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import com.digitalpetri.opcua.stack.core.types.structured.MonitoredItemModifyResult;
import com.digitalpetri.opcua.stack.core.types.structured.MonitoringParameters;
import com.digitalpetri.opcua.stack.core.types.structured.NotificationMessage;
import com.digitalpetri.opcua.stack.core.types.structured.PublishRequest;
import com.digitalpetri.opcua.stack.core.types.structured.PublishResponse;
import com.digitalpetri.opcua.stack.core.types.structured.ReadValueId;
import com.digitalpetri.opcua.stack.core.types.structured.RepublishRequest;
import com.digitalpetri.opcua.stack.core.types.structured.RepublishResponse;
import com.digitalpetri.opcua.stack.core.types.structured.ResponseHeader;
import com.digitalpetri.opcua.stack.core.types.structured.SetMonitoringModeRequest;
import com.digitalpetri.opcua.stack.core.types.structured.SetMonitoringModeResponse;
import com.digitalpetri.opcua.stack.core.types.structured.SetPublishingModeRequest;
import com.digitalpetri.opcua.stack.core.types.structured.SetPublishingModeResponse;
import com.digitalpetri.opcua.stack.core.types.structured.SetTriggeringRequest;
import com.digitalpetri.opcua.stack.core.types.structured.SetTriggeringResponse;
import com.digitalpetri.opcua.stack.core.types.structured.SubscriptionAcknowledgement;
import com.digitalpetri.opcua.stack.core.util.ConversionUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.lambda.tuple.Tuple3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionManager {
    private static final QualifiedName DEFAULT_BINARY_ENCODING = new QualifiedName(0, "DefaultBinary");
    private static final QualifiedName DEFAULT_XML_ENCODING = new QualifiedName(0, "DefaultXML");
    private static final AtomicLong SUBSCRIPTION_IDS = new AtomicLong(0L);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<UInteger, StatusCode[]> acknowledgeResults = Maps.newConcurrentMap();
    private final PublishQueue publishQueue = new PublishQueue();
    private final Map<UInteger, Subscription> subscriptions = Maps.newConcurrentMap();
    private final List<Subscription> transferred = Lists.newCopyOnWriteArrayList();
    private final Session session;
    private final OpcUaServer server;

    private static UInteger nextSubscriptionId() {
        return Unsigned.uint((long)SUBSCRIPTION_IDS.incrementAndGet());
    }

    public SubscriptionManager(Session session, OpcUaServer server) {
        this.session = session;
        this.server = server;
    }

    public Session getSession() {
        return this.session;
    }

    public PublishQueue getPublishQueue() {
        return this.publishQueue;
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    public void createSubscription(ServiceRequest<CreateSubscriptionRequest, CreateSubscriptionResponse> service) {
        CreateSubscriptionRequest request = (CreateSubscriptionRequest)service.getRequest();
        UInteger subscriptionId = SubscriptionManager.nextSubscriptionId();
        Subscription subscription = new Subscription(this, subscriptionId, request.getRequestedPublishingInterval(), request.getRequestedMaxKeepAliveCount().longValue(), request.getRequestedLifetimeCount().longValue(), request.getMaxNotificationsPerPublish().longValue(), request.getPublishingEnabled(), request.getPriority().intValue());
        this.subscriptions.put(subscriptionId, subscription);
        this.server.getSubscriptions().put(subscriptionId, subscription);
        subscription.setStateListener((s, ps, cs) -> {
            if (cs == Subscription.State.Closed) {
                this.subscriptions.remove(s.getId());
                this.server.getSubscriptions().remove(s.getId());
            }
        });
        subscription.startPublishingTimer();
        ResponseHeader header = service.createResponseHeader();
        CreateSubscriptionResponse response = new CreateSubscriptionResponse(header, subscriptionId, Double.valueOf(subscription.getPublishingInterval()), Unsigned.uint((long)subscription.getLifetimeCount()), Unsigned.uint((long)subscription.getMaxKeepAliveCount()));
        service.setResponse((UaResponseMessage)response);
    }

    public void modifySubscription(ServiceRequest<ModifySubscriptionRequest, ModifySubscriptionResponse> service) {
        ModifySubscriptionRequest request = (ModifySubscriptionRequest)service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        try {
            Subscription subscription = this.subscriptions.get(subscriptionId);
            if (subscription == null) {
                throw new UaException(0x80280000L);
            }
            subscription.modifySubscription(request);
            ResponseHeader header = service.createResponseHeader();
            ModifySubscriptionResponse response = new ModifySubscriptionResponse(header, Double.valueOf(subscription.getPublishingInterval()), Unsigned.uint((long)subscription.getLifetimeCount()), Unsigned.uint((long)subscription.getMaxKeepAliveCount()));
            service.setResponse((UaResponseMessage)response);
        }
        catch (UaException e) {
            service.setServiceFault(e);
        }
    }

    public void deleteSubscription(ServiceRequest<DeleteSubscriptionsRequest, DeleteSubscriptionsResponse> service) {
        DeleteSubscriptionsRequest request = (DeleteSubscriptionsRequest)service.getRequest();
        UInteger[] subscriptionIds = request.getSubscriptionIds();
        if (subscriptionIds.length == 0) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        StatusCode[] results = new StatusCode[subscriptionIds.length];
        for (int i = 0; i < subscriptionIds.length; ++i) {
            Subscription subscription = this.subscriptions.remove(subscriptionIds[i]);
            if (subscription != null) {
                List<BaseMonitoredItem<?>> deletedItems = subscription.deleteSubscription();
                Map<UShort, List<BaseMonitoredItem>> byNamespace = deletedItems.stream().collect(Collectors.groupingBy(item -> item.getReadValueId().getNodeId().getNamespaceIndex()));
                byNamespace.entrySet().forEach(entry -> {
                    UShort namespaceIndex = (UShort)entry.getKey();
                    List items = (List)entry.getValue();
                    ArrayList dataItems = Lists.newArrayList();
                    ArrayList eventItems = Lists.newArrayList();
                    for (BaseMonitoredItem item : items) {
                        if (item instanceof MonitoredDataItem) {
                            dataItems.add((DataItem)((Object)item));
                            continue;
                        }
                        if (!(item instanceof MonitoredEventItem)) continue;
                        eventItems.add((EventItem)((Object)item));
                    }
                    if (!dataItems.isEmpty()) {
                        this.server.getNamespaceManager().getNamespace(namespaceIndex).onDataItemsDeleted(dataItems);
                    }
                    if (!eventItems.isEmpty()) {
                        this.server.getNamespaceManager().getNamespace(namespaceIndex).onEventItemsDeleted(eventItems);
                    }
                });
                results[i] = StatusCode.GOOD;
                continue;
            }
            results[i] = new StatusCode(0x80280000L);
        }
        ResponseHeader header = service.createResponseHeader();
        DeleteSubscriptionsResponse response = new DeleteSubscriptionsResponse(header, results, new DiagnosticInfo[0]);
        service.setResponse((UaResponseMessage)response);
        while (this.subscriptions.isEmpty() && this.publishQueue.isNotEmpty()) {
            ServiceRequest<PublishRequest, PublishResponse> publishService = this.publishQueue.poll();
            if (publishService == null) continue;
            publishService.setServiceFault(2155413504L);
        }
    }

    public void setPublishingMode(ServiceRequest<SetPublishingModeRequest, SetPublishingModeResponse> service) {
        SetPublishingModeRequest request = (SetPublishingModeRequest)service.getRequest();
        UInteger[] subscriptionIds = request.getSubscriptionIds();
        StatusCode[] results = new StatusCode[subscriptionIds.length];
        for (int i = 0; i < subscriptionIds.length; ++i) {
            Subscription subscription = this.subscriptions.get(subscriptionIds[i]);
            if (subscription == null) {
                results[i] = new StatusCode(0x80280000L);
                continue;
            }
            subscription.setPublishingMode(request);
            results[i] = StatusCode.GOOD;
        }
        ResponseHeader header = service.createResponseHeader();
        SetPublishingModeResponse response = new SetPublishingModeResponse(header, results, new DiagnosticInfo[0]);
        service.setResponse((UaResponseMessage)response);
    }

    public void createMonitoredItems(ServiceRequest<CreateMonitoredItemsRequest, CreateMonitoredItemsResponse> service) {
        CreateMonitoredItemsRequest request = (CreateMonitoredItemsRequest)service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        try {
            Subscription subscription = this.subscriptions.get(subscriptionId);
            TimestampsToReturn timestamps = ((CreateMonitoredItemsRequest)service.getRequest()).getTimestampsToReturn();
            MonitoredItemCreateRequest[] itemsToCreate = ((CreateMonitoredItemsRequest)service.getRequest()).getItemsToCreate();
            if (subscription == null) {
                throw new UaException(0x80280000L);
            }
            if (timestamps == null) {
                throw new UaException(2150301696L);
            }
            if (itemsToCreate.length == 0) {
                throw new UaException(0x800F0000L);
            }
            ArrayList createdItems = Lists.newArrayListWithCapacity((int)itemsToCreate.length);
            List pending = Arrays.stream(itemsToCreate).map(PendingItemCreation::new).collect(Collectors.toList());
            for (PendingItemCreation p : pending) {
                MonitoredItemCreateResult result;
                MonitoredItemCreateRequest r = p.getRequest();
                NodeId nodeId = r.getItemToMonitor().getNodeId();
                UInteger attributeId = r.getItemToMonitor().getAttributeId();
                QualifiedName dataEncoding = r.getItemToMonitor().getDataEncoding();
                if (!AttributeId.isValid((UInteger)attributeId)) {
                    result = new MonitoredItemCreateResult(new StatusCode(2150957056L), Unsigned.uint((int)0), Double.valueOf(0.0), Unsigned.uint((int)0), null);
                    p.getResultFuture().complete(result);
                    continue;
                }
                if (dataEncoding.isNotNull()) {
                    if (attributeId.intValue() != 13) {
                        result = new MonitoredItemCreateResult(new StatusCode(0x80380000L), Unsigned.uint((int)0), Double.valueOf(0.0), Unsigned.uint((int)0), null);
                        p.getResultFuture().complete(result);
                        continue;
                    }
                    if (!dataEncoding.equals((Object)DEFAULT_BINARY_ENCODING) && !dataEncoding.equals((Object)DEFAULT_XML_ENCODING)) {
                        result = new MonitoredItemCreateResult(new StatusCode(2151219200L), Unsigned.uint((int)0), Double.valueOf(0.0), Unsigned.uint((int)0), null);
                        p.getResultFuture().complete(result);
                        continue;
                    }
                }
                Namespace namespace = this.server.getNamespaceManager().getNamespace(nodeId.getNamespaceIndex());
                if (attributeId.equals((Object)AttributeId.EventNotifier.uid())) {
                    this.readEventAttributes(namespace, nodeId).thenAccept(as -> {
                        Optional eventNotifier = (Optional)as.v3();
                        try {
                            if (!eventNotifier.isPresent()) {
                                throw new UaException(2150957056L);
                            }
                            MonitoredEventItem item = new MonitoredEventItem(Unsigned.uint((long)subscription.nextItemId()), subscriptionId, r.getItemToMonitor(), r.getMonitoringMode(), timestamps, r.getRequestedParameters().getClientHandle(), 0.0, r.getRequestedParameters().getQueueSize(), r.getRequestedParameters().getDiscardOldest(), r.getRequestedParameters().getFilter());
                            createdItems.add(item);
                            MonitoredItemCreateResult result = new MonitoredItemCreateResult(StatusCode.GOOD, item.getId(), Double.valueOf(item.getSamplingInterval()), Unsigned.uint((int)item.getQueueSize()), item.getFilterResult());
                            p.getResultFuture().complete(result);
                        }
                        catch (UaException e) {
                            MonitoredItemCreateResult result = new MonitoredItemCreateResult(e.getStatusCode(), Unsigned.uint((int)0), Double.valueOf(0.0), Unsigned.uint((int)0), null);
                            p.getResultFuture().complete(result);
                        }
                    });
                    continue;
                }
                this.readDataAttributes(namespace, nodeId).thenAccept(vs -> {
                    try {
                        for (DataValue value : vs) {
                            StatusCode statusCode = value.getStatusCode();
                            if (statusCode.getValue() != 0x80330000L && statusCode.getValue() != 2150891520L) continue;
                            throw new UaException(statusCode);
                        }
                        UByte accessLevel = Optional.ofNullable((UByte)((DataValue)vs.get(0)).getValue().getValue()).orElse(Unsigned.ubyte((int)1));
                        UByte userAccessLevel = Optional.ofNullable((UByte)((DataValue)vs.get(1)).getValue().getValue()).orElse(Unsigned.ubyte((int)1));
                        Double minimumSamplingInterval = Optional.ofNullable((Double)((DataValue)vs.get(2)).getValue().getValue()).orElse(0.0);
                        EnumSet<AccessLevel> accessLevels = AccessLevel.fromMask(accessLevel);
                        EnumSet<AccessLevel> userAccessLevels = AccessLevel.fromMask(userAccessLevel);
                        double samplingInterval = r.getRequestedParameters().getSamplingInterval();
                        double minSupportedSampleRate = this.server.getConfig().getLimits().getMinSupportedSampleRate();
                        double maxSupportedSampleRate = this.server.getConfig().getLimits().getMaxSupportedSampleRate();
                        if (samplingInterval < 0.0) {
                            samplingInterval = subscription.getPublishingInterval();
                        }
                        if (samplingInterval < minimumSamplingInterval) {
                            samplingInterval = minimumSamplingInterval;
                        }
                        if (samplingInterval < minSupportedSampleRate) {
                            samplingInterval = minSupportedSampleRate;
                        }
                        if (samplingInterval > maxSupportedSampleRate) {
                            samplingInterval = maxSupportedSampleRate;
                        }
                        if (!accessLevels.contains((Object)AccessLevel.CurrentRead)) {
                            throw new UaException(2151284736L);
                        }
                        if (!userAccessLevels.contains((Object)AccessLevel.CurrentRead)) {
                            throw new UaException(2149515264L);
                        }
                        String indexRange = r.getItemToMonitor().getIndexRange();
                        if (indexRange != null) {
                            NumericRange.parse(indexRange);
                        }
                        MonitoredDataItem item = new MonitoredDataItem(Unsigned.uint((long)subscription.nextItemId()), subscriptionId, r.getItemToMonitor(), r.getMonitoringMode(), timestamps, r.getRequestedParameters().getClientHandle(), samplingInterval, r.getRequestedParameters().getFilter(), r.getRequestedParameters().getQueueSize(), r.getRequestedParameters().getDiscardOldest());
                        createdItems.add(item);
                        MonitoredItemCreateResult result = new MonitoredItemCreateResult(StatusCode.GOOD, item.getId(), Double.valueOf(item.getSamplingInterval()), Unsigned.uint((int)item.getQueueSize()), item.getFilterResult());
                        p.getResultFuture().complete(result);
                    }
                    catch (Throwable t) {
                        StatusCode statusCode = UaException.extract((Throwable)t).map(UaException::getStatusCode).orElse(StatusCode.BAD);
                        MonitoredItemCreateResult result = new MonitoredItemCreateResult(statusCode, Unsigned.uint((int)0), Double.valueOf(0.0), Unsigned.uint((int)0), null);
                        p.getResultFuture().complete(result);
                    }
                });
            }
            List futures = pending.stream().map(PendingItemCreation::getResultFuture).collect(Collectors.toList());
            FutureUtils.sequence(futures).thenAccept(results -> {
                subscription.addMonitoredItems(createdItems);
                Map<UShort, List<BaseMonitoredItem>> byNamespace = createdItems.stream().collect(Collectors.groupingBy(item -> item.getReadValueId().getNodeId().getNamespaceIndex()));
                byNamespace.entrySet().forEach(entry -> {
                    UShort namespaceIndex = (UShort)entry.getKey();
                    List items = (List)entry.getValue();
                    ArrayList dataItems = Lists.newArrayList();
                    ArrayList eventItems = Lists.newArrayList();
                    for (BaseMonitoredItem item : items) {
                        if (item instanceof MonitoredDataItem) {
                            dataItems.add((DataItem)((Object)item));
                            continue;
                        }
                        if (!(item instanceof MonitoredEventItem)) continue;
                        eventItems.add((EventItem)((Object)item));
                    }
                    if (!dataItems.isEmpty()) {
                        this.server.getNamespaceManager().getNamespace(namespaceIndex).onDataItemsCreated(dataItems);
                    }
                    if (!eventItems.isEmpty()) {
                        this.server.getNamespaceManager().getNamespace(namespaceIndex).onEventItemsCreated(eventItems);
                    }
                });
                ResponseHeader header = service.createResponseHeader();
                CreateMonitoredItemsResponse response = new CreateMonitoredItemsResponse(header, (MonitoredItemCreateResult[])ConversionUtil.a((List)results, MonitoredItemCreateResult.class), new DiagnosticInfo[0]);
                service.setResponse((UaResponseMessage)response);
            });
        }
        catch (UaException e) {
            service.setServiceFault(e);
        }
    }

    public void modifyMonitoredItems(ServiceRequest<ModifyMonitoredItemsRequest, ModifyMonitoredItemsResponse> service) {
        ModifyMonitoredItemsRequest request = (ModifyMonitoredItemsRequest)service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        try {
            Subscription subscription = this.subscriptions.get(subscriptionId);
            TimestampsToReturn timestamps = ((ModifyMonitoredItemsRequest)service.getRequest()).getTimestampsToReturn();
            MonitoredItemModifyRequest[] itemsToModify = ((ModifyMonitoredItemsRequest)service.getRequest()).getItemsToModify();
            if (subscription == null) {
                throw new UaException(0x80280000L);
            }
            if (timestamps == null) {
                throw new UaException(2150301696L);
            }
            if (itemsToModify.length == 0) {
                throw new UaException(0x800F0000L);
            }
            List pending = Arrays.stream(itemsToModify).map(PendingItemModification::new).collect(Collectors.toList());
            ArrayList modifiedItems = Lists.newArrayListWithCapacity((int)itemsToModify.length);
            for (PendingItemModification p : pending) {
                MonitoredItemModifyRequest r = p.getRequest();
                UInteger itemId = r.getMonitoredItemId();
                MonitoringParameters parameters = r.getRequestedParameters();
                BaseMonitoredItem<?> item = subscription.getMonitoredItems().get(itemId);
                if (item == null) {
                    MonitoredItemModifyResult result = new MonitoredItemModifyResult(new StatusCode(2151809024L), Double.valueOf(0.0), Unsigned.uint((int)0), null);
                    p.getResultFuture().complete(result);
                    continue;
                }
                NodeId nodeId = item.getReadValueId().getNodeId();
                Namespace namespace = this.server.getNamespaceManager().getNamespace(nodeId.getNamespaceIndex());
                this.readDataAttributes(namespace, nodeId).thenAccept(vs -> {
                    try {
                        for (DataValue value : vs) {
                            StatusCode statusCode = value.getStatusCode();
                            if (statusCode.getValue() != 0x80330000L && statusCode.getValue() != 2150891520L) continue;
                            throw new UaException(statusCode);
                        }
                        UByte accessLevel = Optional.ofNullable((UByte)((DataValue)vs.get(0)).getValue().getValue()).orElse(Unsigned.ubyte((int)1));
                        UByte userAccessLevel = Optional.ofNullable((UByte)((DataValue)vs.get(1)).getValue().getValue()).orElse(Unsigned.ubyte((int)1));
                        Double minimumSamplingInterval = Optional.ofNullable((Double)((DataValue)vs.get(2)).getValue().getValue()).orElse(0.0);
                        EnumSet<AccessLevel> accessLevels = AccessLevel.fromMask(accessLevel);
                        EnumSet<AccessLevel> userAccessLevels = AccessLevel.fromMask(userAccessLevel);
                        double samplingInterval = parameters.getSamplingInterval();
                        double minSupportedSampleRate = this.server.getConfig().getLimits().getMinSupportedSampleRate();
                        double maxSupportedSampleRate = this.server.getConfig().getLimits().getMaxSupportedSampleRate();
                        if (samplingInterval < 0.0) {
                            samplingInterval = subscription.getPublishingInterval();
                        }
                        if (samplingInterval < minimumSamplingInterval) {
                            samplingInterval = minimumSamplingInterval;
                        }
                        if (samplingInterval < minSupportedSampleRate) {
                            samplingInterval = minSupportedSampleRate;
                        }
                        if (samplingInterval > maxSupportedSampleRate) {
                            samplingInterval = maxSupportedSampleRate;
                        }
                        item.modify(timestamps, parameters.getClientHandle(), samplingInterval, parameters.getFilter(), parameters.getQueueSize(), parameters.getDiscardOldest());
                        modifiedItems.add(item);
                        MonitoredItemModifyResult result = new MonitoredItemModifyResult(StatusCode.GOOD, Double.valueOf(item.getSamplingInterval()), Unsigned.uint((int)item.getQueueSize()), item.getFilterResult());
                        p.getResultFuture().complete(result);
                    }
                    catch (Throwable t) {
                        StatusCode statusCode = UaException.extract((Throwable)t).map(UaException::getStatusCode).orElse(StatusCode.BAD);
                        MonitoredItemModifyResult result = new MonitoredItemModifyResult(statusCode, Double.valueOf(item.getSamplingInterval()), Unsigned.uint((int)item.getQueueSize()), item.getFilterResult());
                        p.getResultFuture().complete(result);
                    }
                });
            }
            subscription.resetLifetimeCounter();
            List futures = pending.stream().map(PendingItemModification::getResultFuture).collect(Collectors.toList());
            FutureUtils.sequence(futures).thenAccept(results -> {
                Map<UShort, List<BaseMonitoredItem>> byNamespace = modifiedItems.stream().collect(Collectors.groupingBy(item -> item.getReadValueId().getNodeId().getNamespaceIndex()));
                byNamespace.entrySet().forEach(entry -> {
                    UShort namespaceIndex = (UShort)entry.getKey();
                    List items = (List)entry.getValue();
                    ArrayList dataItems = Lists.newArrayList();
                    ArrayList eventItems = Lists.newArrayList();
                    for (BaseMonitoredItem item : items) {
                        if (item instanceof MonitoredDataItem) {
                            dataItems.add((DataItem)((Object)item));
                            continue;
                        }
                        if (!(item instanceof MonitoredEventItem)) continue;
                        eventItems.add((EventItem)((Object)item));
                    }
                    if (!dataItems.isEmpty()) {
                        this.server.getNamespaceManager().getNamespace(namespaceIndex).onDataItemsModified(dataItems);
                    }
                    if (!eventItems.isEmpty()) {
                        this.server.getNamespaceManager().getNamespace(namespaceIndex).onEventItemsModified(eventItems);
                    }
                });
                ResponseHeader header = service.createResponseHeader();
                ModifyMonitoredItemsResponse response = new ModifyMonitoredItemsResponse(header, (MonitoredItemModifyResult[])ConversionUtil.a((List)results, MonitoredItemModifyResult.class), new DiagnosticInfo[0]);
                service.setResponse((UaResponseMessage)response);
            });
        }
        catch (UaException e) {
            service.setServiceFault(e);
        }
    }

    private CompletableFuture<List<DataValue>> readDataAttributes(Namespace namespace, NodeId itemId) {
        Function<AttributeId, ReadValueId> f = id -> new ReadValueId(itemId, id.uid(), null, QualifiedName.NULL_VALUE);
        CompletableFuture<List<DataValue>> future = new CompletableFuture<List<DataValue>>();
        AttributeManager.ReadContext readContext = new AttributeManager.ReadContext(this.server, null, future, new DiagnosticsContext<ReadValueId>());
        ArrayList attributes = Lists.newArrayList((Object[])new ReadValueId[]{f.apply(AttributeId.AccessLevel), f.apply(AttributeId.UserAccessLevel), f.apply(AttributeId.MinimumSamplingInterval)});
        namespace.read(readContext, 0.0, TimestampsToReturn.Neither, attributes);
        return future;
    }

    private CompletableFuture<EventAttributes> readEventAttributes(Namespace namespace, NodeId nodeId) {
        Function<AttributeId, ReadValueId> f = id -> new ReadValueId(nodeId, id.uid(), null, QualifiedName.NULL_VALUE);
        CompletableFuture<List<DataValue>> future = new CompletableFuture<List<DataValue>>();
        AttributeManager.ReadContext readContext = new AttributeManager.ReadContext(this.server, null, future, new DiagnosticsContext<ReadValueId>());
        ArrayList readValueIds = Lists.newArrayList((Object[])new ReadValueId[]{f.apply(AttributeId.AccessLevel), f.apply(AttributeId.UserAccessLevel), f.apply(AttributeId.EventNotifier)});
        namespace.read(readContext, 0.0, TimestampsToReturn.Neither, readValueIds);
        return future.thenApply(values -> {
            UByte accessLevel = Optional.ofNullable((UByte)((DataValue)values.get(0)).getValue().getValue()).orElse(Unsigned.ubyte((int)1));
            UByte userAccessLevel = Optional.ofNullable((UByte)((DataValue)values.get(1)).getValue().getValue()).orElse(Unsigned.ubyte((int)1));
            Optional<UByte> eventNotifier = Optional.ofNullable((UByte)((DataValue)values.get(2)).getValue().getValue());
            return new EventAttributes(AccessLevel.fromMask(accessLevel), AccessLevel.fromMask(userAccessLevel), eventNotifier);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMonitoredItems(ServiceRequest<DeleteMonitoredItemsRequest, DeleteMonitoredItemsResponse> service) {
        DeleteMonitoredItemsRequest request = (DeleteMonitoredItemsRequest)service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        try {
            Subscription subscription = this.subscriptions.get(subscriptionId);
            UInteger[] itemsToDelete = ((DeleteMonitoredItemsRequest)service.getRequest()).getMonitoredItemIds();
            if (subscription == null) {
                throw new UaException(0x80280000L);
            }
            if (itemsToDelete.length == 0) {
                throw new UaException(0x800F0000L);
            }
            StatusCode[] deleteResults = new StatusCode[itemsToDelete.length];
            ArrayList deletedItems = Lists.newArrayListWithCapacity((int)itemsToDelete.length);
            Subscription subscription2 = subscription;
            synchronized (subscription2) {
                for (int i = 0; i < itemsToDelete.length; ++i) {
                    UInteger itemId = itemsToDelete[i];
                    BaseMonitoredItem<?> item2 = subscription.getMonitoredItems().get(itemId);
                    if (item2 == null) {
                        deleteResults[i] = new StatusCode(2151809024L);
                        continue;
                    }
                    deletedItems.add(item2);
                    deleteResults[i] = StatusCode.GOOD;
                }
                subscription.removeMonitoredItems(deletedItems);
            }
            Map<UShort, List<BaseMonitoredItem>> byNamespace = deletedItems.stream().collect(Collectors.groupingBy(item -> item.getReadValueId().getNodeId().getNamespaceIndex()));
            byNamespace.entrySet().forEach(entry -> {
                UShort namespaceIndex = (UShort)entry.getKey();
                List items = (List)entry.getValue();
                ArrayList dataItems = Lists.newArrayList();
                ArrayList eventItems = Lists.newArrayList();
                for (BaseMonitoredItem item : items) {
                    if (item instanceof MonitoredDataItem) {
                        dataItems.add((DataItem)((Object)item));
                        continue;
                    }
                    if (!(item instanceof MonitoredEventItem)) continue;
                    eventItems.add((EventItem)((Object)item));
                }
                if (!dataItems.isEmpty()) {
                    this.server.getNamespaceManager().getNamespace(namespaceIndex).onDataItemsDeleted(dataItems);
                }
                if (!eventItems.isEmpty()) {
                    this.server.getNamespaceManager().getNamespace(namespaceIndex).onEventItemsDeleted(eventItems);
                }
            });
            ResponseHeader header = service.createResponseHeader();
            DeleteMonitoredItemsResponse response = new DeleteMonitoredItemsResponse(header, deleteResults, new DiagnosticInfo[0]);
            service.setResponse((UaResponseMessage)response);
        }
        catch (UaException e) {
            service.setServiceFault(e);
        }
    }

    public void setMonitoringMode(ServiceRequest<SetMonitoringModeRequest, SetMonitoringModeResponse> service) {
        SetMonitoringModeRequest request = (SetMonitoringModeRequest)service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        try {
            Subscription subscription = this.subscriptions.get(subscriptionId);
            UInteger[] itemsToModify = request.getMonitoredItemIds();
            if (subscription == null) {
                throw new UaException(0x80280000L);
            }
            if (itemsToModify.length == 0) {
                throw new UaException(0x800F0000L);
            }
            MonitoringMode monitoringMode = request.getMonitoringMode();
            StatusCode[] results = new StatusCode[itemsToModify.length];
            ArrayList modified = Lists.newArrayListWithCapacity((int)itemsToModify.length);
            for (int i = 0; i < itemsToModify.length; ++i) {
                UInteger itemId = itemsToModify[i];
                BaseMonitoredItem<?> item2 = subscription.getMonitoredItems().get(itemId);
                if (item2 != null) {
                    item2.setMonitoringMode(monitoringMode);
                    modified.add(item2);
                    results[i] = StatusCode.GOOD;
                    continue;
                }
                results[i] = new StatusCode(2151809024L);
            }
            Map<UShort, List<MonitoredItem>> byNamespace = modified.stream().collect(Collectors.groupingBy(item -> item.getReadValueId().getNodeId().getNamespaceIndex()));
            byNamespace.keySet().forEach(namespaceIndex -> {
                List items = (List)byNamespace.get(namespaceIndex);
                this.server.getNamespaceManager().getNamespace((UShort)namespaceIndex).onMonitoringModeChanged(items);
            });
            ResponseHeader header = service.createResponseHeader();
            SetMonitoringModeResponse response = new SetMonitoringModeResponse(header, results, new DiagnosticInfo[0]);
            service.setResponse((UaResponseMessage)response);
        }
        catch (UaException e) {
            service.setServiceFault(e);
        }
    }

    public void publish(ServiceRequest<PublishRequest, PublishResponse> service) {
        PublishRequest request = (PublishRequest)service.getRequest();
        if (!this.transferred.isEmpty()) {
            Subscription subscription = this.transferred.remove(0);
            subscription.returnStatusChangeNotification(service);
            return;
        }
        if (this.subscriptions.isEmpty()) {
            service.setServiceFault(2155413504L);
            return;
        }
        SubscriptionAcknowledgement[] acknowledgements = request.getSubscriptionAcknowledgements();
        StatusCode[] results = new StatusCode[acknowledgements.length];
        for (int i = 0; i < acknowledgements.length; ++i) {
            SubscriptionAcknowledgement acknowledgement = acknowledgements[i];
            UInteger sequenceNumber = acknowledgement.getSequenceNumber();
            UInteger subscriptionId = acknowledgement.getSubscriptionId();
            this.logger.debug("Acknowledging sequenceNumber={} on subscriptionId={}", (Object)sequenceNumber, (Object)subscriptionId);
            Subscription subscription = this.subscriptions.get(subscriptionId);
            results[i] = subscription == null ? new StatusCode(0x80280000L) : subscription.acknowledge(sequenceNumber);
        }
        this.acknowledgeResults.put(request.getRequestHeader().getRequestHandle(), results);
        this.publishQueue.addRequest(service);
    }

    public void republish(ServiceRequest<RepublishRequest, RepublishResponse> service) {
        RepublishRequest request = (RepublishRequest)service.getRequest();
        if (this.subscriptions.isEmpty()) {
            service.setServiceFault(0x80280000L);
            return;
        }
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        if (subscription == null) {
            service.setServiceFault(0x80280000L);
            return;
        }
        UInteger sequenceNumber = request.getRetransmitSequenceNumber();
        NotificationMessage notificationMessage = subscription.republish(sequenceNumber);
        if (notificationMessage == null) {
            service.setServiceFault(2155544576L);
            return;
        }
        ResponseHeader header = service.createResponseHeader();
        RepublishResponse response = new RepublishResponse(header, notificationMessage);
        service.setResponse((UaResponseMessage)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriggering(ServiceRequest<SetTriggeringRequest, SetTriggeringResponse> service) {
        SetTriggeringRequest request = (SetTriggeringRequest)service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        if (subscription == null) {
            service.setServiceFault(0x80280000L);
            return;
        }
        if (request.getLinksToAdd().length == 0 && request.getLinksToRemove().length == 0) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        UInteger triggerId = request.getTriggeringItemId();
        UInteger[] linksToAdd = request.getLinksToAdd();
        UInteger[] linksToRemove = request.getLinksToRemove();
        Subscription subscription2 = subscription;
        synchronized (subscription2) {
            Map<UInteger, BaseMonitoredItem<?>> itemsById = subscription.getMonitoredItems();
            BaseMonitoredItem<?> triggerItem = itemsById.get(triggerId);
            if (triggerItem == null) {
                service.setServiceFault(2151809024L);
                return;
            }
            List<StatusCode> removeResults = Arrays.stream(linksToRemove).map(linkedItemId -> {
                BaseMonitoredItem item = (BaseMonitoredItem)itemsById.get(linkedItemId);
                if (item != null) {
                    if (triggerItem.getTriggeredItems().remove(linkedItemId) != null) {
                        return StatusCode.GOOD;
                    }
                    return new StatusCode(2151809024L);
                }
                return new StatusCode(2151809024L);
            }).collect(Collectors.toList());
            List<StatusCode> addResults = Arrays.stream(linksToAdd).map(linkedItemId -> {
                BaseMonitoredItem linkedItem = (BaseMonitoredItem)itemsById.get(linkedItemId);
                if (linkedItem != null) {
                    triggerItem.getTriggeredItems().put((UInteger)linkedItemId, linkedItem);
                    return StatusCode.GOOD;
                }
                return new StatusCode(2151809024L);
            }).collect(Collectors.toList());
            SetTriggeringResponse response = new SetTriggeringResponse(service.createResponseHeader(), addResults.toArray(new StatusCode[addResults.size()]), new DiagnosticInfo[0], removeResults.toArray(new StatusCode[removeResults.size()]), new DiagnosticInfo[0]);
            service.setResponse((UaResponseMessage)response);
        }
    }

    public void sessionClosed(boolean deleteSubscriptions) {
        Iterator<Subscription> iterator = this.subscriptions.values().iterator();
        while (iterator.hasNext()) {
            Subscription s = iterator.next();
            s.setStateListener(null);
            if (deleteSubscriptions) {
                this.server.getSubscriptions().remove(s.getId());
            }
            iterator.remove();
        }
    }

    public Subscription removeSubscription(UInteger subscriptionId) {
        Subscription subscription = this.subscriptions.remove(subscriptionId);
        if (subscription != null) {
            subscription.setStateListener(null);
        }
        return subscription;
    }

    public void addSubscription(Subscription subscription) {
        this.subscriptions.put(subscription.getId(), subscription);
        subscription.setStateListener((s, ps, cs) -> {
            if (cs == Subscription.State.Closed) {
                this.subscriptions.remove(s.getId());
                this.server.getSubscriptions().remove(s.getId());
            }
        });
    }

    StatusCode[] getAcknowledgeResults(UInteger requestHandle) {
        return this.acknowledgeResults.remove(requestHandle);
    }

    public void sendStatusChangeNotification(Subscription subscription) {
        ServiceRequest<PublishRequest, PublishResponse> service = this.publishQueue.poll();
        if (service != null) {
            subscription.returnStatusChangeNotification(service);
        } else {
            this.transferred.add(subscription);
        }
    }

    private static class EventAttributes
    extends Tuple3<EnumSet<AccessLevel>, EnumSet<AccessLevel>, Optional<UByte>> {
        public EventAttributes(EnumSet<AccessLevel> v1, EnumSet<AccessLevel> v2, Optional<UByte> v3) {
            super(v1, v2, v3);
        }
    }
}

