/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.services;

import com.digitalpetri.opcua.sdk.server.DiagnosticsContext;
import com.digitalpetri.opcua.sdk.server.NamespaceManager;
import com.digitalpetri.opcua.sdk.server.OpcUaServer;
import com.digitalpetri.opcua.sdk.server.Session;
import com.digitalpetri.opcua.sdk.server.api.Namespace;
import com.digitalpetri.opcua.sdk.server.api.ViewManager;
import com.digitalpetri.opcua.sdk.server.services.ServiceAttributes;
import com.digitalpetri.opcua.sdk.server.services.ServiceMetric;
import com.digitalpetri.opcua.sdk.server.services.helpers.BrowseHelper;
import com.digitalpetri.opcua.sdk.server.services.helpers.BrowsePathsHelper;
import com.digitalpetri.opcua.sdk.server.util.FutureUtils;
import com.digitalpetri.opcua.sdk.server.util.PendingBrowse;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.application.services.ServiceRequest;
import com.digitalpetri.opcua.stack.core.application.services.ViewServiceSet;
import com.digitalpetri.opcua.stack.core.serialization.UaResponseMessage;
import com.digitalpetri.opcua.stack.core.types.builtin.DiagnosticInfo;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.StatusCode;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UShort;
import com.digitalpetri.opcua.stack.core.types.structured.BrowseDescription;
import com.digitalpetri.opcua.stack.core.types.structured.BrowseNextRequest;
import com.digitalpetri.opcua.stack.core.types.structured.BrowseNextResponse;
import com.digitalpetri.opcua.stack.core.types.structured.BrowseRequest;
import com.digitalpetri.opcua.stack.core.types.structured.BrowseResponse;
import com.digitalpetri.opcua.stack.core.types.structured.BrowseResult;
import com.digitalpetri.opcua.stack.core.types.structured.RegisterNodesRequest;
import com.digitalpetri.opcua.stack.core.types.structured.RegisterNodesResponse;
import com.digitalpetri.opcua.stack.core.types.structured.ResponseHeader;
import com.digitalpetri.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import com.digitalpetri.opcua.stack.core.types.structured.UnregisterNodesRequest;
import com.digitalpetri.opcua.stack.core.types.structured.UnregisterNodesResponse;
import com.digitalpetri.opcua.stack.core.util.ConversionUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class ViewServices
implements ViewServiceSet {
    private final ServiceMetric browseCounter = new ServiceMetric();
    private final ServiceMetric browseNextCounter = new ServiceMetric();
    private final ServiceMetric translateBrowsePathsCounter = new ServiceMetric();
    private final BrowseHelper browseHelper = new BrowseHelper();

    public void onBrowse(ServiceRequest<BrowseRequest, BrowseResponse> service) {
        this.browseCounter.record(service);
        BrowseRequest request = (BrowseRequest)service.getRequest();
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        if (request.getNodesToBrowse().length > server.getConfig().getLimits().getMaxNodesPerBrowse().intValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        BrowseDescription[] nodesToBrowse = request.getNodesToBrowse();
        ArrayList pendingBrowses = Lists.newArrayListWithCapacity((int)nodesToBrowse.length);
        ArrayList futures = Lists.newArrayListWithCapacity((int)nodesToBrowse.length);
        for (BrowseDescription browseDescription : nodesToBrowse) {
            PendingBrowse pending2 = new PendingBrowse(browseDescription);
            pendingBrowses.add(pending2);
            futures.add(pending2.getFuture());
        }
        Map<UShort, List<PendingBrowse>> byNamespace = pendingBrowses.stream().collect(Collectors.groupingBy(pending -> pending.getInput().getNodeId().getNamespaceIndex()));
        byNamespace.keySet().forEach(index -> {
            List pending = (List)byNamespace.get(index);
            CompletableFuture<List<BrowseResult>> future = new CompletableFuture<List<BrowseResult>>();
            ViewManager.BrowseContext context = new ViewManager.BrowseContext(server, session, future, diagnosticsContext);
            server.getExecutorService().execute(() -> {
                Namespace namespace = server.getNamespaceManager().getNamespace((UShort)index);
                List<BrowseDescription> browseDescriptions = pending.stream().map(PendingBrowse::getInput).collect(Collectors.toList());
                namespace.browse(context, request.getView(), request.getRequestedMaxReferencesPerNode(), browseDescriptions);
            });
            future.thenAccept(results -> {
                for (int i = 0; i < results.size(); ++i) {
                    ((PendingBrowse)pending.get(i)).getFuture().complete((BrowseResult)results.get(i));
                }
            });
        });
        FutureUtils.sequence(futures).thenAcceptAsync(results -> {
            ResponseHeader header = service.createResponseHeader();
            DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToBrowse);
            BrowseResponse response = new BrowseResponse(header, (BrowseResult[])ConversionUtil.a((List)results, BrowseResult.class), diagnosticInfos);
            service.setResponse((UaResponseMessage)response);
        }, (Executor)server.getExecutorService());
    }

    public void onBrowseNext(ServiceRequest<BrowseNextRequest, BrowseNextResponse> service) {
        this.browseNextCounter.record(service);
        this.browseHelper.browseNext(service);
    }

    public void onTranslateBrowsePaths(ServiceRequest<TranslateBrowsePathsToNodeIdsRequest, TranslateBrowsePathsToNodeIdsResponse> service) {
        this.translateBrowsePathsCounter.record(service);
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        NamespaceManager namespaceManager = server.getNamespaceManager();
        new BrowsePathsHelper(server, namespaceManager).onTranslateBrowsePaths(service);
    }

    public void onRegisterNodes(ServiceRequest<RegisterNodesRequest, RegisterNodesResponse> service) throws UaException {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        RegisterNodesRequest request = (RegisterNodesRequest)service.getRequest();
        NodeId[] nodeIds = request.getNodesToRegister();
        if (nodeIds.length == 0) {
            throw new UaException(0x800F0000L);
        }
        if (nodeIds.length > server.getConfig().getLimits().getMaxNodesPerRegisterNodes().intValue()) {
            throw new UaException(0x80100000L);
        }
        service.setResponse((UaResponseMessage)new RegisterNodesResponse(service.createResponseHeader(StatusCode.GOOD), nodeIds));
    }

    public void onUnregisterNodes(ServiceRequest<UnregisterNodesRequest, UnregisterNodesResponse> service) throws UaException {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        UnregisterNodesRequest request = (UnregisterNodesRequest)service.getRequest();
        NodeId[] nodeIds = request.getNodesToUnregister();
        if (nodeIds.length == 0) {
            throw new UaException(0x800F0000L);
        }
        if (nodeIds.length > server.getConfig().getLimits().getMaxNodesPerRegisterNodes().intValue()) {
            throw new UaException(0x80100000L);
        }
        service.setResponse((UaResponseMessage)new UnregisterNodesResponse(service.createResponseHeader(StatusCode.GOOD)));
    }
}

