/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.objects;

import com.digitalpetri.opcua.sdk.core.model.objects.FiniteStateMachineType;
import com.digitalpetri.opcua.sdk.core.model.variables.FiniteStateVariableType;
import com.digitalpetri.opcua.sdk.core.model.variables.FiniteTransitionVariableType;
import com.digitalpetri.opcua.sdk.core.nodes.VariableNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.objects.StateMachineNode;
import com.digitalpetri.opcua.sdk.server.util.UaObjectType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import java.util.Optional;

@UaObjectType(name="FiniteStateMachineType")
public class FiniteStateMachineNode
extends StateMachineNode
implements FiniteStateMachineType {
    public FiniteStateMachineNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, UByte eventNotifier) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public FiniteStateVariableType getCurrentState() {
        Optional<VariableNode> currentState = this.getVariableComponent("CurrentState");
        return currentState.map(node -> (FiniteStateVariableType)((Object)node)).orElse(null);
    }

    @Override
    public FiniteTransitionVariableType getLastTransition() {
        Optional<VariableNode> lastTransition = this.getVariableComponent("LastTransition");
        return lastTransition.map(node -> (FiniteTransitionVariableType)((Object)node)).orElse(null);
    }

    public synchronized void setCurrentState(FiniteStateVariableType currentState) {
        this.getVariableComponent("CurrentState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)currentState))));
    }

    public synchronized void setLastTransition(FiniteTransitionVariableType lastTransition) {
        this.getVariableComponent("LastTransition").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)lastTransition))));
    }
}

