/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model;

import com.digitalpetri.opcua.sdk.core.model.UaOptional;
import com.digitalpetri.opcua.sdk.core.nodes.ViewNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.Property;
import com.digitalpetri.opcua.sdk.server.model.UaNode;
import com.digitalpetri.opcua.stack.core.Identifiers;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.enumerated.NodeClass;
import java.util.Optional;

public class UaViewNode
extends UaNode
implements ViewNode {
    private volatile boolean containsNoLoops;
    private volatile UByte eventNotifier;
    public static final Property<String> NodeVersion = new Property.BasicProperty<String>(new QualifiedName(0, "NodeVersion"), Identifiers.String, -1, String.class);
    public static final Property<UInteger> ViewVersion = new Property.BasicProperty<UInteger>(new QualifiedName(0, "ViewVersion"), Identifiers.UInt32, -1, UInteger.class);

    public UaViewNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, boolean containsNoLoops, UByte eventNotifier) {
        super(namespace, nodeId, NodeClass.View, browseName, displayName, description, writeMask, userWriteMask);
        this.containsNoLoops = containsNoLoops;
        this.eventNotifier = eventNotifier;
    }

    @Override
    public Boolean getContainsNoLoops() {
        return this.containsNoLoops;
    }

    @Override
    public UByte getEventNotifier() {
        return this.eventNotifier;
    }

    @Override
    public synchronized void setContainsNoLoops(boolean containsNoLoops) {
        this.containsNoLoops = containsNoLoops;
        this.fireAttributeChanged(11, containsNoLoops);
    }

    @Override
    public synchronized void setEventNotifier(UByte eventNotifier) {
        this.eventNotifier = eventNotifier;
        this.fireAttributeChanged(12, eventNotifier);
    }

    @UaOptional(value="NodeVersion")
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    @UaOptional(value="ViewVersion")
    public UInteger getViewVersion() {
        return this.getProperty(ViewVersion).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }

    public void setViewVersion(UInteger viewVersion) {
        this.setProperty(ViewVersion, viewVersion);
    }
}

