/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model;

import com.digitalpetri.opcua.sdk.core.Reference;
import com.digitalpetri.opcua.sdk.core.model.UaOptional;
import com.digitalpetri.opcua.sdk.core.nodes.MethodNode;
import com.digitalpetri.opcua.sdk.core.nodes.Node;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectNode;
import com.digitalpetri.opcua.sdk.server.api.MethodInvocationHandler;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.Property;
import com.digitalpetri.opcua.sdk.server.model.UaNode;
import com.digitalpetri.opcua.sdk.server.util.StreamUtil;
import com.digitalpetri.opcua.stack.core.Identifiers;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.Unsigned;
import com.digitalpetri.opcua.stack.core.types.enumerated.NodeClass;
import com.digitalpetri.opcua.stack.core.types.structured.Argument;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class UaMethodNode
extends UaNode
implements MethodNode {
    private volatile Optional<MethodInvocationHandler> handler = Optional.empty();
    private volatile boolean executable;
    private volatile boolean userExecutable;
    public static final Property<Argument[]> InputArguments = new Property.BasicProperty<Argument[]>(new QualifiedName(0, "InputArguments"), Identifiers.Argument, 1, Argument[].class);
    public static final Property<Argument[]> OutputArguments = new Property.BasicProperty<Argument[]>(new QualifiedName(0, "OutputArguments"), Identifiers.Argument, 1, Argument[].class);
    public static final Property<String> NodeVersion = new Property.BasicProperty<String>(new QualifiedName(0, "NodeVersion"), Identifiers.String, -1, String.class);

    public UaMethodNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, boolean executable, boolean userExecutable) {
        super(namespace, nodeId, NodeClass.Method, browseName, displayName, description, writeMask, userWriteMask);
        this.executable = executable;
        this.userExecutable = userExecutable;
    }

    @Override
    public Boolean isExecutable() {
        return this.executable;
    }

    @Override
    public Boolean isUserExecutable() {
        return this.userExecutable;
    }

    @Override
    public synchronized void setExecutable(boolean executable) {
        this.executable = executable;
        this.fireAttributeChanged(21, executable);
    }

    @Override
    public synchronized void setUserExecutable(boolean userExecutable) {
        this.userExecutable = userExecutable;
        this.fireAttributeChanged(22, userExecutable);
    }

    public List<Node> getPropertyNodes() {
        return this.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public Optional<ObjectNode> getModellingRuleNode() {
        Node node = this.getReferences().stream().filter(Reference.HAS_MODELLING_RULE_PREDICATE).findFirst().flatMap(r -> this.getNode(r.getTargetNodeId())).orElse(null);
        ObjectNode objectNode = node instanceof ObjectNode ? (ObjectNode)node : null;
        return Optional.ofNullable(objectNode);
    }

    public List<Node> getAlwaysGeneratesEventNodes() {
        return this.getReferences().stream().filter(Reference.ALWAYS_GENERATES_EVENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public Optional<MethodInvocationHandler> getInvocationHandler() {
        return this.handler;
    }

    public void setInvocationHandler(MethodInvocationHandler handler) {
        this.handler = Optional.of(handler);
    }

    @UaOptional(value="NodeVersion")
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    @UaOptional(value="InputArguments")
    public Argument[] getInputArguments() {
        return this.getProperty(InputArguments).orElse(null);
    }

    @UaOptional(value="OutputArguments")
    public Argument[] getOutputArguments() {
        return this.getProperty(OutputArguments).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }

    public void setInputArguments(Argument[] inputArguments) {
        this.setProperty(InputArguments, inputArguments);
    }

    public void setOutputArguments(Argument[] outputArguments) {
        this.setProperty(OutputArguments, outputArguments);
    }

    public static UaMethodNodeBuilder builder(UaNamespace nodeManager) {
        return new UaMethodNodeBuilder(nodeManager);
    }

    public static class UaMethodNodeBuilder
    implements Supplier<UaMethodNode> {
        private NodeId nodeId;
        private QualifiedName browseName;
        private LocalizedText displayName;
        private Optional<LocalizedText> description = Optional.empty();
        private Optional<UInteger> writeMask = Optional.of(Unsigned.uint((int)0));
        private Optional<UInteger> userWriteMask = Optional.of(Unsigned.uint((int)0));
        private boolean executable = true;
        private boolean userExecutable = true;
        private final UaNamespace nodeManager;

        public UaMethodNodeBuilder(UaNamespace nodeManager) {
            this.nodeManager = nodeManager;
        }

        @Override
        public UaMethodNode get() {
            return this.build();
        }

        public UaMethodNode build() {
            Preconditions.checkNotNull((Object)this.nodeId, (Object)"NodeId cannot be null");
            Preconditions.checkNotNull((Object)this.browseName, (Object)"BrowseName cannot be null");
            Preconditions.checkNotNull((Object)this.displayName, (Object)"DisplayName cannot be null");
            return new UaMethodNode(this.nodeManager, this.nodeId, this.browseName, this.displayName, this.description, this.writeMask, this.userWriteMask, this.executable, this.userExecutable);
        }

        public UaMethodNodeBuilder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public UaMethodNodeBuilder setBrowseName(QualifiedName browseName) {
            this.browseName = browseName;
            return this;
        }

        public UaMethodNodeBuilder setDisplayName(LocalizedText displayName) {
            this.displayName = displayName;
            return this;
        }

        public UaMethodNodeBuilder setDescription(LocalizedText description) {
            this.description = Optional.of(description);
            return this;
        }

        public UaMethodNodeBuilder setWriteMask(UInteger writeMask) {
            this.writeMask = Optional.of(writeMask);
            return this;
        }

        public UaMethodNodeBuilder setUserWriteMask(UInteger userWriteMask) {
            this.userWriteMask = Optional.of(userWriteMask);
            return this;
        }

        public UaMethodNodeBuilder setExecutable(boolean executable) {
            this.executable = executable;
            return this;
        }

        public UaMethodNodeBuilder setUserExecutable(boolean userExecutable) {
            this.userExecutable = userExecutable;
            return this;
        }
    }
}

