/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model;

import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import java.util.Optional;

public interface Property<T> {
    public QualifiedName getBrowseName();

    public NodeId getDataType();

    public Integer getValueRank();

    public Class<T> getJavaType();

    default public Optional<UInteger[]> getArrayDimensions() {
        return Optional.empty();
    }

    public static class BasicProperty<T>
    implements Property<T> {
        private final QualifiedName browseName;
        private final NodeId dataType;
        private final Integer valueRank;
        private final Class<T> javaType;

        public BasicProperty(QualifiedName browseName, NodeId dataType, Integer valueRank, Class<T> javaType) {
            this.browseName = browseName;
            this.dataType = dataType;
            this.valueRank = valueRank;
            this.javaType = javaType;
        }

        @Override
        public QualifiedName getBrowseName() {
            return this.browseName;
        }

        @Override
        public NodeId getDataType() {
            return this.dataType;
        }

        @Override
        public Integer getValueRank() {
            return this.valueRank;
        }

        @Override
        public Class<T> getJavaType() {
            return this.javaType;
        }
    }
}

