/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.items;

import com.digitalpetri.opcua.sdk.server.api.DataItem;
import com.digitalpetri.opcua.sdk.server.items.BaseMonitoredItem;
import com.digitalpetri.opcua.sdk.server.util.DataChangeMonitoringFilter;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DateTime;
import com.digitalpetri.opcua.stack.core.types.builtin.ExtensionObject;
import com.digitalpetri.opcua.stack.core.types.builtin.StatusCode;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.Unsigned;
import com.digitalpetri.opcua.stack.core.types.enumerated.DataChangeTrigger;
import com.digitalpetri.opcua.stack.core.types.enumerated.DeadbandType;
import com.digitalpetri.opcua.stack.core.types.enumerated.MonitoringMode;
import com.digitalpetri.opcua.stack.core.types.enumerated.TimestampsToReturn;
import com.digitalpetri.opcua.stack.core.types.structured.AggregateFilter;
import com.digitalpetri.opcua.stack.core.types.structured.DataChangeFilter;
import com.digitalpetri.opcua.stack.core.types.structured.EventFilter;
import com.digitalpetri.opcua.stack.core.types.structured.MonitoredItemNotification;
import com.digitalpetri.opcua.stack.core.types.structured.MonitoringFilter;
import com.digitalpetri.opcua.stack.core.types.structured.ReadValueId;

public class MonitoredDataItem
extends BaseMonitoredItem<DataValue>
implements DataItem {
    private static final DataChangeFilter DefaultFilter = new DataChangeFilter(DataChangeTrigger.StatusValue, Unsigned.uint((int)DeadbandType.None.getValue()), Double.valueOf(0.0));
    private volatile DataValue lastValue = null;
    private volatile DataChangeFilter filter = null;
    private volatile ExtensionObject filterResult = null;

    public MonitoredDataItem(UInteger id, UInteger subscriptionId, ReadValueId readValueId, MonitoringMode monitoringMode, TimestampsToReturn timestamps, UInteger clientHandle, double samplingInterval, ExtensionObject filter, UInteger queueSize, boolean discardOldest) throws UaException {
        super(id, subscriptionId, readValueId, monitoringMode, timestamps, clientHandle, samplingInterval, queueSize, discardOldest);
        this.installFilter(filter);
    }

    @Override
    public synchronized void setValue(DataValue value) {
        boolean valuePassesFilter = DataChangeMonitoringFilter.filter(this.lastValue, value, this.filter);
        if (valuePassesFilter) {
            this.lastValue = value;
            this.enqueue(value);
            if (this.triggeredItems != null) {
                this.triggeredItems.values().forEach(item -> {
                    item.triggered = true;
                });
            }
        }
    }

    @Override
    protected void enqueue(DataValue value) {
        if (this.queue.size() < this.queue.maxSize()) {
            this.queue.add(value);
        } else {
            if (this.getQueueSize() > 1) {
                value = value.withStatus(value.getStatusCode().withOverflow());
            } else if (value.getStatusCode().isOverflowSet()) {
                value = value.withStatus(value.getStatusCode().withoutOverflow());
            }
            if (this.discardOldest) {
                this.queue.add(value);
            } else {
                this.queue.set(this.queue.maxSize() - 1, value);
            }
        }
    }

    @Override
    public synchronized void setQuality(StatusCode quality) {
        if (this.lastValue == null) {
            this.setValue(new DataValue(Variant.NULL_VALUE, quality, DateTime.now(), DateTime.now()));
        } else {
            DataValue value = new DataValue(this.lastValue.getValue(), quality, DateTime.now(), DateTime.now());
            this.setValue(value);
        }
    }

    @Override
    public boolean isSamplingEnabled() {
        return this.getMonitoringMode() != MonitoringMode.Disabled;
    }

    @Override
    public synchronized void setMonitoringMode(MonitoringMode monitoringMode) {
        if (monitoringMode == MonitoringMode.Disabled) {
            this.lastValue = null;
        }
        super.setMonitoringMode(monitoringMode);
    }

    public synchronized void clearLastValue() {
        this.lastValue = null;
    }

    @Override
    protected void installFilter(ExtensionObject filterXo) throws UaException {
        if (filterXo == null || filterXo.decode() == null) {
            this.filter = DefaultFilter;
        } else {
            Object filterObject = filterXo.decode();
            if (filterObject instanceof MonitoringFilter) {
                if (filterObject instanceof DataChangeFilter) {
                    this.filter = (DataChangeFilter)filterObject;
                    DeadbandType deadbandType = DeadbandType.from((Integer)this.filter.getDeadbandType().intValue());
                    if (deadbandType == null) {
                        throw new UaException(0x808E0000L);
                    }
                    if (deadbandType != DeadbandType.None && this.getReadValueId().getAttributeId().intValue() != 13) {
                        throw new UaException(2152005632L);
                    }
                } else {
                    if (filterObject instanceof AggregateFilter) {
                        throw new UaException(0x80440000L);
                    }
                    if (filterObject instanceof EventFilter) {
                        throw new UaException(2152005632L);
                    }
                }
            } else {
                throw new UaException(2151874560L);
            }
        }
    }

    @Override
    public ExtensionObject getFilterResult() {
        return this.filterResult;
    }

    protected MonitoredItemNotification wrapQueueValue(DataValue value) {
        value = DataValue.derivedValue((DataValue)value, (TimestampsToReturn)this.timestamps);
        return new MonitoredItemNotification(Unsigned.uint((long)this.getClientHandle()), value);
    }
}

