/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.identity;

import com.digitalpetri.opcua.sdk.server.Session;
import com.digitalpetri.opcua.sdk.server.identity.IdentityValidator;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.channel.SecureChannel;
import com.digitalpetri.opcua.stack.core.security.SecurityAlgorithm;
import com.digitalpetri.opcua.stack.core.security.SecurityPolicy;
import com.digitalpetri.opcua.stack.core.types.builtin.ByteString;
import com.digitalpetri.opcua.stack.core.types.structured.AnonymousIdentityToken;
import com.digitalpetri.opcua.stack.core.types.structured.UserNameIdentityToken;
import com.digitalpetri.opcua.stack.core.types.structured.UserTokenPolicy;
import java.util.Arrays;
import java.util.function.Predicate;

public class UsernameIdentityValidator
extends IdentityValidator {
    private static final Object ANON_IDENTITY_OBJECT = new Object();
    private final boolean allowAnonymous;
    private final Predicate<AuthenticationChallenge> predicate;

    public UsernameIdentityValidator(boolean allowAnonymous, Predicate<AuthenticationChallenge> predicate) {
        this.allowAnonymous = allowAnonymous;
        this.predicate = predicate;
    }

    @Override
    public Object validateAnonymousToken(AnonymousIdentityToken token, UserTokenPolicy tokenPolicy, SecureChannel channel, Session session) throws UaException {
        if (this.allowAnonymous) {
            return ANON_IDENTITY_OBJECT;
        }
        throw new UaException(2149515264L);
    }

    @Override
    public Object validateUsernameToken(UserNameIdentityToken token, UserTokenPolicy tokenPolicy, SecureChannel channel, Session session) throws UaException {
        return this.validateUserNameIdentityToken(token, channel, session);
    }

    private String validateUserNameIdentityToken(UserNameIdentityToken token, SecureChannel channel, Session session) throws UaException {
        SecurityAlgorithm algorithm;
        SecurityPolicy securityPolicy = channel.getSecurityPolicy();
        String username = token.getUserName();
        ByteString lastNonce = session.getLastNonce();
        int lastNonceLength = lastNonce.length();
        if (username == null || username.isEmpty()) {
            throw new UaException(0x80200000L);
        }
        String algorithmUri = token.getEncryptionAlgorithm();
        if (algorithmUri == null || algorithmUri.isEmpty()) {
            algorithm = channel.getSecurityPolicy().getAsymmetricEncryptionAlgorithm();
        } else {
            try {
                algorithm = SecurityAlgorithm.fromUri((String)algorithmUri);
            }
            catch (UaException e) {
                throw new UaException(0x80200000L);
            }
            if (algorithm != SecurityAlgorithm.Rsa15 && algorithm != SecurityAlgorithm.RsaOaep) {
                throw new UaException(0x80200000L);
            }
        }
        byte[] tokenBytes = token.getPassword().bytes();
        if (tokenBytes == null) {
            tokenBytes = new byte[]{};
        }
        if (securityPolicy != SecurityPolicy.None) {
            byte[] plainTextBytes = this.decryptTokenData(channel, algorithm, tokenBytes);
            int length = (plainTextBytes[3] & 0xFF) << 24 | (plainTextBytes[2] & 0xFF) << 16 | (plainTextBytes[1] & 0xFF) << 8 | plainTextBytes[0] & 0xFF;
            byte[] passwordBytes = new byte[length - lastNonceLength];
            byte[] nonceBytes = new byte[lastNonceLength];
            System.arraycopy(plainTextBytes, 4, passwordBytes, 0, passwordBytes.length);
            System.arraycopy(plainTextBytes, 4 + passwordBytes.length, nonceBytes, 0, lastNonceLength);
            String password = new String(passwordBytes);
            AuthenticationChallenge challenge = new AuthenticationChallenge(username, password);
            if (Arrays.equals(lastNonce.bytes(), nonceBytes) && this.predicate.test(challenge)) {
                return username;
            }
            throw new UaException(2149515264L);
        }
        String password = new String(tokenBytes);
        AuthenticationChallenge challenge = new AuthenticationChallenge(username, password);
        if (this.predicate.test(challenge)) {
            return username;
        }
        throw new UaException(2149515264L);
    }

    public static final class AuthenticationChallenge {
        private final String username;
        private final String password;

        public AuthenticationChallenge(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

