/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server;

import com.digitalpetri.opcua.sdk.core.ServerTable;
import com.digitalpetri.opcua.sdk.server.NamespaceManager;
import com.digitalpetri.opcua.sdk.server.SessionManager;
import com.digitalpetri.opcua.sdk.server.api.config.OpcUaServerConfig;
import com.digitalpetri.opcua.sdk.server.namespaces.OpcUaNamespace;
import com.digitalpetri.opcua.sdk.server.namespaces.VendorNamespace;
import com.digitalpetri.opcua.sdk.server.services.helpers.BrowseHelper;
import com.digitalpetri.opcua.sdk.server.subscriptions.Subscription;
import com.digitalpetri.opcua.stack.core.BuiltinReferenceType;
import com.digitalpetri.opcua.stack.core.ReferenceType;
import com.digitalpetri.opcua.stack.core.Stack;
import com.digitalpetri.opcua.stack.core.application.UaStackServer;
import com.digitalpetri.opcua.stack.core.application.services.AttributeServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.MethodServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.MonitoredItemServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.NodeManagementServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.SessionServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.SubscriptionServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.ViewServiceSet;
import com.digitalpetri.opcua.stack.core.channel.ChannelConfig;
import com.digitalpetri.opcua.stack.core.channel.ServerSecureChannel;
import com.digitalpetri.opcua.stack.core.security.SecurityPolicy;
import com.digitalpetri.opcua.stack.core.types.builtin.ByteString;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.enumerated.MessageSecurityMode;
import com.digitalpetri.opcua.stack.core.types.structured.ApplicationDescription;
import com.digitalpetri.opcua.stack.core.types.structured.EndpointDescription;
import com.digitalpetri.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import com.digitalpetri.opcua.stack.core.types.structured.UserTokenPolicy;
import com.digitalpetri.opcua.stack.core.util.ManifestUtil;
import com.digitalpetri.opcua.stack.server.config.UaTcpStackServerConfig;
import com.digitalpetri.opcua.stack.server.tcp.UaTcpStackServer;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaServer {
    public static final String SDK_VERSION = ManifestUtil.read((String)"X-SDK-Version").orElse("dev");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<ByteString, BrowseHelper.BrowseContinuationPoint> browseContinuationPoints = Maps.newConcurrentMap();
    private final Map<NodeId, ReferenceType> referenceTypes = Maps.newConcurrentMap();
    private final Map<UInteger, Subscription> subscriptions = Maps.newConcurrentMap();
    private final NamespaceManager namespaceManager = new NamespaceManager();
    private final SessionManager sessionManager = new SessionManager(this);
    private final ServerTable serverTable = new ServerTable();
    private final UaStackServer stackServer;
    private final EventBus eventBus;
    private final OpcUaNamespace uaNamespace;
    private final OpcUaServerConfig config;

    public OpcUaServer(OpcUaServerConfig config) {
        this.config = config;
        this.stackServer = new UaTcpStackServer((UaTcpStackServerConfig)config);
        this.stackServer.addServiceSet((AttributeServiceSet)this.sessionManager);
        this.stackServer.addServiceSet((MethodServiceSet)this.sessionManager);
        this.stackServer.addServiceSet((MonitoredItemServiceSet)this.sessionManager);
        this.stackServer.addServiceSet((NodeManagementServiceSet)this.sessionManager);
        this.stackServer.addServiceSet((SessionServiceSet)this.sessionManager);
        this.stackServer.addServiceSet((SubscriptionServiceSet)this.sessionManager);
        this.stackServer.addServiceSet((ViewServiceSet)this.sessionManager);
        this.uaNamespace = new OpcUaNamespace(this);
        this.namespaceManager.addNamespace(this.uaNamespace);
        this.namespaceManager.registerAndAdd(config.getApplicationUri(), index -> new VendorNamespace(this, config.getApplicationUri()));
        this.serverTable.addUri(this.stackServer.getApplicationDescription().getApplicationUri());
        for (BuiltinReferenceType referenceType : BuiltinReferenceType.values()) {
            this.referenceTypes.put(referenceType.getNodeId(), (ReferenceType)referenceType);
        }
        String configuredHostname = config.getHostname();
        for (String bindAddress : config.getBindAddresses()) {
            Sets.SetView hostnames = Sets.union((Set)Sets.newHashSet((Object[])new String[]{configuredHostname}), this.getHostnames(bindAddress));
            for (String hostname : hostnames) {
                for (SecurityPolicy securityPolicy : config.getSecurityPolicies()) {
                    MessageSecurityMode messageSecurity = securityPolicy == SecurityPolicy.None ? MessageSecurityMode.None : MessageSecurityMode.SignAndEncrypt;
                    String endpointUrl = OpcUaServer.endpointUrl(hostname, config.getBindPort(), config.getServerName());
                    Set certificates = config.getCertificateManager().getCertificates();
                    if (certificates.isEmpty() && securityPolicy == SecurityPolicy.None) {
                        this.logger.info("Binding endpoint {} to {} [{}/{}]", new Object[]{endpointUrl, bindAddress, securityPolicy, messageSecurity});
                        this.stackServer.addEndpoint(endpointUrl, bindAddress, null, securityPolicy, messageSecurity);
                        continue;
                    }
                    for (X509Certificate certificate : certificates) {
                        this.logger.info("Binding endpoint {} to {} [{}/{}]", new Object[]{endpointUrl, bindAddress, securityPolicy, messageSecurity});
                        this.stackServer.addEndpoint(endpointUrl, bindAddress, certificate, securityPolicy, messageSecurity);
                    }
                }
            }
        }
        this.eventBus = new AsyncEventBus("server", (Executor)this.stackServer.getExecutorService());
        this.logger.info("digitalpetri opc-ua stack version: {}", (Object)Stack.VERSION);
        this.logger.info("digitalpetri opc-ua sdk version: {}", (Object)SDK_VERSION);
    }

    private Set<String> getHostnames(String bindAddress) {
        HashSet hostnames;
        block6: {
            hostnames = Sets.newHashSet();
            try {
                InetAddress inetAddress = InetAddress.getByName(bindAddress);
                if (inetAddress.isAnyLocalAddress()) {
                    try {
                        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                        for (NetworkInterface ni : Collections.list(nis)) {
                            Collections.list(ni.getInetAddresses()).stream().filter(ia -> ia instanceof Inet4Address).forEach(ia -> {
                                hostnames.add(ia.getHostName());
                                hostnames.add(ia.getHostAddress());
                                hostnames.add(ia.getCanonicalHostName());
                            });
                        }
                        break block6;
                    }
                    catch (SocketException e) {
                        this.logger.warn("Failed to NetworkInterfaces for bind address: {}", (Object)bindAddress, (Object)e);
                        break block6;
                    }
                }
                hostnames.add(inetAddress.getHostName());
                hostnames.add(inetAddress.getHostAddress());
                hostnames.add(inetAddress.getCanonicalHostName());
            }
            catch (UnknownHostException e) {
                this.logger.warn("Failed to get InetAddress for bind address: {}", (Object)bindAddress, (Object)e);
            }
        }
        return hostnames;
    }

    public void startup() {
        this.stackServer.startup();
    }

    public void shutdown() {
        this.stackServer.shutdown();
    }

    private static String endpointUrl(String hostname, int port, String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("opc.tcp://%s:%d", hostname, port));
        if (!serverName.isEmpty()) {
            sb.append("/").append(serverName);
        }
        return sb.toString();
    }

    public OpcUaServerConfig getConfig() {
        return this.config;
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public OpcUaNamespace getUaNamespace() {
        return this.uaNamespace;
    }

    public ServerTable getServerTable() {
        return this.serverTable;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public Map<UInteger, Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public Optional<KeyPair> getKeyPair(ByteString thumbprint) {
        return this.stackServer.getCertificateManager().getKeyPair(thumbprint);
    }

    public Optional<X509Certificate> getCertificate(ByteString thumbprint) {
        return this.stackServer.getCertificateManager().getCertificate(thumbprint);
    }

    public ExecutorService getExecutorService() {
        return this.stackServer.getExecutorService();
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return Stack.sharedScheduledExecutor();
    }

    public ChannelConfig getChannelConfig() {
        return this.stackServer.getChannelConfig();
    }

    public EndpointDescription[] getEndpointDescriptions() {
        return this.stackServer.getEndpointDescriptions();
    }

    public List<UserTokenPolicy> getUserTokenPolicies() {
        return this.stackServer.getUserTokenPolicies();
    }

    public ApplicationDescription getApplicationDescription() {
        return this.stackServer.getApplicationDescription();
    }

    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        return this.stackServer.getSoftwareCertificates();
    }

    public void closeSecureChannel(ServerSecureChannel secureChannel) {
        this.stackServer.closeSecureChannel(secureChannel);
    }

    public UaStackServer getServer() {
        return this.stackServer;
    }

    public Map<NodeId, ReferenceType> getReferenceTypes() {
        return this.referenceTypes;
    }

    public Map<ByteString, BrowseHelper.BrowseContinuationPoint> getBrowseContinuationPoints() {
        return this.browseContinuationPoints;
    }
}

