/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.core;

import com.digitalpetri.opcua.stack.core.UaRuntimeException;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UShort;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.Unsigned;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NamespaceTable {
    public static final String OpcUaNamespace = "http://opcfoundation.org/UA/";
    private final BiMap<UShort, String> uriTable = HashBiMap.create();

    public NamespaceTable() {
        this.uriTable.put((Object)Unsigned.ushort((int)0), (Object)OpcUaNamespace);
    }

    public synchronized UShort addUri(String uri) {
        UShort index = Unsigned.ushort((int)1);
        while (this.uriTable.containsKey((Object)index)) {
            if ((index = Unsigned.ushort((int)(index.intValue() + 1))).intValue() != 65535) continue;
            throw new UaRuntimeException(0x80020000L, "uri table full");
        }
        this.uriTable.put((Object)index, (Object)uri);
        return index;
    }

    public synchronized void putUri(String uri, UShort index) {
        this.uriTable.put((Object)index, (Object)uri);
    }

    public synchronized String getUri(UShort index) {
        return (String)this.uriTable.get((Object)index);
    }

    public synchronized UShort getIndex(String uri) {
        return (UShort)this.uriTable.inverse().getOrDefault((Object)uri, null);
    }

    public synchronized String[] toArray() {
        List<String> uris = this.uriTable.entrySet().stream().sorted((e1, e2) -> ((UShort)e1.getKey()).intValue() - ((UShort)e2.getKey()).intValue()).map(Map.Entry::getValue).collect(Collectors.toList());
        return uris.toArray(new String[uris.size()]);
    }
}

