/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.util;

import com.digitalpetri.opcua.sdk.core.AccessLevel;
import com.digitalpetri.opcua.sdk.core.NumericRange;
import com.digitalpetri.opcua.sdk.core.WriteMask;
import com.digitalpetri.opcua.sdk.core.nodes.DataTypeNode;
import com.digitalpetri.opcua.sdk.core.nodes.MethodNode;
import com.digitalpetri.opcua.sdk.core.nodes.Node;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectNode;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectTypeNode;
import com.digitalpetri.opcua.sdk.core.nodes.ReferenceTypeNode;
import com.digitalpetri.opcua.sdk.core.nodes.VariableNode;
import com.digitalpetri.opcua.sdk.core.nodes.VariableTypeNode;
import com.digitalpetri.opcua.sdk.server.NamespaceManager;
import com.digitalpetri.opcua.stack.core.AttributeId;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.types.builtin.ByteString;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DateTime;
import com.digitalpetri.opcua.stack.core.types.builtin.ExpandedNodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.Unsigned;
import com.digitalpetri.opcua.stack.core.types.enumerated.NodeClass;
import com.digitalpetri.opcua.stack.core.util.ArrayUtil;
import com.digitalpetri.opcua.stack.core.util.TypeUtil;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;

public class AttributeWriter {
    public static void writeAttribute(NamespaceManager ns, Node node, AttributeId attributeId, DataValue value, @Nullable String indexRange) throws UaException {
        Variant updateVariant = value.getValue();
        if (indexRange != null) {
            NumericRange range = NumericRange.parse(indexRange);
            DataValue current = node.readAttribute(attributeId);
            Variant currentVariant = current.getValue();
            Object valueAtRange = NumericRange.writeToValueAtRange(currentVariant, updateVariant, range);
            updateVariant = new Variant(valueAtRange);
        }
        DateTime sourceTime = value.getSourceTime();
        DateTime serverTime = value.getServerTime();
        value = new DataValue(updateVariant, value.getStatusCode(), sourceTime == null || sourceTime.isNull() ? DateTime.now() : sourceTime, serverTime == null || serverTime.isNull() ? DateTime.now() : serverTime);
        AttributeWriter.writeNode(ns, node, attributeId, value);
    }

    private static void writeNode(NamespaceManager ns, Node node, AttributeId attributeId, DataValue value) throws UaException {
        switch (node.getNodeClass()) {
            case DataType: {
                AttributeWriter.writeDataTypeAttribute(ns, (DataTypeNode)node, attributeId, value);
                break;
            }
            case Method: {
                AttributeWriter.writeMethodAttribute(ns, (MethodNode)node, attributeId, value);
                break;
            }
            case Object: {
                AttributeWriter.writeObjectAttribute(ns, (ObjectNode)node, attributeId, value);
                break;
            }
            case ObjectType: {
                AttributeWriter.writeObjectTypeAttribute(ns, (ObjectTypeNode)node, attributeId, value);
                break;
            }
            case ReferenceType: {
                AttributeWriter.writeReferenceTypeAttribute(ns, (ReferenceTypeNode)node, attributeId, value);
                break;
            }
            case Variable: {
                AttributeWriter.writeVariableAttribute(ns, (VariableNode)node, attributeId, value);
                break;
            }
            case VariableType: {
                AttributeWriter.writeVariableTypeAttribute(ns, (VariableTypeNode)node, attributeId, value);
                break;
            }
            default: {
                throw new UaException(2153709568L);
            }
        }
    }

    private static void writeNodeAttribute(NamespaceManager ns, Node node, AttributeId attributeId, DataValue value) throws UaException {
        UInteger writeMask = node.getWriteMask().orElse(Unsigned.uint((int)0));
        EnumSet<WriteMask> writeMasks = WriteMask.fromMask(writeMask);
        switch (attributeId) {
            case NodeId: {
                if (writeMasks.contains((Object)WriteMask.NodeId)) {
                    node.setNodeId((NodeId)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case NodeClass: {
                if (writeMasks.contains((Object)WriteMask.NodeClass)) {
                    node.setNodeClass((NodeClass)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case BrowseName: {
                if (writeMasks.contains((Object)WriteMask.BrowseName)) {
                    node.setBrowseName((QualifiedName)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case DisplayName: {
                if (writeMasks.contains((Object)WriteMask.DisplayName)) {
                    node.setDisplayName((LocalizedText)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case Description: {
                if (writeMasks.contains((Object)WriteMask.Description)) {
                    node.setDescription((Optional)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case WriteMask: {
                if (writeMasks.contains((Object)WriteMask.WriteMask)) {
                    node.setWriteMask(Optional.ofNullable(AttributeWriter.extract(value)));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case UserWriteMask: {
                if (writeMasks.contains((Object)WriteMask.UserWriteMask)) {
                    node.setUserWriteMask(Optional.ofNullable(AttributeWriter.extract(value)));
                    break;
                }
                throw new UaException(2151350272L);
            }
            default: {
                throw new UaException(2150957056L);
            }
        }
    }

    private static void writeDataTypeAttribute(NamespaceManager ns, DataTypeNode node, AttributeId attributeId, DataValue value) throws UaException {
        UInteger writeMask = node.getWriteMask().orElse(Unsigned.uint((int)0));
        EnumSet<WriteMask> writeMasks = WriteMask.fromMask(writeMask);
        switch (attributeId) {
            case IsAbstract: {
                if (writeMasks.contains((Object)WriteMask.IsAbstract)) {
                    node.setIsAbstract((Boolean)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            default: {
                AttributeWriter.writeNodeAttribute(ns, node, attributeId, value);
            }
        }
    }

    private static void writeMethodAttribute(NamespaceManager ns, MethodNode node, AttributeId attributeId, DataValue value) throws UaException {
        UInteger writeMask = node.getWriteMask().orElse(Unsigned.uint((int)0));
        EnumSet<WriteMask> writeMasks = WriteMask.fromMask(writeMask);
        switch (attributeId) {
            case Executable: {
                if (writeMasks.contains((Object)WriteMask.Executable)) {
                    node.setExecutable((Boolean)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case UserExecutable: {
                if (writeMasks.contains((Object)WriteMask.UserExecutable)) {
                    node.setUserExecutable((Boolean)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            default: {
                AttributeWriter.writeNodeAttribute(ns, node, attributeId, value);
            }
        }
    }

    private static void writeObjectAttribute(NamespaceManager ns, ObjectNode node, AttributeId attributeId, DataValue value) throws UaException {
        UInteger writeMask = node.getWriteMask().orElse(Unsigned.uint((int)0));
        EnumSet<WriteMask> writeMasks = WriteMask.fromMask(writeMask);
        switch (attributeId) {
            case EventNotifier: {
                if (writeMasks.contains((Object)WriteMask.EventNotifier)) {
                    node.setWriteMask(Optional.ofNullable(AttributeWriter.extract(value)));
                    break;
                }
                throw new UaException(2151350272L);
            }
            default: {
                AttributeWriter.writeNodeAttribute(ns, node, attributeId, value);
            }
        }
    }

    private static void writeObjectTypeAttribute(NamespaceManager ns, ObjectTypeNode node, AttributeId attributeId, DataValue value) throws UaException {
        UInteger writeMask = node.getWriteMask().orElse(Unsigned.uint((int)0));
        EnumSet<WriteMask> writeMasks = WriteMask.fromMask(writeMask);
        switch (attributeId) {
            case IsAbstract: {
                if (writeMasks.contains((Object)WriteMask.IsAbstract)) {
                    node.setIsAbstract((Boolean)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            default: {
                AttributeWriter.writeNodeAttribute(ns, node, attributeId, value);
            }
        }
    }

    private static void writeReferenceTypeAttribute(NamespaceManager ns, ReferenceTypeNode node, AttributeId attributeId, DataValue value) throws UaException {
        UInteger writeMask = node.getWriteMask().orElse(Unsigned.uint((int)0));
        EnumSet<WriteMask> writeMasks = WriteMask.fromMask(writeMask);
        switch (attributeId) {
            case IsAbstract: {
                if (writeMasks.contains((Object)WriteMask.IsAbstract)) {
                    node.setIsAbstract((Boolean)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case Symmetric: {
                if (writeMasks.contains((Object)WriteMask.Symmetric)) {
                    node.setSymmetric((Boolean)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case InverseName: {
                if (writeMasks.contains((Object)WriteMask.InverseName)) {
                    node.setInverseName(Optional.ofNullable(AttributeWriter.extract(value)));
                    break;
                }
                throw new UaException(2151350272L);
            }
            default: {
                AttributeWriter.writeNodeAttribute(ns, node, attributeId, value);
            }
        }
    }

    private static void writeVariableAttribute(NamespaceManager ns, VariableNode node, AttributeId attributeId, DataValue value) throws UaException {
        EnumSet<AccessLevel> accessLevels = AccessLevel.fromMask(node.getAccessLevel());
        UInteger writeMask = node.getWriteMask().orElse(Unsigned.uint((int)0));
        EnumSet<WriteMask> writeMasks = WriteMask.fromMask(writeMask);
        switch (attributeId) {
            case Value: {
                if (accessLevels.contains((Object)AccessLevel.CurrentWrite)) {
                    value = AttributeWriter.validateDataType(ns, node.getDataType().expanded(), value);
                    AttributeWriter.validateArrayType(node.getValueRank(), node.getArrayDimensions(), value);
                    node.setValue(value);
                    break;
                }
                throw new UaException(2151350272L);
            }
            case DataType: {
                if (writeMasks.contains((Object)WriteMask.DataType)) {
                    node.setDataType((NodeId)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case ValueRank: {
                if (writeMasks.contains((Object)WriteMask.ValueRank)) {
                    node.setValueRank((Integer)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case ArrayDimensions: {
                if (writeMasks.contains((Object)WriteMask.ArrayDimensions)) {
                    node.setArrayDimensions(Optional.of(AttributeWriter.extract(value)));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case AccessLevel: {
                if (writeMasks.contains((Object)WriteMask.AccessLevel)) {
                    node.setAccessLevel((UByte)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case UserAccessLevel: {
                if (writeMasks.contains((Object)WriteMask.UserAccessLevel)) {
                    node.setUserAccessLevel((UByte)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case MinimumSamplingInterval: {
                if (writeMasks.contains((Object)WriteMask.MinimumSamplingInterval)) {
                    node.setMinimumSamplingInterval(Optional.of(AttributeWriter.extract(value)));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case Historizing: {
                if (writeMasks.contains((Object)WriteMask.Historizing)) {
                    node.setHistorizing((Boolean)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            default: {
                AttributeWriter.writeNodeAttribute(ns, node, attributeId, value);
            }
        }
    }

    private static void writeVariableTypeAttribute(NamespaceManager ns, VariableTypeNode node, AttributeId attributeId, DataValue value) throws UaException {
        UInteger writeMask = node.getWriteMask().orElse(Unsigned.uint((int)0));
        EnumSet<WriteMask> writeMasks = WriteMask.fromMask(writeMask);
        switch (attributeId) {
            case Value: {
                if (writeMasks.contains((Object)WriteMask.ValueForVariableType)) {
                    value = AttributeWriter.validateDataType(ns, node.getDataType().expanded(), value);
                    AttributeWriter.validateArrayType(node.getValueRank(), node.getArrayDimensions(), value);
                    node.setValue(Optional.ofNullable(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case DataType: {
                if (writeMasks.contains((Object)WriteMask.DataType)) {
                    node.setDataType((NodeId)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case ValueRank: {
                if (writeMasks.contains((Object)WriteMask.ValueRank)) {
                    node.setValueRank((Integer)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            case IsAbstract: {
                if (writeMasks.contains((Object)WriteMask.IsAbstract)) {
                    node.setIsAbstract((Boolean)AttributeWriter.extract(value));
                    break;
                }
                throw new UaException(2151350272L);
            }
            default: {
                AttributeWriter.writeNodeAttribute(ns, node, attributeId, value);
            }
        }
    }

    private static <T> T extract(DataValue value) throws UaException {
        Variant variant = value.getValue();
        if (variant == null) {
            return null;
        }
        Object o = variant.getValue();
        if (o == null) {
            return null;
        }
        try {
            return (T)o;
        }
        catch (ClassCastException e) {
            throw new UaException(2155085824L);
        }
    }

    private static DataValue validateDataType(NamespaceManager ns, ExpandedNodeId dataType, DataValue value) throws UaException {
        Class<?> actual;
        Variant variant = value.getValue();
        if (variant == null) {
            return value;
        }
        Object o = variant.getValue();
        if (o == null) {
            throw new UaException(2155085824L);
        }
        Class expected = TypeUtil.getBackingClass((ExpandedNodeId)dataType);
        Class<?> clazz = actual = o.getClass().isArray() ? o.getClass().getComponentType() : o.getClass();
        if (expected == null) {
            throw new UaException(2155085824L);
        }
        if (!expected.isAssignableFrom(actual)) {
            boolean byteStringToByteArray;
            boolean bl = byteStringToByteArray = o instanceof ByteString && expected == UByte.class;
            if (byteStringToByteArray) {
                ByteString byteString = (ByteString)o;
                return new DataValue(new Variant((Object)byteString.uBytes()), value.getStatusCode(), value.getSourceTime(), value.getServerTime());
            }
            throw new UaException(2155085824L);
        }
        return value;
    }

    private static void validateArrayType(int valueRank, Optional<UInteger[]> arrayDimensionsOpt, DataValue value) throws UaException {
        Variant variant = value.getValue();
        if (variant == null) {
            return;
        }
        Object o = variant.getValue();
        if (o == null) {
            return;
        }
        boolean valueIsArray = o.getClass().isArray();
        switch (valueRank) {
            case -3: {
                int[] valueDimensions;
                if (!valueIsArray || (valueDimensions = ArrayUtil.getDimensions((Object)o)).length <= 1) break;
                throw new UaException(2155085824L);
            }
            case -2: {
                break;
            }
            case -1: {
                if (!valueIsArray) break;
                throw new UaException(2155085824L);
            }
            case 0: {
                if (valueIsArray) break;
                throw new UaException(2155085824L);
            }
            default: {
                if (!valueIsArray) {
                    throw new UaException(2155085824L);
                }
                int[] valueDimensions = ArrayUtil.getDimensions((Object)o);
                if (valueDimensions.length != valueRank) {
                    throw new UaException(2155085824L);
                }
                int[] nodeDimensions = arrayDimensionsOpt.map(uia -> {
                    int[] arrayDimensions = new int[((UInteger[])uia).length];
                    for (int i = 0; i < ((UInteger[])uia).length; ++i) {
                        arrayDimensions[i] = uia[i].intValue();
                    }
                    return arrayDimensions;
                }).orElse(new int[0]);
                if (nodeDimensions.length <= 0) break;
                if (nodeDimensions.length != valueDimensions.length) {
                    throw new UaException(2155085824L);
                }
                for (int i = 0; i < nodeDimensions.length; ++i) {
                    if (nodeDimensions[i] <= 0 || valueDimensions[i] <= nodeDimensions[i]) continue;
                    throw new UaException(2155085824L);
                }
            }
        }
    }
}

