/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.services;

import com.digitalpetri.opcua.sdk.server.DiagnosticsContext;
import com.digitalpetri.opcua.sdk.server.OpcUaServer;
import com.digitalpetri.opcua.sdk.server.Session;
import com.digitalpetri.opcua.sdk.server.api.MethodServices;
import com.digitalpetri.opcua.sdk.server.api.Namespace;
import com.digitalpetri.opcua.sdk.server.services.ServiceAttributes;
import com.digitalpetri.opcua.sdk.server.services.ServiceMetric;
import com.digitalpetri.opcua.sdk.server.util.FutureUtils;
import com.digitalpetri.opcua.sdk.server.util.PendingCall;
import com.digitalpetri.opcua.stack.core.application.services.MethodServiceSet;
import com.digitalpetri.opcua.stack.core.application.services.ServiceRequest;
import com.digitalpetri.opcua.stack.core.serialization.UaResponseMessage;
import com.digitalpetri.opcua.stack.core.types.builtin.DiagnosticInfo;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UShort;
import com.digitalpetri.opcua.stack.core.types.structured.CallMethodResult;
import com.digitalpetri.opcua.stack.core.types.structured.CallRequest;
import com.digitalpetri.opcua.stack.core.types.structured.CallResponse;
import com.digitalpetri.opcua.stack.core.types.structured.ResponseHeader;
import com.digitalpetri.opcua.stack.core.util.ConversionUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class MethodServices
implements MethodServiceSet {
    private final ServiceMetric callCounter = new ServiceMetric();

    public void onCall(ServiceRequest<CallRequest, CallResponse> service) {
        this.callCounter.record(service);
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        CallRequest request = (CallRequest)service.getRequest();
        List pendingCalls = Arrays.stream(request.getMethodsToCall()).map(PendingCall::new).collect(Collectors.toList());
        Map<UShort, List<PendingCall>> byNamespace = pendingCalls.stream().collect(Collectors.groupingBy(pending -> pending.getInput().getMethodId().getNamespaceIndex()));
        byNamespace.keySet().forEach(index -> {
            List pending = (List)byNamespace.get(index);
            List requests = pending.stream().map(PendingCall::getInput).collect(Collectors.toList());
            Namespace namespace = server.getNamespaceManager().getNamespace((UShort)index);
            CompletableFuture<List<CallMethodResult>> future = new CompletableFuture<List<CallMethodResult>>();
            MethodServices.CallContext context = new MethodServices.CallContext(server, session, future, diagnosticsContext);
            server.getExecutorService().execute(() -> namespace.call(context, requests));
            future.thenAccept(values -> {
                for (int i = 0; i < values.size(); ++i) {
                    ((PendingCall)pending.get(i)).getFuture().complete((CallMethodResult)values.get(i));
                }
            });
        });
        List futures = pendingCalls.stream().map(PendingCall::getFuture).collect(Collectors.toList());
        FutureUtils.sequence(futures).thenAcceptAsync(values -> {
            ResponseHeader header = service.createResponseHeader();
            CallResponse response = new CallResponse(header, (CallMethodResult[])ConversionUtil.a((List)values, CallMethodResult.class), new DiagnosticInfo[0]);
            service.setResponse((UaResponseMessage)response);
        }, (Executor)server.getExecutorService());
    }
}

