/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.variables;

import com.digitalpetri.opcua.sdk.core.model.UaMandatory;
import com.digitalpetri.opcua.sdk.core.model.variables.SessionDiagnosticsVariableType;
import com.digitalpetri.opcua.sdk.core.nodes.VariableNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.variables.BaseDataVariableNode;
import com.digitalpetri.opcua.sdk.server.util.UaVariableType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DateTime;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.structured.ApplicationDescription;
import com.digitalpetri.opcua.stack.core.types.structured.ServiceCounterDataType;
import com.digitalpetri.opcua.stack.core.types.structured.SessionDiagnosticsDataType;
import java.util.Optional;

@UaVariableType(name="SessionDiagnosticsVariableType")
public class SessionDiagnosticsVariableNode
extends BaseDataVariableNode
implements SessionDiagnosticsVariableType {
    public SessionDiagnosticsVariableNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, DataValue value, NodeId dataType, Integer valueRank, Optional<UInteger[]> arrayDimensions, UByte accessLevel, UByte userAccessLevel, Optional<Double> minimumSamplingInterval, boolean historizing) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public DataValue getValue() {
        SessionDiagnosticsDataType value = new SessionDiagnosticsDataType(this.getSessionId(), this.getSessionName(), this.getClientDescription(), this.getServerUri(), this.getEndpointUrl(), this.getLocaleIds(), this.getActualSessionTimeout(), this.getMaxResponseMessageSize(), this.getClientConnectionTime(), this.getClientLastContactTime(), this.getCurrentSubscriptionsCount(), this.getCurrentMonitoredItemsCount(), this.getCurrentPublishRequestsInQueue(), this.getTotalRequestCount(), this.getUnauthorizedRequestCount(), this.getReadCount(), this.getHistoryReadCount(), this.getWriteCount(), this.getHistoryUpdateCount(), this.getCallCount(), this.getCreateMonitoredItemsCount(), this.getModifyMonitoredItemsCount(), this.getSetMonitoringModeCount(), this.getSetTriggeringCount(), this.getDeleteMonitoredItemsCount(), this.getCreateSubscriptionCount(), this.getModifySubscriptionCount(), this.getSetPublishingModeCount(), this.getPublishCount(), this.getRepublishCount(), this.getTransferSubscriptionsCount(), this.getDeleteSubscriptionsCount(), this.getAddNodesCount(), this.getAddReferencesCount(), this.getDeleteNodesCount(), this.getDeleteReferencesCount(), this.getBrowseCount(), this.getBrowseNextCount(), this.getTranslateBrowsePathsToNodeIdsCount(), this.getQueryFirstCount(), this.getQueryNextCount(), this.getRegisterNodesCount(), this.getUnregisterNodesCount());
        return new DataValue(new Variant((Object)value));
    }

    @Override
    public synchronized void setValue(DataValue value) {
        SessionDiagnosticsDataType v = (SessionDiagnosticsDataType)value.getValue().getValue();
        this.setSessionId(v.getSessionId());
        this.setSessionName(v.getSessionName());
        this.setClientDescription(v.getClientDescription());
        this.setServerUri(v.getServerUri());
        this.setEndpointUrl(v.getEndpointUrl());
        this.setLocaleIds(v.getLocaleIds());
        this.setActualSessionTimeout(v.getActualSessionTimeout());
        this.setMaxResponseMessageSize(v.getMaxResponseMessageSize());
        this.setClientConnectionTime(v.getClientConnectionTime());
        this.setClientLastContactTime(v.getClientLastContactTime());
        this.setCurrentSubscriptionsCount(v.getCurrentSubscriptionsCount());
        this.setCurrentMonitoredItemsCount(v.getCurrentMonitoredItemsCount());
        this.setCurrentPublishRequestsInQueue(v.getCurrentPublishRequestsInQueue());
        this.setTotalRequestCount(v.getTotalRequestCount());
        this.setUnauthorizedRequestCount(v.getUnauthorizedRequestCount());
        this.setReadCount(v.getReadCount());
        this.setHistoryReadCount(v.getHistoryReadCount());
        this.setWriteCount(v.getWriteCount());
        this.setHistoryUpdateCount(v.getHistoryUpdateCount());
        this.setCallCount(v.getCallCount());
        this.setCreateMonitoredItemsCount(v.getCreateMonitoredItemsCount());
        this.setModifyMonitoredItemsCount(v.getModifyMonitoredItemsCount());
        this.setSetMonitoringModeCount(v.getSetMonitoringModeCount());
        this.setSetTriggeringCount(v.getSetTriggeringCount());
        this.setDeleteMonitoredItemsCount(v.getDeleteMonitoredItemsCount());
        this.setCreateSubscriptionCount(v.getCreateSubscriptionCount());
        this.setModifySubscriptionCount(v.getModifySubscriptionCount());
        this.setSetPublishingModeCount(v.getSetPublishingModeCount());
        this.setPublishCount(v.getPublishCount());
        this.setRepublishCount(v.getRepublishCount());
        this.setTransferSubscriptionsCount(v.getTransferSubscriptionsCount());
        this.setDeleteSubscriptionsCount(v.getDeleteSubscriptionsCount());
        this.setAddNodesCount(v.getAddNodesCount());
        this.setAddReferencesCount(v.getAddReferencesCount());
        this.setDeleteNodesCount(v.getDeleteNodesCount());
        this.setDeleteReferencesCount(v.getDeleteReferencesCount());
        this.setBrowseCount(v.getBrowseCount());
        this.setBrowseNextCount(v.getBrowseNextCount());
        this.setTranslateBrowsePathsToNodeIdsCount(v.getTranslateBrowsePathsToNodeIdsCount());
        this.setQueryFirstCount(v.getQueryFirstCount());
        this.setQueryNextCount(v.getQueryNextCount());
        this.setRegisterNodesCount(v.getRegisterNodesCount());
        this.setUnregisterNodesCount(v.getUnregisterNodesCount());
        this.fireAttributeChanged(13, value);
    }

    @Override
    @UaMandatory(value="SessionId")
    public NodeId getSessionId() {
        Optional<VariableNode> node = this.getVariableComponent("SessionId");
        return node.map(n -> (NodeId)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="SessionName")
    public String getSessionName() {
        Optional<VariableNode> node = this.getVariableComponent("SessionName");
        return node.map(n -> (String)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ClientDescription")
    public ApplicationDescription getClientDescription() {
        Optional<VariableNode> node = this.getVariableComponent("ClientDescription");
        return node.map(n -> (ApplicationDescription)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ServerUri")
    public String getServerUri() {
        Optional<VariableNode> node = this.getVariableComponent("ServerUri");
        return node.map(n -> (String)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="EndpointUrl")
    public String getEndpointUrl() {
        Optional<VariableNode> node = this.getVariableComponent("EndpointUrl");
        return node.map(n -> (String)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="LocaleIds")
    public String[] getLocaleIds() {
        Optional<VariableNode> node = this.getVariableComponent("LocaleIds");
        return node.map(n -> (String[])n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ActualSessionTimeout")
    public Double getActualSessionTimeout() {
        Optional<VariableNode> node = this.getVariableComponent("ActualSessionTimeout");
        return node.map(n -> (Double)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="MaxResponseMessageSize")
    public UInteger getMaxResponseMessageSize() {
        Optional<VariableNode> node = this.getVariableComponent("MaxResponseMessageSize");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ClientConnectionTime")
    public DateTime getClientConnectionTime() {
        Optional<VariableNode> node = this.getVariableComponent("ClientConnectionTime");
        return node.map(n -> (DateTime)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ClientLastContactTime")
    public DateTime getClientLastContactTime() {
        Optional<VariableNode> node = this.getVariableComponent("ClientLastContactTime");
        return node.map(n -> (DateTime)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="CurrentSubscriptionsCount")
    public UInteger getCurrentSubscriptionsCount() {
        Optional<VariableNode> node = this.getVariableComponent("CurrentSubscriptionsCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="CurrentMonitoredItemsCount")
    public UInteger getCurrentMonitoredItemsCount() {
        Optional<VariableNode> node = this.getVariableComponent("CurrentMonitoredItemsCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="CurrentPublishRequestsInQueue")
    public UInteger getCurrentPublishRequestsInQueue() {
        Optional<VariableNode> node = this.getVariableComponent("CurrentPublishRequestsInQueue");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="TotalRequestCount")
    public ServiceCounterDataType getTotalRequestCount() {
        Optional<VariableNode> node = this.getVariableComponent("TotalRequestCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="UnauthorizedRequestCount")
    public UInteger getUnauthorizedRequestCount() {
        Optional<VariableNode> node = this.getVariableComponent("UnauthorizedRequestCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ReadCount")
    public ServiceCounterDataType getReadCount() {
        Optional<VariableNode> node = this.getVariableComponent("ReadCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="HistoryReadCount")
    public ServiceCounterDataType getHistoryReadCount() {
        Optional<VariableNode> node = this.getVariableComponent("HistoryReadCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="WriteCount")
    public ServiceCounterDataType getWriteCount() {
        Optional<VariableNode> node = this.getVariableComponent("WriteCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="HistoryUpdateCount")
    public ServiceCounterDataType getHistoryUpdateCount() {
        Optional<VariableNode> node = this.getVariableComponent("HistoryUpdateCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="CallCount")
    public ServiceCounterDataType getCallCount() {
        Optional<VariableNode> node = this.getVariableComponent("CallCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="CreateMonitoredItemsCount")
    public ServiceCounterDataType getCreateMonitoredItemsCount() {
        Optional<VariableNode> node = this.getVariableComponent("CreateMonitoredItemsCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ModifyMonitoredItemsCount")
    public ServiceCounterDataType getModifyMonitoredItemsCount() {
        Optional<VariableNode> node = this.getVariableComponent("ModifyMonitoredItemsCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="SetMonitoringModeCount")
    public ServiceCounterDataType getSetMonitoringModeCount() {
        Optional<VariableNode> node = this.getVariableComponent("SetMonitoringModeCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="SetTriggeringCount")
    public ServiceCounterDataType getSetTriggeringCount() {
        Optional<VariableNode> node = this.getVariableComponent("SetTriggeringCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="DeleteMonitoredItemsCount")
    public ServiceCounterDataType getDeleteMonitoredItemsCount() {
        Optional<VariableNode> node = this.getVariableComponent("DeleteMonitoredItemsCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="CreateSubscriptionCount")
    public ServiceCounterDataType getCreateSubscriptionCount() {
        Optional<VariableNode> node = this.getVariableComponent("CreateSubscriptionCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ModifySubscriptionCount")
    public ServiceCounterDataType getModifySubscriptionCount() {
        Optional<VariableNode> node = this.getVariableComponent("ModifySubscriptionCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="SetPublishingModeCount")
    public ServiceCounterDataType getSetPublishingModeCount() {
        Optional<VariableNode> node = this.getVariableComponent("SetPublishingModeCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="PublishCount")
    public ServiceCounterDataType getPublishCount() {
        Optional<VariableNode> node = this.getVariableComponent("PublishCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="RepublishCount")
    public ServiceCounterDataType getRepublishCount() {
        Optional<VariableNode> node = this.getVariableComponent("RepublishCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="TransferSubscriptionsCount")
    public ServiceCounterDataType getTransferSubscriptionsCount() {
        Optional<VariableNode> node = this.getVariableComponent("TransferSubscriptionsCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="DeleteSubscriptionsCount")
    public ServiceCounterDataType getDeleteSubscriptionsCount() {
        Optional<VariableNode> node = this.getVariableComponent("DeleteSubscriptionsCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="AddNodesCount")
    public ServiceCounterDataType getAddNodesCount() {
        Optional<VariableNode> node = this.getVariableComponent("AddNodesCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="AddReferencesCount")
    public ServiceCounterDataType getAddReferencesCount() {
        Optional<VariableNode> node = this.getVariableComponent("AddReferencesCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="DeleteNodesCount")
    public ServiceCounterDataType getDeleteNodesCount() {
        Optional<VariableNode> node = this.getVariableComponent("DeleteNodesCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="DeleteReferencesCount")
    public ServiceCounterDataType getDeleteReferencesCount() {
        Optional<VariableNode> node = this.getVariableComponent("DeleteReferencesCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="BrowseCount")
    public ServiceCounterDataType getBrowseCount() {
        Optional<VariableNode> node = this.getVariableComponent("BrowseCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="BrowseNextCount")
    public ServiceCounterDataType getBrowseNextCount() {
        Optional<VariableNode> node = this.getVariableComponent("BrowseNextCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="TranslateBrowsePathsToNodeIdsCount")
    public ServiceCounterDataType getTranslateBrowsePathsToNodeIdsCount() {
        Optional<VariableNode> node = this.getVariableComponent("TranslateBrowsePathsToNodeIdsCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="QueryFirstCount")
    public ServiceCounterDataType getQueryFirstCount() {
        Optional<VariableNode> node = this.getVariableComponent("QueryFirstCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="QueryNextCount")
    public ServiceCounterDataType getQueryNextCount() {
        Optional<VariableNode> node = this.getVariableComponent("QueryNextCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="RegisterNodesCount")
    public ServiceCounterDataType getRegisterNodesCount() {
        Optional<VariableNode> node = this.getVariableComponent("RegisterNodesCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="UnregisterNodesCount")
    public ServiceCounterDataType getUnregisterNodesCount() {
        Optional<VariableNode> node = this.getVariableComponent("UnregisterNodesCount");
        return node.map(n -> (ServiceCounterDataType)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public synchronized void setSessionId(NodeId sessionId) {
        this.getVariableComponent("SessionId").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)sessionId)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setSessionName(String sessionName) {
        this.getVariableComponent("SessionName").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)sessionName)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setClientDescription(ApplicationDescription clientDescription) {
        this.getVariableComponent("ClientDescription").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)clientDescription)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setServerUri(String serverUri) {
        this.getVariableComponent("ServerUri").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)serverUri)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setEndpointUrl(String endpointUrl) {
        this.getVariableComponent("EndpointUrl").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)endpointUrl)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setLocaleIds(String[] localeIds) {
        this.getVariableComponent("LocaleIds").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)localeIds)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setActualSessionTimeout(Double actualSessionTimeout) {
        this.getVariableComponent("ActualSessionTimeout").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)actualSessionTimeout)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setMaxResponseMessageSize(UInteger maxResponseMessageSize) {
        this.getVariableComponent("MaxResponseMessageSize").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)maxResponseMessageSize)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setClientConnectionTime(DateTime clientConnectionTime) {
        this.getVariableComponent("ClientConnectionTime").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)clientConnectionTime)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setClientLastContactTime(DateTime clientLastContactTime) {
        this.getVariableComponent("ClientLastContactTime").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)clientLastContactTime)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setCurrentSubscriptionsCount(UInteger currentSubscriptionsCount) {
        this.getVariableComponent("CurrentSubscriptionsCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)currentSubscriptionsCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setCurrentMonitoredItemsCount(UInteger currentMonitoredItemsCount) {
        this.getVariableComponent("CurrentMonitoredItemsCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)currentMonitoredItemsCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setCurrentPublishRequestsInQueue(UInteger currentPublishRequestsInQueue) {
        this.getVariableComponent("CurrentPublishRequestsInQueue").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)currentPublishRequestsInQueue)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setTotalRequestCount(ServiceCounterDataType totalRequestCount) {
        this.getVariableComponent("TotalRequestCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)totalRequestCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setUnauthorizedRequestCount(UInteger unauthorizedRequestCount) {
        this.getVariableComponent("UnauthorizedRequestCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)unauthorizedRequestCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setReadCount(ServiceCounterDataType readCount) {
        this.getVariableComponent("ReadCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)readCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setHistoryReadCount(ServiceCounterDataType historyReadCount) {
        this.getVariableComponent("HistoryReadCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)historyReadCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setWriteCount(ServiceCounterDataType writeCount) {
        this.getVariableComponent("WriteCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)writeCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setHistoryUpdateCount(ServiceCounterDataType historyUpdateCount) {
        this.getVariableComponent("HistoryUpdateCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)historyUpdateCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setCallCount(ServiceCounterDataType callCount) {
        this.getVariableComponent("CallCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)callCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setCreateMonitoredItemsCount(ServiceCounterDataType createMonitoredItemsCount) {
        this.getVariableComponent("CreateMonitoredItemsCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)createMonitoredItemsCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setModifyMonitoredItemsCount(ServiceCounterDataType modifyMonitoredItemsCount) {
        this.getVariableComponent("ModifyMonitoredItemsCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)modifyMonitoredItemsCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setSetMonitoringModeCount(ServiceCounterDataType setMonitoringModeCount) {
        this.getVariableComponent("SetMonitoringModeCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)setMonitoringModeCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setSetTriggeringCount(ServiceCounterDataType setTriggeringCount) {
        this.getVariableComponent("SetTriggeringCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)setTriggeringCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setDeleteMonitoredItemsCount(ServiceCounterDataType deleteMonitoredItemsCount) {
        this.getVariableComponent("DeleteMonitoredItemsCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)deleteMonitoredItemsCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setCreateSubscriptionCount(ServiceCounterDataType createSubscriptionCount) {
        this.getVariableComponent("CreateSubscriptionCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)createSubscriptionCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setModifySubscriptionCount(ServiceCounterDataType modifySubscriptionCount) {
        this.getVariableComponent("ModifySubscriptionCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)modifySubscriptionCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setSetPublishingModeCount(ServiceCounterDataType setPublishingModeCount) {
        this.getVariableComponent("SetPublishingModeCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)setPublishingModeCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setPublishCount(ServiceCounterDataType publishCount) {
        this.getVariableComponent("PublishCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)publishCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setRepublishCount(ServiceCounterDataType republishCount) {
        this.getVariableComponent("RepublishCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)republishCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setTransferSubscriptionsCount(ServiceCounterDataType transferSubscriptionsCount) {
        this.getVariableComponent("TransferSubscriptionsCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)transferSubscriptionsCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setDeleteSubscriptionsCount(ServiceCounterDataType deleteSubscriptionsCount) {
        this.getVariableComponent("DeleteSubscriptionsCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)deleteSubscriptionsCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setAddNodesCount(ServiceCounterDataType addNodesCount) {
        this.getVariableComponent("AddNodesCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)addNodesCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setAddReferencesCount(ServiceCounterDataType addReferencesCount) {
        this.getVariableComponent("AddReferencesCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)addReferencesCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setDeleteNodesCount(ServiceCounterDataType deleteNodesCount) {
        this.getVariableComponent("DeleteNodesCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)deleteNodesCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setDeleteReferencesCount(ServiceCounterDataType deleteReferencesCount) {
        this.getVariableComponent("DeleteReferencesCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)deleteReferencesCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setBrowseCount(ServiceCounterDataType browseCount) {
        this.getVariableComponent("BrowseCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)browseCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setBrowseNextCount(ServiceCounterDataType browseNextCount) {
        this.getVariableComponent("BrowseNextCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)browseNextCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setTranslateBrowsePathsToNodeIdsCount(ServiceCounterDataType translateBrowsePathsToNodeIdsCount) {
        this.getVariableComponent("TranslateBrowsePathsToNodeIdsCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)translateBrowsePathsToNodeIdsCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setQueryFirstCount(ServiceCounterDataType queryFirstCount) {
        this.getVariableComponent("QueryFirstCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)queryFirstCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setQueryNextCount(ServiceCounterDataType queryNextCount) {
        this.getVariableComponent("QueryNextCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)queryNextCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setRegisterNodesCount(ServiceCounterDataType registerNodesCount) {
        this.getVariableComponent("RegisterNodesCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)registerNodesCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setUnregisterNodesCount(ServiceCounterDataType unregisterNodesCount) {
        this.getVariableComponent("UnregisterNodesCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)unregisterNodesCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }
}

