/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.variables;

import com.digitalpetri.opcua.sdk.core.model.UaMandatory;
import com.digitalpetri.opcua.sdk.core.model.variables.ServerStatusType;
import com.digitalpetri.opcua.sdk.core.nodes.VariableNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.variables.BaseDataVariableNode;
import com.digitalpetri.opcua.sdk.server.util.UaVariableType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DateTime;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.enumerated.ServerState;
import com.digitalpetri.opcua.stack.core.types.structured.BuildInfo;
import com.digitalpetri.opcua.stack.core.types.structured.ServerStatusDataType;
import java.util.Optional;

@UaVariableType(name="ServerStatusType")
public class ServerStatusNode
extends BaseDataVariableNode
implements ServerStatusType {
    public ServerStatusNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, DataValue value, NodeId dataType, Integer valueRank, Optional<UInteger[]> arrayDimensions, UByte accessLevel, UByte userAccessLevel, Optional<Double> minimumSamplingInterval, boolean historizing) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public DataValue getValue() {
        ServerStatusDataType value = new ServerStatusDataType(this.getStartTime(), this.getCurrentTime(), this.getState(), this.getBuildInfo(), this.getSecondsTillShutdown(), this.getShutdownReason());
        return new DataValue(new Variant((Object)value));
    }

    @Override
    public synchronized void setValue(DataValue value) {
        ServerStatusDataType v = (ServerStatusDataType)value.getValue().getValue();
        this.setStartTime(v.getStartTime());
        this.setCurrentTime(v.getCurrentTime());
        this.setState(v.getState());
        this.setBuildInfo(v.getBuildInfo());
        this.setSecondsTillShutdown(v.getSecondsTillShutdown());
        this.setShutdownReason(v.getShutdownReason());
        this.fireAttributeChanged(13, value);
    }

    @Override
    @UaMandatory(value="StartTime")
    public DateTime getStartTime() {
        Optional<VariableNode> node = this.getVariableComponent("StartTime");
        return node.map(n -> (DateTime)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="CurrentTime")
    public DateTime getCurrentTime() {
        Optional<VariableNode> node = this.getVariableComponent("CurrentTime");
        return node.map(n -> (DateTime)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="State")
    public ServerState getState() {
        Optional<VariableNode> node = this.getVariableComponent("State");
        return node.map(n -> {
            Integer value = (Integer)n.getValue().getValue().getValue();
            return ServerState.from((Integer)value);
        }).orElse(null);
    }

    @Override
    @UaMandatory(value="BuildInfo")
    public BuildInfo getBuildInfo() {
        Optional<VariableNode> node = this.getVariableComponent("BuildInfo");
        return node.map(n -> (BuildInfo)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="SecondsTillShutdown")
    public UInteger getSecondsTillShutdown() {
        Optional<VariableNode> node = this.getVariableComponent("SecondsTillShutdown");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="ShutdownReason")
    public LocalizedText getShutdownReason() {
        Optional<VariableNode> node = this.getVariableComponent("ShutdownReason");
        return node.map(n -> (LocalizedText)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public synchronized void setStartTime(DateTime startTime) {
        this.getVariableComponent("StartTime").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)startTime)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setCurrentTime(DateTime currentTime) {
        this.getVariableComponent("CurrentTime").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)currentTime)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setState(ServerState state) {
        this.getVariableComponent("State").ifPresent(n -> {
            Integer value = state.getValue();
            n.setValue(new DataValue(new Variant((Object)value)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setBuildInfo(BuildInfo buildInfo) {
        this.getVariableComponent("BuildInfo").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)buildInfo)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setSecondsTillShutdown(UInteger secondsTillShutdown) {
        this.getVariableComponent("SecondsTillShutdown").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)secondsTillShutdown)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setShutdownReason(LocalizedText shutdownReason) {
        this.getVariableComponent("ShutdownReason").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)shutdownReason)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }
}

