/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.objects;

import com.digitalpetri.opcua.sdk.core.model.objects.ShelvedStateMachineType;
import com.digitalpetri.opcua.sdk.core.model.objects.StateType;
import com.digitalpetri.opcua.sdk.core.model.objects.TransitionType;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.objects.FiniteStateMachineNode;
import com.digitalpetri.opcua.sdk.server.util.UaObjectType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import java.util.Optional;

@UaObjectType(name="ShelvedStateMachineType")
public class ShelvedStateMachineNode
extends FiniteStateMachineNode
implements ShelvedStateMachineType {
    public ShelvedStateMachineNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, UByte eventNotifier) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public Double getUnshelveTime() {
        Optional<Object> unshelveTime = this.getProperty("UnshelveTime");
        return unshelveTime.orElse(null);
    }

    @Override
    public StateType getUnshelved() {
        Optional<ObjectNode> unshelved = this.getObjectComponent("Unshelved");
        return unshelved.map(node -> (StateType)((Object)node)).orElse(null);
    }

    @Override
    public StateType getTimedShelved() {
        Optional<ObjectNode> timedShelved = this.getObjectComponent("TimedShelved");
        return timedShelved.map(node -> (StateType)((Object)node)).orElse(null);
    }

    @Override
    public StateType getOneShotShelved() {
        Optional<ObjectNode> oneShotShelved = this.getObjectComponent("OneShotShelved");
        return oneShotShelved.map(node -> (StateType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getUnshelvedToTimedShelved() {
        Optional<ObjectNode> unshelvedToTimedShelved = this.getObjectComponent("UnshelvedToTimedShelved");
        return unshelvedToTimedShelved.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getUnshelvedToOneShotShelved() {
        Optional<ObjectNode> unshelvedToOneShotShelved = this.getObjectComponent("UnshelvedToOneShotShelved");
        return unshelvedToOneShotShelved.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getTimedShelvedToUnshelved() {
        Optional<ObjectNode> timedShelvedToUnshelved = this.getObjectComponent("TimedShelvedToUnshelved");
        return timedShelvedToUnshelved.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getTimedShelvedToOneShotShelved() {
        Optional<ObjectNode> timedShelvedToOneShotShelved = this.getObjectComponent("TimedShelvedToOneShotShelved");
        return timedShelvedToOneShotShelved.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getOneShotShelvedToUnshelved() {
        Optional<ObjectNode> oneShotShelvedToUnshelved = this.getObjectComponent("OneShotShelvedToUnshelved");
        return oneShotShelvedToUnshelved.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getOneShotShelvedToTimedShelved() {
        Optional<ObjectNode> oneShotShelvedToTimedShelved = this.getObjectComponent("OneShotShelvedToTimedShelved");
        return oneShotShelvedToTimedShelved.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public synchronized void setUnshelveTime(Double unshelveTime) {
        this.getPropertyNode("UnshelveTime").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)unshelveTime))));
    }
}

