/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.objects;

import com.digitalpetri.opcua.sdk.core.model.objects.NamespacesType;
import com.digitalpetri.opcua.sdk.core.model.objects.ServerCapabilitiesType;
import com.digitalpetri.opcua.sdk.core.model.objects.ServerDiagnosticsType;
import com.digitalpetri.opcua.sdk.core.model.objects.ServerRedundancyType;
import com.digitalpetri.opcua.sdk.core.model.objects.ServerType;
import com.digitalpetri.opcua.sdk.core.model.objects.VendorServerInfoType;
import com.digitalpetri.opcua.sdk.core.model.variables.ServerStatusType;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectNode;
import com.digitalpetri.opcua.sdk.core.nodes.VariableNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.objects.BaseObjectNode;
import com.digitalpetri.opcua.sdk.server.util.UaObjectType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import java.util.Optional;

@UaObjectType(name="ServerType")
public class ServerNode
extends BaseObjectNode
implements ServerType {
    public ServerNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, UByte eventNotifier) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public String[] getServerArray() {
        Optional<Object> serverArray = this.getProperty("ServerArray");
        return serverArray.orElse(null);
    }

    @Override
    public String[] getNamespaceArray() {
        Optional<Object> namespaceArray = this.getProperty("NamespaceArray");
        return namespaceArray.orElse(null);
    }

    @Override
    public ServerStatusType getServerStatus() {
        Optional<VariableNode> serverStatus = this.getVariableComponent("ServerStatus");
        return serverStatus.map(node -> (ServerStatusType)((Object)node)).orElse(null);
    }

    @Override
    public UByte getServiceLevel() {
        Optional<Object> serviceLevel = this.getProperty("ServiceLevel");
        return serviceLevel.orElse(null);
    }

    @Override
    public Boolean getAuditing() {
        Optional<Object> auditing = this.getProperty("Auditing");
        return auditing.orElse(null);
    }

    @Override
    public ServerCapabilitiesType getServerCapabilities() {
        Optional<ObjectNode> serverCapabilities = this.getObjectComponent("ServerCapabilities");
        return serverCapabilities.map(node -> (ServerCapabilitiesType)((Object)node)).orElse(null);
    }

    @Override
    public ServerDiagnosticsType getServerDiagnostics() {
        Optional<ObjectNode> serverDiagnostics = this.getObjectComponent("ServerDiagnostics");
        return serverDiagnostics.map(node -> (ServerDiagnosticsType)((Object)node)).orElse(null);
    }

    @Override
    public VendorServerInfoType getVendorServerInfo() {
        Optional<ObjectNode> vendorServerInfo = this.getObjectComponent("VendorServerInfo");
        return vendorServerInfo.map(node -> (VendorServerInfoType)((Object)node)).orElse(null);
    }

    @Override
    public ServerRedundancyType getServerRedundancy() {
        Optional<ObjectNode> serverRedundancy = this.getObjectComponent("ServerRedundancy");
        return serverRedundancy.map(node -> (ServerRedundancyType)((Object)node)).orElse(null);
    }

    @Override
    public NamespacesType getNamespaces() {
        Optional<ObjectNode> namespaces = this.getObjectComponent("Namespaces");
        return namespaces.map(node -> (NamespacesType)((Object)node)).orElse(null);
    }

    @Override
    public synchronized void setServerArray(String[] serverArray) {
        this.getPropertyNode("ServerArray").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)serverArray))));
    }

    @Override
    public synchronized void setNamespaceArray(String[] namespaceArray) {
        this.getPropertyNode("NamespaceArray").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)namespaceArray))));
    }

    public synchronized void setServerStatus(ServerStatusType serverStatus) {
        this.getVariableComponent("ServerStatus").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)serverStatus))));
    }

    @Override
    public synchronized void setServiceLevel(UByte serviceLevel) {
        this.getPropertyNode("ServiceLevel").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)serviceLevel))));
    }

    @Override
    public synchronized void setAuditing(Boolean auditing) {
        this.getPropertyNode("Auditing").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)auditing))));
    }
}

