/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.objects;

import com.digitalpetri.opcua.sdk.core.model.objects.ServerConfigurationType;
import com.digitalpetri.opcua.sdk.core.model.objects.TrustListType;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.objects.BaseObjectNode;
import com.digitalpetri.opcua.sdk.server.util.UaObjectType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import java.util.Optional;

@UaObjectType(name="ServerConfigurationType")
public class ServerConfigurationNode
extends BaseObjectNode
implements ServerConfigurationType {
    public ServerConfigurationNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, UByte eventNotifier) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public String[] getSupportedCertificateFormats() {
        Optional<Object> supportedCertificateFormats = this.getProperty("SupportedCertificateFormats");
        return supportedCertificateFormats.orElse(null);
    }

    @Override
    public String[] getSupportedPrivateKeyFormats() {
        Optional<Object> supportedPrivateKeyFormats = this.getProperty("SupportedPrivateKeyFormats");
        return supportedPrivateKeyFormats.orElse(null);
    }

    @Override
    public UInteger getMaxTrustListSize() {
        Optional<Object> maxTrustListSize = this.getProperty("MaxTrustListSize");
        return maxTrustListSize.orElse(null);
    }

    @Override
    public Boolean getNoSupportForLocalCRLs() {
        Optional<Object> noSupportForLocalCRLs = this.getProperty("NoSupportForLocalCRLs");
        return noSupportForLocalCRLs.orElse(null);
    }

    @Override
    public Boolean getMulticastDnsEnabled() {
        Optional<Object> multicastDnsEnabled = this.getProperty("MulticastDnsEnabled");
        return multicastDnsEnabled.orElse(null);
    }

    @Override
    public TrustListType getTrustList() {
        Optional<ObjectNode> trustList = this.getObjectComponent("TrustList");
        return trustList.map(node -> (TrustListType)((Object)node)).orElse(null);
    }

    @Override
    public TrustListType getHttpsTrustList() {
        Optional<ObjectNode> httpsTrustList = this.getObjectComponent("HttpsTrustList");
        return httpsTrustList.map(node -> (TrustListType)((Object)node)).orElse(null);
    }

    @Override
    public synchronized void setSupportedCertificateFormats(String[] supportedCertificateFormats) {
        this.getPropertyNode("SupportedCertificateFormats").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)supportedCertificateFormats))));
    }

    @Override
    public synchronized void setSupportedPrivateKeyFormats(String[] supportedPrivateKeyFormats) {
        this.getPropertyNode("SupportedPrivateKeyFormats").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)supportedPrivateKeyFormats))));
    }

    @Override
    public synchronized void setMaxTrustListSize(UInteger maxTrustListSize) {
        this.getPropertyNode("MaxTrustListSize").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)maxTrustListSize))));
    }

    @Override
    public synchronized void setNoSupportForLocalCRLs(Boolean noSupportForLocalCRLs) {
        this.getPropertyNode("NoSupportForLocalCRLs").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)noSupportForLocalCRLs))));
    }

    @Override
    public synchronized void setMulticastDnsEnabled(Boolean multicastDnsEnabled) {
        this.getPropertyNode("MulticastDnsEnabled").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)multicastDnsEnabled))));
    }
}

