/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.methods;

import com.digitalpetri.opcua.sdk.server.OpcUaServer;
import com.digitalpetri.opcua.sdk.server.items.BaseMonitoredItem;
import com.digitalpetri.opcua.sdk.server.subscriptions.Subscription;
import com.digitalpetri.opcua.sdk.server.util.AnnotationBasedInvocationHandler;
import com.digitalpetri.opcua.sdk.server.util.UaInputArgument;
import com.digitalpetri.opcua.sdk.server.util.UaMethod;
import com.digitalpetri.opcua.sdk.server.util.UaOutputArgument;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.types.builtin.StatusCode;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.Unsigned;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class GetMonitoredItems {
    private final OpcUaServer server;

    public GetMonitoredItems(OpcUaServer server) {
        this.server = server;
    }

    @UaMethod
    public void invoke(AnnotationBasedInvocationHandler.InvocationContext context, @UaInputArgument(name="subscriptionId") UInteger subscriptionId, @UaOutputArgument(name="serverHandles") AnnotationBasedInvocationHandler.Out<UInteger[]> serverHandles, @UaOutputArgument(name="clientHandles") AnnotationBasedInvocationHandler.Out<UInteger[]> clientHandles) throws UaException {
        Subscription subscription = this.server.getSubscriptions().get(subscriptionId);
        if (subscription == null) {
            throw new UaException(new StatusCode(0x80280000L));
        }
        ArrayList serverHandleList = Lists.newArrayList();
        ArrayList clientHandleList = Lists.newArrayList();
        for (BaseMonitoredItem<?> item : subscription.getMonitoredItems().values()) {
            serverHandleList.add(item.getId());
            clientHandleList.add(Unsigned.uint((long)item.getClientHandle()));
        }
        serverHandles.set(serverHandleList.toArray(new UInteger[serverHandleList.size()]));
        clientHandles.set(clientHandleList.toArray(new UInteger[clientHandleList.size()]));
    }
}

