/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model;

import com.digitalpetri.opcua.sdk.core.AccessLevel;
import com.digitalpetri.opcua.sdk.core.Reference;
import com.digitalpetri.opcua.sdk.core.model.UaOptional;
import com.digitalpetri.opcua.sdk.core.nodes.Node;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectNode;
import com.digitalpetri.opcua.sdk.core.nodes.VariableNode;
import com.digitalpetri.opcua.sdk.core.nodes.VariableTypeNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.Property;
import com.digitalpetri.opcua.sdk.server.model.UaNode;
import com.digitalpetri.opcua.sdk.server.util.StreamUtil;
import com.digitalpetri.opcua.stack.core.Identifiers;
import com.digitalpetri.opcua.stack.core.types.builtin.ByteString;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DateTime;
import com.digitalpetri.opcua.stack.core.types.builtin.ExpandedNodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.StatusCode;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.Unsigned;
import com.digitalpetri.opcua.stack.core.types.enumerated.NodeClass;
import com.digitalpetri.opcua.stack.core.types.structured.EUInformation;
import com.digitalpetri.opcua.stack.core.types.structured.TimeZoneDataType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class UaVariableNode
extends UaNode
implements VariableNode {
    private static final DataValue INITIAL_VALUE = new DataValue(new StatusCode(1083310080L));
    private volatile DataValue value = INITIAL_VALUE;
    private volatile NodeId dataType = Identifiers.BaseDataType;
    private volatile Integer valueRank = -1;
    private volatile Optional<UInteger[]> arrayDimensions = Optional.empty();
    private volatile UByte accessLevel = Unsigned.ubyte((short)AccessLevel.getMask(AccessLevel.CurrentRead));
    private volatile UByte userAccessLevel = Unsigned.ubyte((short)AccessLevel.getMask(AccessLevel.CurrentRead));
    private volatile Optional<Double> minimumSamplingInterval = Optional.empty();
    private volatile boolean historizing = false;
    public static final Property<String> NodeVersion = new Property.BasicProperty<String>(new QualifiedName(0, "NodeVersion"), Identifiers.String, -1, String.class);
    public static final Property<TimeZoneDataType> LocalTime = new Property.BasicProperty<TimeZoneDataType>(new QualifiedName(0, "LocalTime"), Identifiers.TimeZoneDataType, -1, TimeZoneDataType.class);
    public static final Property<String> DataTypeVersion = new Property.BasicProperty<String>(new QualifiedName(0, "DataTypeVersion"), Identifiers.String, -1, String.class);
    public static final Property<ByteString> DictionaryFragment = new Property.BasicProperty<ByteString>(new QualifiedName(0, "DictionaryFragment"), Identifiers.ByteString, -1, ByteString.class);
    public static final Property<Boolean> AllowNulls = new Property.BasicProperty<Boolean>(new QualifiedName(0, "AllowNulls"), Identifiers.Boolean, -1, Boolean.class);
    public static final Property<LocalizedText> ValueAsText = new Property.BasicProperty<LocalizedText>(new QualifiedName(0, "ValueAsText"), Identifiers.LocalizedText, -1, LocalizedText.class);
    public static final Property<UInteger> MaxStringLength = new Property.BasicProperty<UInteger>(new QualifiedName(0, "MaxStringLength"), Identifiers.UInt32, -1, UInteger.class);
    public static final Property<UInteger> MaxArrayLength = new Property.BasicProperty<UInteger>(new QualifiedName(0, "MaxArrayLength"), Identifiers.UInt32, -1, UInteger.class);
    public static final Property<EUInformation> EngineeringUnits = new Property.BasicProperty<EUInformation>(new QualifiedName(0, "EngineeringUnits"), Identifiers.EUInformation, -1, EUInformation.class);

    public UaVariableNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName) {
        super(namespace, nodeId, NodeClass.Variable, browseName, displayName);
    }

    public UaVariableNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, DataValue value, NodeId dataType, Integer valueRank, Optional<UInteger[]> arrayDimensions, UByte accessLevel, UByte userAccessLevel, Optional<Double> minimumSamplingInterval, boolean historizing) {
        super(namespace, nodeId, NodeClass.Variable, browseName, displayName, description, writeMask, userWriteMask);
        this.value = value;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.accessLevel = accessLevel;
        this.userAccessLevel = userAccessLevel;
        this.minimumSamplingInterval = minimumSamplingInterval;
        this.historizing = historizing;
    }

    @Override
    public DataValue getValue() {
        return this.value;
    }

    @Override
    public NodeId getDataType() {
        return this.dataType;
    }

    @Override
    public Integer getValueRank() {
        return this.valueRank;
    }

    @Override
    public Optional<UInteger[]> getArrayDimensions() {
        return this.arrayDimensions;
    }

    @Override
    public UByte getAccessLevel() {
        return this.accessLevel;
    }

    @Override
    public UByte getUserAccessLevel() {
        return this.userAccessLevel;
    }

    @Override
    public Optional<Double> getMinimumSamplingInterval() {
        return this.minimumSamplingInterval;
    }

    @Override
    public Boolean getHistorizing() {
        return this.historizing;
    }

    @Override
    public synchronized void setValue(DataValue value) {
        this.value = value;
        this.fireAttributeChanged(13, value);
    }

    @Override
    public synchronized void setDataType(NodeId dataType) {
        this.dataType = dataType;
        this.fireAttributeChanged(14, dataType);
    }

    @Override
    public synchronized void setValueRank(Integer valueRank) {
        this.valueRank = valueRank;
        this.fireAttributeChanged(15, valueRank);
    }

    @Override
    public synchronized void setArrayDimensions(Optional<UInteger[]> arrayDimensions) {
        this.arrayDimensions = arrayDimensions;
        arrayDimensions.ifPresent(v -> this.fireAttributeChanged(16, v));
    }

    @Override
    public synchronized void setAccessLevel(UByte accessLevel) {
        this.accessLevel = accessLevel;
        this.fireAttributeChanged(17, accessLevel);
    }

    @Override
    public synchronized void setUserAccessLevel(UByte userAccessLevel) {
        this.userAccessLevel = userAccessLevel;
        this.fireAttributeChanged(18, userAccessLevel);
    }

    @Override
    public void setMinimumSamplingInterval(Optional<Double> minimumSamplingInterval) {
        this.minimumSamplingInterval = minimumSamplingInterval;
        minimumSamplingInterval.ifPresent(v -> this.fireAttributeChanged(19, v));
    }

    @Override
    public void setHistorizing(boolean historizing) {
        this.historizing = historizing;
        this.fireAttributeChanged(20, historizing);
    }

    public Optional<ObjectNode> getModellingRuleNode() {
        Node node = this.getReferences().stream().filter(Reference.HAS_MODELLING_RULE_PREDICATE).findFirst().flatMap(r -> this.getNode(r.getTargetNodeId())).orElse(null);
        ObjectNode objectNode = node instanceof ObjectNode ? (ObjectNode)node : null;
        return Optional.ofNullable(objectNode);
    }

    public List<Node> getPropertyNodes() {
        return this.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public List<Node> getComponentNodes() {
        return this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public VariableTypeNode getTypeDefinitionNode() {
        Node node = this.getReferences().stream().filter(Reference.HAS_TYPE_DEFINITION_PREDICATE).findFirst().flatMap(r -> this.getNode(r.getTargetNodeId())).orElse(null);
        return node instanceof VariableTypeNode ? (VariableTypeNode)node : null;
    }

    @UaOptional(value="NodeVersion")
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    @UaOptional(value="LocalTime")
    public TimeZoneDataType getLocalTime() {
        return this.getProperty(LocalTime).orElse(null);
    }

    @UaOptional(value="DataTypeVersion")
    public String getDataTypeVersion() {
        return this.getProperty(DataTypeVersion).orElse(null);
    }

    @UaOptional(value="DictionaryFragment")
    public ByteString getDictionaryFragment() {
        return this.getProperty(DictionaryFragment).orElse(null);
    }

    @UaOptional(value="AllowNulls")
    public Boolean getAllowNulls() {
        return this.getProperty(AllowNulls).orElse(null);
    }

    @UaOptional(value="MaxStringLength")
    public UInteger getMaxStringLength() {
        return this.getProperty(MaxStringLength).orElse(null);
    }

    @UaOptional(value="MaxArrayLength")
    public UInteger getMaxArrayLength() {
        return this.getProperty(MaxArrayLength).orElse(null);
    }

    @UaOptional(value="EngineeringUnits")
    public EUInformation getEngineeringUnits() {
        return this.getProperty(EngineeringUnits).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }

    public void setLocalTime(TimeZoneDataType localTime) {
        this.setProperty(LocalTime, localTime);
    }

    public void setDataTypeVersion(String dataTypeVersion) {
        this.setProperty(DataTypeVersion, dataTypeVersion);
    }

    public void setDictionaryFragment(ByteString dictionaryFragment) {
        this.setProperty(DictionaryFragment, dictionaryFragment);
    }

    public void setAllowNulls(Boolean allowNulls) {
        this.setProperty(AllowNulls, allowNulls);
    }

    public void setMaxStringLength(UInteger maxStringLength) {
        this.setProperty(MaxStringLength, maxStringLength);
    }

    public void setMaxArrayLength(UInteger maxArrayLength) {
        this.setProperty(MaxArrayLength, maxArrayLength);
    }

    public void setEngineeringUnits(EUInformation engineeringUnits) {
        this.setProperty(EngineeringUnits, engineeringUnits);
    }

    public static UaVariableNodeBuilder builder(UaNamespace nodeManager) {
        return new UaVariableNodeBuilder(nodeManager);
    }

    public static class UaVariableNodeBuilder
    implements Supplier<UaVariableNode> {
        private final List<Reference> references = Lists.newArrayList();
        private NodeId nodeId;
        private QualifiedName browseName;
        private LocalizedText displayName;
        private Optional<LocalizedText> description = Optional.empty();
        private Optional<UInteger> writeMask = Optional.of(Unsigned.uint((int)0));
        private Optional<UInteger> userWriteMask = Optional.of(Unsigned.uint((int)0));
        private DataValue value = new DataValue(Variant.NULL_VALUE, new StatusCode(1083310080L), DateTime.now(), DateTime.now());
        private NodeId dataType;
        private int valueRank = -1;
        private Optional<UInteger[]> arrayDimensions = Optional.empty();
        private UByte accessLevel = Unsigned.ubyte((short)AccessLevel.getMask(AccessLevel.CurrentRead));
        private UByte userAccessLevel = Unsigned.ubyte((short)AccessLevel.getMask(AccessLevel.CurrentRead));
        private Optional<Double> minimumSamplingInterval = Optional.empty();
        private boolean historizing = false;
        private final UaNamespace nodeManager;

        public UaVariableNodeBuilder(UaNamespace nodeManager) {
            this.nodeManager = nodeManager;
        }

        @Override
        public UaVariableNode get() {
            return this.build();
        }

        public UaVariableNode build() {
            Preconditions.checkNotNull((Object)this.nodeId, (Object)"NodeId cannot be null");
            Preconditions.checkNotNull((Object)this.browseName, (Object)"BrowseName cannot be null");
            Preconditions.checkNotNull((Object)this.displayName, (Object)"DisplayName cannot be null");
            Preconditions.checkNotNull((Object)this.dataType, (Object)"DataType cannot be null");
            long hasTypeDefinitionCount = this.references.stream().filter(r -> Identifiers.HasTypeDefinition.equals((Object)r.getReferenceTypeId())).count();
            if (hasTypeDefinitionCount == 0L) {
                this.setTypeDefinition(Identifiers.BaseDataVariableType);
            } else {
                Preconditions.checkState((hasTypeDefinitionCount == 1L ? 1 : 0) != 0, (Object)"Variable Node must have exactly one HasTypeDefinition reference.");
            }
            UaVariableNode node = new UaVariableNode(this.nodeManager, this.nodeId, this.browseName, this.displayName, this.description, this.writeMask, this.userWriteMask, this.value, this.dataType, this.valueRank, this.arrayDimensions, this.accessLevel, this.userAccessLevel, this.minimumSamplingInterval, this.historizing);
            node.addReferences(this.references);
            return node;
        }

        public UaVariableNodeBuilder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public UaVariableNodeBuilder setBrowseName(QualifiedName browseName) {
            this.browseName = browseName;
            return this;
        }

        public UaVariableNodeBuilder setDisplayName(LocalizedText displayName) {
            this.displayName = displayName;
            return this;
        }

        public UaVariableNodeBuilder setDescription(LocalizedText description) {
            this.description = Optional.of(description);
            return this;
        }

        public UaVariableNodeBuilder setWriteMask(UInteger writeMask) {
            this.writeMask = Optional.of(writeMask);
            return this;
        }

        public UaVariableNodeBuilder setUserWriteMask(UInteger userWriteMask) {
            this.userWriteMask = Optional.of(userWriteMask);
            return this;
        }

        public UaVariableNodeBuilder setValue(DataValue value) {
            this.value = value;
            return this;
        }

        public UaVariableNodeBuilder setDataType(NodeId dataType) {
            this.dataType = dataType;
            return this;
        }

        public UaVariableNodeBuilder setValueRank(int valueRank) {
            this.valueRank = valueRank;
            return this;
        }

        public UaVariableNodeBuilder setArrayDimensions(UInteger[] arrayDimensions) {
            this.arrayDimensions = Optional.of(arrayDimensions);
            return this;
        }

        public UaVariableNodeBuilder setAccessLevel(UByte accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public UaVariableNodeBuilder setUserAccessLevel(UByte userAccessLevel) {
            this.userAccessLevel = userAccessLevel;
            return this;
        }

        public UaVariableNodeBuilder setMinimumSamplingInterval(Double minimumSamplingInterval) {
            this.minimumSamplingInterval = Optional.of(minimumSamplingInterval);
            return this;
        }

        public UaVariableNodeBuilder setHistorizing(boolean historizing) {
            this.historizing = historizing;
            return this;
        }

        public UaVariableNodeBuilder addReference(Reference reference) {
            this.references.add(reference);
            return this;
        }

        public UaVariableNodeBuilder setTypeDefinition(NodeId typeDefinition) {
            Objects.requireNonNull(this.nodeId, "NodeId cannot be null");
            this.references.add(new Reference(this.nodeId, Identifiers.HasTypeDefinition, new ExpandedNodeId(typeDefinition), NodeClass.ObjectType, true));
            return this;
        }
    }
}

