/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model;

import com.digitalpetri.opcua.sdk.core.model.UaOptional;
import com.digitalpetri.opcua.sdk.core.nodes.ReferenceTypeNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.Property;
import com.digitalpetri.opcua.sdk.server.model.UaNode;
import com.digitalpetri.opcua.stack.core.Identifiers;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.enumerated.NodeClass;
import java.util.Optional;

public class UaReferenceTypeNode
extends UaNode
implements ReferenceTypeNode {
    private volatile boolean isAbstract;
    private volatile boolean symmetric;
    private volatile Optional<LocalizedText> inverseName;
    public static final Property<String> NodeVersion = new Property.BasicProperty<String>(new QualifiedName(0, "NodeVersion"), Identifiers.String, -1, String.class);

    public UaReferenceTypeNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, boolean isAbstract, boolean symmetric, Optional<LocalizedText> inverseName) {
        super(namespace, nodeId, NodeClass.ReferenceType, browseName, displayName, description, writeMask, userWriteMask);
        this.isAbstract = isAbstract;
        this.symmetric = symmetric;
        this.inverseName = inverseName;
    }

    @Override
    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    @Override
    public Boolean getSymmetric() {
        return this.symmetric;
    }

    @Override
    public Optional<LocalizedText> getInverseName() {
        return this.inverseName;
    }

    @Override
    public synchronized void setIsAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        this.fireAttributeChanged(8, isAbstract);
    }

    @Override
    public synchronized void setSymmetric(boolean symmetric) {
        this.symmetric = symmetric;
        this.fireAttributeChanged(9, symmetric);
    }

    @Override
    public synchronized void setInverseName(Optional<LocalizedText> inverseName) {
        this.inverseName = inverseName;
        inverseName.ifPresent(v -> this.fireAttributeChanged(10, v));
    }

    @UaOptional(value="NodeVersion")
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }
}

