/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.items;

import com.digitalpetri.opcua.sdk.core.events.BaseEventType;
import com.digitalpetri.opcua.sdk.server.api.EventItem;
import com.digitalpetri.opcua.sdk.server.items.BaseMonitoredItem;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.types.builtin.ExtensionObject;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.Unsigned;
import com.digitalpetri.opcua.stack.core.types.enumerated.MonitoringMode;
import com.digitalpetri.opcua.stack.core.types.enumerated.TimestampsToReturn;
import com.digitalpetri.opcua.stack.core.types.structured.EventFieldList;
import com.digitalpetri.opcua.stack.core.types.structured.EventFilter;
import com.digitalpetri.opcua.stack.core.types.structured.ReadValueId;

public class MonitoredEventItem
extends BaseMonitoredItem<Variant[]>
implements EventItem {
    private volatile EventFilter filter;

    public MonitoredEventItem(UInteger id, UInteger subscriptionId, ReadValueId readValueId, MonitoringMode monitoringMode, TimestampsToReturn timestamps, UInteger clientHandle, double samplingInterval, UInteger queueSize, boolean discardOldest, ExtensionObject filter) throws UaException {
        super(id, subscriptionId, readValueId, monitoringMode, timestamps, clientHandle, samplingInterval, queueSize, discardOldest);
        this.installFilter(filter);
    }

    @Override
    public void setEvent(BaseEventType event) {
        Variant[] variants = new Variant[]{new Variant((Object)event.getEventId()), new Variant((Object)event.getEventType()), new Variant((Object)event.getSourceNode()), new Variant((Object)event.getSourceNode()), new Variant((Object)event.getTime())};
        this.enqueue(variants);
    }

    @Override
    protected void enqueue(Variant[] value) {
        if (this.queueSize < this.queue.maxSize()) {
            this.queue.add(value);
        } else {
            if (this.getQueueSize() > 1) {
                // empty if block
            }
            if (this.discardOldest) {
                this.queue.add(value);
            } else {
                this.queue.set(this.queue.maxSize() - 1, value);
            }
        }
    }

    @Override
    public ExtensionObject getFilterResult() {
        return null;
    }

    @Override
    protected void installFilter(ExtensionObject filterXo) throws UaException {
    }

    protected EventFieldList wrapQueueValue(Variant[] value) {
        return new EventFieldList(Unsigned.uint((long)this.getClientHandle()), value);
    }

    @Override
    public boolean isSamplingEnabled() {
        return this.getMonitoringMode() != MonitoringMode.Disabled;
    }
}

