/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.events;

import com.digitalpetri.opcua.sdk.core.events.BaseEventType;
import com.digitalpetri.opcua.stack.core.types.builtin.ByteString;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DateTime;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UShort;
import com.digitalpetri.opcua.stack.core.types.structured.TimeZoneDataType;
import java.util.Optional;

public class BaseEvent
implements BaseEventType {
    private final ByteString eventId;
    private final NodeId eventType;
    private final NodeId sourceNode;
    private final String sourceName;
    private final DateTime time;
    private final DateTime receiveTime;
    private final Optional<TimeZoneDataType> localTime;
    private final LocalizedText message;
    private final UShort severity;

    public BaseEvent(ByteString eventId, NodeId eventType, NodeId sourceNode, String sourceName, DateTime time, DateTime receiveTime, Optional<TimeZoneDataType> localTime, LocalizedText message, UShort severity) {
        this.eventId = eventId;
        this.eventType = eventType;
        this.sourceNode = sourceNode;
        this.sourceName = sourceName;
        this.time = time;
        this.receiveTime = receiveTime;
        this.localTime = localTime;
        this.message = message;
        this.severity = severity;
    }

    @Override
    public ByteString getEventId() {
        return this.eventId;
    }

    @Override
    public NodeId getEventType() {
        return this.eventType;
    }

    @Override
    public NodeId getSourceNode() {
        return this.sourceNode;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public DateTime getTime() {
        return this.time;
    }

    @Override
    public DateTime getReceiveTime() {
        return this.receiveTime;
    }

    @Override
    public Optional<TimeZoneDataType> getLocalTime() {
        return this.localTime;
    }

    @Override
    public LocalizedText getMessage() {
        return this.message;
    }

    @Override
    public UShort getSeverity() {
        return this.severity;
    }

    @Override
    public DataValue getProperty(QualifiedName propertyName) {
        return null;
    }

    public static class BaseEventBuilder {
        protected ByteString eventId;
        protected NodeId eventType;
        protected NodeId sourceNode;
        protected String sourceName;
        protected DateTime time;
        protected DateTime receiveTime;
        protected Optional<TimeZoneDataType> localTime = Optional.empty();
        protected LocalizedText message;
        protected UShort severity;

        public BaseEventBuilder setEventId(ByteString eventId) {
            this.eventId = eventId;
            return this;
        }

        public BaseEventBuilder setEventType(NodeId eventType) {
            this.eventType = eventType;
            return this;
        }

        public BaseEventBuilder setSourceNode(NodeId sourceNode) {
            this.sourceNode = sourceNode;
            return this;
        }

        public BaseEventBuilder setSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public BaseEventBuilder setTime(DateTime time) {
            this.time = time;
            return this;
        }

        public BaseEventBuilder setReceiveTime(DateTime receiveTime) {
            this.receiveTime = receiveTime;
            return this;
        }

        public BaseEventBuilder setLocalTime(Optional<TimeZoneDataType> localTime) {
            this.localTime = localTime;
            return this;
        }

        public BaseEventBuilder setMessage(LocalizedText message) {
            this.message = message;
            return this;
        }

        public BaseEventBuilder setSeverity(UShort severity) {
            this.severity = severity;
            return this;
        }

        public BaseEvent build() {
            return new BaseEvent(this.eventId, this.eventType, this.sourceNode, this.sourceName, this.time, this.receiveTime, this.localTime, this.message, this.severity);
        }
    }
}

