/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.subscriptions;

import com.digitalpetri.opcua.sdk.server.subscriptions.Subscription;
import com.digitalpetri.opcua.stack.core.application.services.ServiceRequest;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.structured.PublishRequest;
import com.digitalpetri.opcua.stack.core.types.structured.PublishResponse;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishQueue {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LinkedList<ServiceRequest<PublishRequest, PublishResponse>> serviceQueue = new LinkedList();
    private final LinkedHashMap<UInteger, WaitingSubscription> waitList = new LinkedHashMap();

    public synchronized void addRequest(ServiceRequest<PublishRequest, PublishResponse> service) {
        ArrayList waitingSubscriptions = Lists.newArrayList(this.waitList.values());
        if (waitingSubscriptions.isEmpty()) {
            this.serviceQueue.add(service);
            this.logger.debug("Queued PublishRequest, size={}", (Object)this.serviceQueue.size());
        } else {
            WaitingSubscription subscription = null;
            int maxPriority = 0;
            long minWaitingSince = Long.MAX_VALUE;
            for (WaitingSubscription waiting : waitingSubscriptions) {
                int priority = waiting.getSubscription().getPriority();
                long waitingSince = waiting.getWaitingSince().getTime();
                if (priority > maxPriority) {
                    maxPriority = priority;
                    minWaitingSince = Long.MAX_VALUE;
                }
                if (priority < maxPriority || waitingSince >= minWaitingSince) continue;
                minWaitingSince = waitingSince;
                subscription = waiting;
            }
            if (subscription != null) {
                this.waitList.remove(subscription.subscription.getId());
                this.logger.debug("Delivering PublishRequest to Subscription [id={}]", (Object)subscription.getSubscription().getId());
                subscription.subscription.onPublish(service);
            } else {
                this.serviceQueue.add(service);
            }
        }
    }

    public synchronized void addSubscription(Subscription subscription) {
        if (this.waitList.isEmpty() && !this.serviceQueue.isEmpty()) {
            subscription.onPublish(this.serviceQueue.poll());
        } else {
            this.waitList.putIfAbsent(subscription.getId(), new WaitingSubscription(subscription));
        }
    }

    public synchronized boolean isEmpty() {
        return this.serviceQueue.isEmpty();
    }

    public synchronized boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public synchronized ServiceRequest<PublishRequest, PublishResponse> poll() {
        return this.serviceQueue.poll();
    }

    public static class WaitingSubscription {
        private final Date waitingSince = new Date();
        private final Subscription subscription;

        public WaitingSubscription(Subscription subscription) {
            this.subscription = subscription;
        }

        public Subscription getSubscription() {
            return this.subscription;
        }

        public Date getWaitingSince() {
            return this.waitingSince;
        }
    }
}

