/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.services;

import com.digitalpetri.opcua.sdk.server.OpcUaServer;
import com.digitalpetri.opcua.sdk.server.Session;
import com.digitalpetri.opcua.sdk.server.items.MonitoredDataItem;
import com.digitalpetri.opcua.sdk.server.services.ServiceAttributes;
import com.digitalpetri.opcua.sdk.server.subscriptions.Subscription;
import com.digitalpetri.opcua.sdk.server.subscriptions.SubscriptionManager;
import com.digitalpetri.opcua.stack.core.application.services.ServiceRequest;
import com.digitalpetri.opcua.stack.core.application.services.SubscriptionServiceSet;
import com.digitalpetri.opcua.stack.core.serialization.UaResponseMessage;
import com.digitalpetri.opcua.stack.core.types.builtin.DiagnosticInfo;
import com.digitalpetri.opcua.stack.core.types.builtin.StatusCode;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.structured.CreateSubscriptionRequest;
import com.digitalpetri.opcua.stack.core.types.structured.CreateSubscriptionResponse;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteSubscriptionsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.DeleteSubscriptionsResponse;
import com.digitalpetri.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import com.digitalpetri.opcua.stack.core.types.structured.ModifySubscriptionResponse;
import com.digitalpetri.opcua.stack.core.types.structured.PublishRequest;
import com.digitalpetri.opcua.stack.core.types.structured.PublishResponse;
import com.digitalpetri.opcua.stack.core.types.structured.RepublishRequest;
import com.digitalpetri.opcua.stack.core.types.structured.RepublishResponse;
import com.digitalpetri.opcua.stack.core.types.structured.SetPublishingModeRequest;
import com.digitalpetri.opcua.stack.core.types.structured.SetPublishingModeResponse;
import com.digitalpetri.opcua.stack.core.types.structured.TransferResult;
import com.digitalpetri.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import com.digitalpetri.opcua.stack.core.types.structured.TransferSubscriptionsResponse;
import com.digitalpetri.opcua.stack.core.util.ConversionUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SubscriptionServices
implements SubscriptionServiceSet {
    private final SubscriptionManager subscriptionManager;

    public SubscriptionServices(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    public void onCreateSubscription(ServiceRequest<CreateSubscriptionRequest, CreateSubscriptionResponse> service) {
        this.subscriptionManager.createSubscription(service);
    }

    public void onModifySubscription(ServiceRequest<ModifySubscriptionRequest, ModifySubscriptionResponse> service) {
        this.subscriptionManager.modifySubscription(service);
    }

    public void onDeleteSubscriptions(ServiceRequest<DeleteSubscriptionsRequest, DeleteSubscriptionsResponse> service) {
        this.subscriptionManager.deleteSubscription(service);
    }

    public void onSetPublishingMode(ServiceRequest<SetPublishingModeRequest, SetPublishingModeResponse> service) {
        this.subscriptionManager.setPublishingMode(service);
    }

    public void onPublish(ServiceRequest<PublishRequest, PublishResponse> service) {
        this.subscriptionManager.publish(service);
    }

    public void onRepublish(ServiceRequest<RepublishRequest, RepublishResponse> service) {
        this.subscriptionManager.republish(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTransferSubscriptions(ServiceRequest<TransferSubscriptionsRequest, TransferSubscriptionsResponse> service) {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        TransferSubscriptionsRequest request = (TransferSubscriptionsRequest)service.getRequest();
        UInteger[] subscriptionIds = request.getSubscriptionIds();
        if (subscriptionIds.length == 0) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        ArrayList results = Lists.newArrayList();
        for (UInteger subscriptionId : subscriptionIds) {
            UInteger[] availableSequenceNumbers;
            Subscription subscription = server.getSubscriptions().get(subscriptionId);
            if (subscription == null) {
                results.add(new TransferResult(new StatusCode(0x80280000L), new UInteger[0]));
                continue;
            }
            Session otherSession = subscription.getSession();
            if (!this.sessionsHaveSameUser(session, otherSession)) {
                results.add(new TransferResult(new StatusCode(2149515264L), new UInteger[0]));
                continue;
            }
            Subscription subscription2 = subscription;
            synchronized (subscription2) {
                otherSession.getSubscriptionManager().sendStatusChangeNotification(subscription);
                otherSession.getSubscriptionManager().removeSubscription(subscriptionId);
                subscription.setSubscriptionManager(session.getSubscriptionManager());
                this.subscriptionManager.addSubscription(subscription);
                availableSequenceNumbers = subscription.getAvailableSequenceNumbers();
                if (request.getSendInitialValues().booleanValue()) {
                    subscription.getMonitoredItems().values().stream().filter(item -> item instanceof MonitoredDataItem).map(item -> (MonitoredDataItem)item).forEach(MonitoredDataItem::clearLastValue);
                }
            }
            results.add(new TransferResult(StatusCode.GOOD, availableSequenceNumbers));
        }
        service.setResponse((UaResponseMessage)new TransferSubscriptionsResponse(service.createResponseHeader(), (TransferResult[])ConversionUtil.a((List)results, TransferResult.class), new DiagnosticInfo[0]));
    }

    private boolean sessionsHaveSameUser(Session s1, Session s2) {
        Object identity1 = s1.getIdentityObject();
        Object identity2 = s2.getIdentityObject();
        return Objects.equals(identity1, identity2);
    }
}

