/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.namespaces;

import com.digitalpetri.opcua.sdk.core.Reference;
import com.digitalpetri.opcua.sdk.server.OpcUaServer;
import com.digitalpetri.opcua.sdk.server.api.AttributeManager;
import com.digitalpetri.opcua.sdk.server.api.DataItem;
import com.digitalpetri.opcua.sdk.server.api.MonitoredItem;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.UaNode;
import com.digitalpetri.opcua.sdk.server.model.UaObjectNode;
import com.digitalpetri.opcua.sdk.server.model.UaVariableNode;
import com.digitalpetri.opcua.sdk.server.util.SubscriptionModel;
import com.digitalpetri.opcua.stack.core.Identifiers;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.ExpandedNodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.StatusCode;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UShort;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.Unsigned;
import com.digitalpetri.opcua.stack.core.types.enumerated.TimestampsToReturn;
import com.digitalpetri.opcua.stack.core.types.structured.ReadValueId;
import com.digitalpetri.opcua.stack.core.types.structured.WriteValue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class VendorNamespace
implements UaNamespace {
    public static final UShort NAMESPACE_INDEX = Unsigned.ushort((int)1);
    private final Map<NodeId, UaNode> nodes = Maps.newConcurrentMap();
    private final SubscriptionModel subscriptionModel;
    private final OpcUaServer server;
    private final String namespaceUri;

    public VendorNamespace(OpcUaServer server, String namespaceUri) {
        this.server = server;
        this.namespaceUri = namespaceUri;
        this.subscriptionModel = new SubscriptionModel(server, this);
        this.addVendorServerInfoNodes();
    }

    @Override
    public UShort getNamespaceIndex() {
        return NAMESPACE_INDEX;
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public void addNode(UaNode node) {
        this.nodes.put(node.getNodeId(), node);
    }

    @Override
    public Optional<UaNode> getNode(NodeId nodeId) {
        return Optional.ofNullable(this.nodes.get(nodeId));
    }

    @Override
    public Optional<UaNode> getNode(ExpandedNodeId nodeId) {
        return nodeId.local().flatMap(this::getNode);
    }

    @Override
    public Optional<UaNode> removeNode(NodeId nodeId) {
        return Optional.ofNullable(this.nodes.remove(nodeId));
    }

    @Override
    public CompletableFuture<List<Reference>> getReferences(NodeId nodeId) {
        UaNode node = this.nodes.get(nodeId);
        if (node != null) {
            return CompletableFuture.completedFuture(node.getReferences());
        }
        CompletableFuture<List<Reference>> f = new CompletableFuture<List<Reference>>();
        f.completeExceptionally(new UaException(2150891520L));
        return f;
    }

    @Override
    public void read(AttributeManager.ReadContext context, Double maxAge, TimestampsToReturn timestamps, List<ReadValueId> readValueIds) {
        ArrayList results = Lists.newArrayListWithCapacity((int)readValueIds.size());
        for (ReadValueId id : readValueIds) {
            UaNode node = this.nodes.get(id.getNodeId());
            DataValue value = node != null ? node.readAttribute(id.getAttributeId().intValue()) : new DataValue(2150891520L);
            results.add(value);
        }
        context.complete(results);
    }

    @Override
    public void write(AttributeManager.WriteContext context, List<WriteValue> writeValues) {
        List results = writeValues.stream().map(value -> {
            if (this.nodes.containsKey(value.getNodeId())) {
                return new StatusCode(2151350272L);
            }
            return new StatusCode(2150891520L);
        }).collect(Collectors.toList());
        context.complete(results);
    }

    @Override
    public void onDataItemsCreated(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsCreated(dataItems);
    }

    @Override
    public void onDataItemsModified(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsModified(dataItems);
    }

    @Override
    public void onDataItemsDeleted(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsDeleted(dataItems);
    }

    @Override
    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
    }

    private void addVendorServerInfoNodes() {
        this.server.getUaNamespace().getNode(Identifiers.Server_VendorServerInfo).ifPresent(node -> {
            UaObjectNode vendorServerInfo = (UaObjectNode)node;
            final OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
            UaVariableNode processCpuLoad = new UaVariableNode(this, new NodeId(1, "VendorServerInfo/ProcessCpuLoad"), new QualifiedName(1, "ProcessCpuLoad"), LocalizedText.english((String)"ProcessCpuLoad")){

                @Override
                public DataValue getValue() {
                    return new DataValue(new Variant((Object)osBean.getProcessCpuLoad()));
                }
            };
            processCpuLoad.setDataType(Identifiers.Double);
            UaVariableNode systemCpuLoad = new UaVariableNode(this, new NodeId(1, "VendorServerInfo/SystemCpuLoad"), new QualifiedName(1, "SystemCpuLoad"), LocalizedText.english((String)"SystemCpuLoad")){

                @Override
                public DataValue getValue() {
                    return new DataValue(new Variant((Object)osBean.getSystemCpuLoad()));
                }
            };
            systemCpuLoad.setDataType(Identifiers.Double);
            UaVariableNode usedMemory = new UaVariableNode(this, new NodeId(1, "VendorServerInfo/UsedMemory"), new QualifiedName(1, "UsedMemory"), LocalizedText.english((String)"UsedMemory")){

                @Override
                public DataValue getValue() {
                    return new DataValue(new Variant((Object)memoryBean.getHeapMemoryUsage().getUsed()));
                }
            };
            usedMemory.setDataType(Identifiers.Int64);
            UaVariableNode maxMemory = new UaVariableNode(this, new NodeId(1, "VendorServerInfo/MaxMemory"), new QualifiedName(1, "MaxMemory"), LocalizedText.english((String)"MaxMemory")){

                @Override
                public DataValue getValue() {
                    return new DataValue(new Variant((Object)memoryBean.getHeapMemoryUsage().getMax()));
                }
            };
            maxMemory.setDataType(Identifiers.Int64);
            UaVariableNode osName = new UaVariableNode(this, new NodeId(1, "VendorServerInfo/OsName"), new QualifiedName(1, "OsName"), LocalizedText.english((String)"OsName")){

                @Override
                public DataValue getValue() {
                    return new DataValue(new Variant((Object)osBean.getName()));
                }
            };
            osName.setDataType(Identifiers.String);
            UaVariableNode osArch = new UaVariableNode(this, new NodeId(1, "VendorServerInfo/OsArch"), new QualifiedName(1, "OsArch"), LocalizedText.english((String)"OsArch")){

                @Override
                public DataValue getValue() {
                    return new DataValue(new Variant((Object)osBean.getArch()));
                }
            };
            osArch.setDataType(Identifiers.String);
            UaVariableNode osVersion = new UaVariableNode(this, new NodeId(1, "VendorServerInfo/OsVersion"), new QualifiedName(1, "OsVersion"), LocalizedText.english((String)"OsVersion")){

                @Override
                public DataValue getValue() {
                    return new DataValue(new Variant((Object)osBean.getVersion()));
                }
            };
            osVersion.setDataType(Identifiers.String);
            vendorServerInfo.addComponent(processCpuLoad);
            vendorServerInfo.addComponent(systemCpuLoad);
            vendorServerInfo.addComponent(usedMemory);
            vendorServerInfo.addComponent(maxMemory);
            vendorServerInfo.addComponent(osName);
            vendorServerInfo.addComponent(osArch);
            vendorServerInfo.addComponent(osVersion);
            if (osBean instanceof UnixOperatingSystemMXBean) {
                final UnixOperatingSystemMXBean unixBean = (UnixOperatingSystemMXBean)osBean;
                UaVariableNode openFileDescriptors = new UaVariableNode(this, new NodeId(1, "VendorServerInfo/OpenFileDescriptors"), new QualifiedName(1, "OpenFileDescriptors"), LocalizedText.english((String)"OpenFileDescriptors")){

                    @Override
                    public DataValue getValue() {
                        return new DataValue(new Variant((Object)unixBean.getOpenFileDescriptorCount()));
                    }
                };
                openFileDescriptors.setDataType(Identifiers.Int64);
                UaVariableNode maxFileDescriptors = new UaVariableNode(this, new NodeId(1, "VendorServerInfo/MaxFileDescriptors"), new QualifiedName(1, "MaxFileDescriptors"), LocalizedText.english((String)"MaxFileDescriptors")){

                    @Override
                    public DataValue getValue() {
                        return new DataValue(new Variant((Object)unixBean.getMaxFileDescriptorCount()));
                    }
                };
                maxFileDescriptors.setDataType(Identifiers.Int64);
                vendorServerInfo.addComponent(openFileDescriptors);
                vendorServerInfo.addComponent(maxFileDescriptors);
            }
        });
    }
}

