/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.namespaces;

import com.digitalpetri.opcua.sdk.core.Reference;
import com.digitalpetri.opcua.sdk.core.model.objects.OperationLimitsType;
import com.digitalpetri.opcua.sdk.core.model.objects.ServerCapabilitiesType;
import com.digitalpetri.opcua.sdk.core.model.variables.ServerStatusType;
import com.digitalpetri.opcua.sdk.server.OpcUaServer;
import com.digitalpetri.opcua.sdk.server.api.AttributeManager;
import com.digitalpetri.opcua.sdk.server.api.DataItem;
import com.digitalpetri.opcua.sdk.server.api.EventItem;
import com.digitalpetri.opcua.sdk.server.api.MethodInvocationHandler;
import com.digitalpetri.opcua.sdk.server.api.MonitoredItem;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.api.config.OpcUaServerConfigLimits;
import com.digitalpetri.opcua.sdk.server.model.DerivedVariableNode;
import com.digitalpetri.opcua.sdk.server.model.UaMethodNode;
import com.digitalpetri.opcua.sdk.server.model.UaNode;
import com.digitalpetri.opcua.sdk.server.model.UaObjectNode;
import com.digitalpetri.opcua.sdk.server.model.UaVariableNode;
import com.digitalpetri.opcua.sdk.server.model.methods.GetMonitoredItems;
import com.digitalpetri.opcua.sdk.server.model.objects.ServerNode;
import com.digitalpetri.opcua.sdk.server.namespaces.loader.UaNodeLoader;
import com.digitalpetri.opcua.sdk.server.util.AnnotationBasedInvocationHandler;
import com.digitalpetri.opcua.sdk.server.util.SubscriptionModel;
import com.digitalpetri.opcua.stack.core.Identifiers;
import com.digitalpetri.opcua.stack.core.UaException;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.DateTime;
import com.digitalpetri.opcua.stack.core.types.builtin.ExpandedNodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.StatusCode;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UShort;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.Unsigned;
import com.digitalpetri.opcua.stack.core.types.enumerated.NodeClass;
import com.digitalpetri.opcua.stack.core.types.enumerated.RedundancySupport;
import com.digitalpetri.opcua.stack.core.types.enumerated.ServerState;
import com.digitalpetri.opcua.stack.core.types.enumerated.TimestampsToReturn;
import com.digitalpetri.opcua.stack.core.types.structured.ReadValueId;
import com.digitalpetri.opcua.stack.core.types.structured.WriteValue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaNamespace
implements UaNamespace {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<NodeId, UaNode> nodes = Maps.newConcurrentMap();
    private final SubscriptionModel subscriptionModel;
    private final OpcUaServer server;

    public OpcUaNamespace(OpcUaServer server) {
        this.server = server;
        this.loadNodes();
        this.subscriptionModel = new SubscriptionModel(server, this);
        this.configureServerObject();
    }

    @Override
    public UShort getNamespaceIndex() {
        return Unsigned.ushort((int)0);
    }

    @Override
    public String getNamespaceUri() {
        return "http://opcfoundation.org/UA/";
    }

    @Override
    public void addNode(UaNode node) {
        this.nodes.put(node.getNodeId(), node);
    }

    @Override
    public Optional<UaNode> getNode(NodeId nodeId) {
        return Optional.ofNullable(this.nodes.get(nodeId));
    }

    @Override
    public Optional<UaNode> getNode(ExpandedNodeId nodeId) {
        return nodeId.local().flatMap(this::getNode);
    }

    @Override
    public Optional<UaNode> removeNode(NodeId nodeId) {
        return Optional.ofNullable(this.nodes.remove(nodeId));
    }

    @Override
    public CompletableFuture<List<Reference>> getReferences(NodeId nodeId) {
        UaNode node = this.nodes.get(nodeId);
        if (node != null) {
            return CompletableFuture.completedFuture(node.getReferences());
        }
        CompletableFuture<List<Reference>> f = new CompletableFuture<List<Reference>>();
        f.completeExceptionally(new UaException(2150891520L));
        return f;
    }

    @Override
    public void read(AttributeManager.ReadContext context, Double maxAge, TimestampsToReturn timestamps, List<ReadValueId> readValueIds) {
        ArrayList results = Lists.newArrayListWithCapacity((int)readValueIds.size());
        for (ReadValueId id : readValueIds) {
            UaNode node = this.nodes.get(id.getNodeId());
            DataValue value = node != null ? node.readAttribute(id.getAttributeId().intValue(), timestamps, id.getIndexRange()) : new DataValue(new StatusCode(2150891520L));
            results.add(value);
        }
        context.complete(results);
    }

    @Override
    public void write(AttributeManager.WriteContext context, List<WriteValue> writeValues) {
        List results = writeValues.stream().map(value -> {
            if (this.nodes.containsKey(value.getNodeId())) {
                return new StatusCode(2151350272L);
            }
            return new StatusCode(2150891520L);
        }).collect(Collectors.toList());
        context.complete(results);
    }

    @Override
    public void onDataItemsCreated(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsCreated(dataItems);
    }

    @Override
    public void onDataItemsModified(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsModified(dataItems);
    }

    @Override
    public void onDataItemsDeleted(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsDeleted(dataItems);
    }

    @Override
    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
    }

    @Override
    public void onEventItemsCreated(List<EventItem> eventItems) {
        eventItems.stream().filter(MonitoredItem::isSamplingEnabled).forEach(item -> this.server.getEventBus().register(item));
    }

    @Override
    public void onEventItemsModified(List<EventItem> eventItems) {
        for (EventItem item : eventItems) {
            if (item.isSamplingEnabled()) {
                this.server.getEventBus().register((Object)item);
                continue;
            }
            this.server.getEventBus().unregister((Object)item);
        }
    }

    @Override
    public void onEventItemsDeleted(List<EventItem> eventItems) {
        eventItems.forEach(item -> this.server.getEventBus().unregister(item));
    }

    public void addReference(NodeId sourceNodeId, NodeId referenceTypeId, boolean forward, ExpandedNodeId targetNodeId, NodeClass targetNodeClass) throws UaException {
        UaNode node = this.nodes.get(sourceNodeId);
        if (node == null) {
            throw new UaException(2150891520L);
        }
        Reference reference = new Reference(sourceNodeId, referenceTypeId, targetNodeId, targetNodeClass, forward);
        node.addReference(reference);
    }

    @Override
    public Optional<MethodInvocationHandler> getInvocationHandler(NodeId methodId) {
        return Optional.ofNullable(this.nodes.get(methodId)).filter(n -> n instanceof UaMethodNode).flatMap(n -> ((UaMethodNode)n).getInvocationHandler());
    }

    public UaObjectNode getObjectsFolder() {
        return (UaObjectNode)this.nodes.get(Identifiers.ObjectsFolder);
    }

    public ServerNode getServerNode() {
        return (ServerNode)this.nodes.get(Identifiers.Server);
    }

    private void loadNodes() {
        try {
            long startTime = System.nanoTime();
            new UaNodeLoader(this);
            long endTime = System.nanoTime();
            long deltaMs = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
            this.logger.info("Loaded {} nodes in {}ms.", (Object)this.nodes.size(), (Object)deltaMs);
        }
        catch (Exception e) {
            this.logger.error("Error loading nodes.", (Throwable)e);
        }
    }

    private void configureServerObject() {
        OpcUaServerConfigLimits limits = this.server.getConfig().getLimits();
        ServerNode serverNode = (ServerNode)this.nodes.get(Identifiers.Server);
        this.replaceServerArrayNode();
        this.replaceNamespaceArrayNode();
        serverNode.setAuditing(false);
        serverNode.getServerDiagnostics().setEnabledFlag(false);
        serverNode.setServiceLevel(Unsigned.ubyte((int)255));
        ServerStatusType serverStatus = serverNode.getServerStatus();
        serverStatus.setBuildInfo(this.server.getConfig().getBuildInfo());
        serverStatus.setCurrentTime(DateTime.now());
        serverStatus.setSecondsTillShutdown(Unsigned.uint((int)0));
        serverStatus.setShutdownReason(LocalizedText.NULL_VALUE);
        serverStatus.setState(ServerState.Running);
        serverStatus.setStartTime(DateTime.now());
        UaVariableNode currentTime = (UaVariableNode)this.nodes.get(Identifiers.Server_ServerStatus_CurrentTime);
        DerivedVariableNode derivedCurrentTime = new DerivedVariableNode(this, currentTime){

            @Override
            public DataValue getValue() {
                return new DataValue(new Variant((Object)DateTime.now()));
            }
        };
        this.nodes.put(Identifiers.Server_ServerStatus_CurrentTime, derivedCurrentTime);
        ServerCapabilitiesType serverCapabilities = serverNode.getServerCapabilities();
        serverCapabilities.setLocaleIdArray(new String[]{Locale.ENGLISH.getLanguage()});
        serverCapabilities.setMaxArrayLength(limits.getMaxArrayLength());
        serverCapabilities.setMaxBrowseContinuationPoints(limits.getMaxBrowseContinuationPoints());
        serverCapabilities.setMaxHistoryContinuationPoints(limits.getMaxHistoryContinuationPoints());
        serverCapabilities.setMaxQueryContinuationPoints(limits.getMaxQueryContinuationPoints());
        serverCapabilities.setMaxStringLength(limits.getMaxStringLength());
        serverCapabilities.setMinSupportedSampleRate(limits.getMinSupportedSampleRate());
        OperationLimitsType operationLimits = serverCapabilities.getOperationLimits();
        operationLimits.setMaxMonitoredItemsPerCall(limits.getMaxMonitoredItemsPerCall());
        operationLimits.setMaxNodesPerBrowse(limits.getMaxNodesPerBrowse());
        operationLimits.setMaxNodesPerHistoryReadData(limits.getMaxNodesPerHistoryReadData());
        operationLimits.setMaxNodesPerHistoryReadEvents(limits.getMaxNodesPerHistoryReadEvents());
        operationLimits.setMaxNodesPerHistoryUpdateData(limits.getMaxNodesPerHistoryUpdateData());
        operationLimits.setMaxNodesPerHistoryUpdateEvents(limits.getMaxNodesPerHistoryUpdateEvents());
        operationLimits.setMaxNodesPerMethodCall(limits.getMaxNodesPerMethodCall());
        operationLimits.setMaxNodesPerNodeManagement(limits.getMaxNodesPerNodeManagement());
        operationLimits.setMaxNodesPerRead(limits.getMaxNodesPerRead());
        operationLimits.setMaxNodesPerRegisterNodes(limits.getMaxNodesPerRegisterNodes());
        operationLimits.setMaxNodesPerTranslateBrowsePathsToNodeIds(limits.getMaxNodesPerTranslateBrowsePathsToNodeIds());
        operationLimits.setMaxNodesPerWrite(limits.getMaxNodesPerWrite());
        serverNode.getServerRedundancy().setRedundancySupport(RedundancySupport.None);
        try {
            UaMethodNode getMonitoredItems = (UaMethodNode)this.nodes.get(Identifiers.Server_GetMonitoredItems);
            AnnotationBasedInvocationHandler invocationHandler = AnnotationBasedInvocationHandler.fromAnnotatedObject(this, new GetMonitoredItems(this.server));
            getMonitoredItems.setInputArguments(invocationHandler.getInputArguments());
            getMonitoredItems.setOutputArguments(invocationHandler.getOutputArguments());
            getMonitoredItems.setInvocationHandler(invocationHandler);
        }
        catch (Exception e) {
            this.logger.error("Error setting up GetMonitoredItems Method.", (Throwable)e);
        }
    }

    private void replaceServerArrayNode() {
        UaVariableNode originalNode = (UaVariableNode)this.nodes.get(Identifiers.Server_ServerArray);
        DerivedVariableNode derived = new DerivedVariableNode(this, originalNode){

            @Override
            public DataValue getValue() {
                return new DataValue(new Variant((Object)OpcUaNamespace.this.server.getServerTable().toArray()));
            }
        };
        this.nodes.put(derived.getNodeId(), derived);
    }

    private void replaceNamespaceArrayNode() {
        UaVariableNode originalNode = (UaVariableNode)this.nodes.get(Identifiers.Server_NamespaceArray);
        DerivedVariableNode derived = new DerivedVariableNode(this, originalNode){

            @Override
            public DataValue getValue() {
                return new DataValue(new Variant((Object)OpcUaNamespace.this.server.getNamespaceManager().getNamespaceTable().toArray()));
            }
        };
        this.nodes.put(derived.getNodeId(), derived);
    }
}

