/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.variables;

import com.digitalpetri.opcua.sdk.core.model.UaMandatory;
import com.digitalpetri.opcua.sdk.core.model.variables.ServerDiagnosticsSummaryType;
import com.digitalpetri.opcua.sdk.core.nodes.VariableNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.variables.BaseDataVariableNode;
import com.digitalpetri.opcua.sdk.server.util.UaVariableType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import com.digitalpetri.opcua.stack.core.types.structured.ServerDiagnosticsSummaryDataType;
import java.util.Optional;

@UaVariableType(name="ServerDiagnosticsSummaryType")
public class ServerDiagnosticsSummaryNode
extends BaseDataVariableNode
implements ServerDiagnosticsSummaryType {
    public ServerDiagnosticsSummaryNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, DataValue value, NodeId dataType, Integer valueRank, Optional<UInteger[]> arrayDimensions, UByte accessLevel, UByte userAccessLevel, Optional<Double> minimumSamplingInterval, boolean historizing) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public DataValue getValue() {
        ServerDiagnosticsSummaryDataType value = new ServerDiagnosticsSummaryDataType(this.getServerViewCount(), this.getCurrentSessionCount(), this.getCumulatedSessionCount(), this.getSecurityRejectedSessionCount(), this.getRejectedSessionCount(), this.getSessionTimeoutCount(), this.getSessionAbortCount(), this.getPublishingIntervalCount(), this.getCurrentSubscriptionCount(), this.getCumulatedSubscriptionCount(), this.getSecurityRejectedRequestsCount(), this.getRejectedRequestsCount());
        return new DataValue(new Variant((Object)value));
    }

    @Override
    public synchronized void setValue(DataValue value) {
        ServerDiagnosticsSummaryDataType v = (ServerDiagnosticsSummaryDataType)value.getValue().getValue();
        this.setServerViewCount(v.getServerViewCount());
        this.setCurrentSessionCount(v.getCurrentSessionCount());
        this.setCumulatedSessionCount(v.getCumulatedSessionCount());
        this.setSecurityRejectedSessionCount(v.getSecurityRejectedSessionCount());
        this.setRejectedSessionCount(v.getRejectedSessionCount());
        this.setSessionTimeoutCount(v.getSessionTimeoutCount());
        this.setSessionAbortCount(v.getSessionAbortCount());
        this.setPublishingIntervalCount(v.getPublishingIntervalCount());
        this.setCurrentSubscriptionCount(v.getCurrentSubscriptionCount());
        this.setCumulatedSubscriptionCount(v.getCumulatedSubscriptionCount());
        this.setSecurityRejectedRequestsCount(v.getSecurityRejectedRequestsCount());
        this.setRejectedRequestsCount(v.getRejectedRequestsCount());
        this.fireAttributeChanged(13, value);
    }

    @Override
    @UaMandatory(value="ServerViewCount")
    public UInteger getServerViewCount() {
        Optional<VariableNode> node = this.getVariableComponent("ServerViewCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="CurrentSessionCount")
    public UInteger getCurrentSessionCount() {
        Optional<VariableNode> node = this.getVariableComponent("CurrentSessionCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="CumulatedSessionCount")
    public UInteger getCumulatedSessionCount() {
        Optional<VariableNode> node = this.getVariableComponent("CumulatedSessionCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="SecurityRejectedSessionCount")
    public UInteger getSecurityRejectedSessionCount() {
        Optional<VariableNode> node = this.getVariableComponent("SecurityRejectedSessionCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="RejectedSessionCount")
    public UInteger getRejectedSessionCount() {
        Optional<VariableNode> node = this.getVariableComponent("RejectedSessionCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="SessionTimeoutCount")
    public UInteger getSessionTimeoutCount() {
        Optional<VariableNode> node = this.getVariableComponent("SessionTimeoutCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="SessionAbortCount")
    public UInteger getSessionAbortCount() {
        Optional<VariableNode> node = this.getVariableComponent("SessionAbortCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="PublishingIntervalCount")
    public UInteger getPublishingIntervalCount() {
        Optional<VariableNode> node = this.getVariableComponent("PublishingIntervalCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="CurrentSubscriptionCount")
    public UInteger getCurrentSubscriptionCount() {
        Optional<VariableNode> node = this.getVariableComponent("CurrentSubscriptionCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="CumulatedSubscriptionCount")
    public UInteger getCumulatedSubscriptionCount() {
        Optional<VariableNode> node = this.getVariableComponent("CumulatedSubscriptionCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="SecurityRejectedRequestsCount")
    public UInteger getSecurityRejectedRequestsCount() {
        Optional<VariableNode> node = this.getVariableComponent("SecurityRejectedRequestsCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    @UaMandatory(value="RejectedRequestsCount")
    public UInteger getRejectedRequestsCount() {
        Optional<VariableNode> node = this.getVariableComponent("RejectedRequestsCount");
        return node.map(n -> (UInteger)n.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public synchronized void setServerViewCount(UInteger serverViewCount) {
        this.getVariableComponent("ServerViewCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)serverViewCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setCurrentSessionCount(UInteger currentSessionCount) {
        this.getVariableComponent("CurrentSessionCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)currentSessionCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setCumulatedSessionCount(UInteger cumulatedSessionCount) {
        this.getVariableComponent("CumulatedSessionCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)cumulatedSessionCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setSecurityRejectedSessionCount(UInteger securityRejectedSessionCount) {
        this.getVariableComponent("SecurityRejectedSessionCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)securityRejectedSessionCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setRejectedSessionCount(UInteger rejectedSessionCount) {
        this.getVariableComponent("RejectedSessionCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)rejectedSessionCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setSessionTimeoutCount(UInteger sessionTimeoutCount) {
        this.getVariableComponent("SessionTimeoutCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)sessionTimeoutCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setSessionAbortCount(UInteger sessionAbortCount) {
        this.getVariableComponent("SessionAbortCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)sessionAbortCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setPublishingIntervalCount(UInteger publishingIntervalCount) {
        this.getVariableComponent("PublishingIntervalCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)publishingIntervalCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setCurrentSubscriptionCount(UInteger currentSubscriptionCount) {
        this.getVariableComponent("CurrentSubscriptionCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)currentSubscriptionCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setCumulatedSubscriptionCount(UInteger cumulatedSubscriptionCount) {
        this.getVariableComponent("CumulatedSubscriptionCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)cumulatedSubscriptionCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setSecurityRejectedRequestsCount(UInteger securityRejectedRequestsCount) {
        this.getVariableComponent("SecurityRejectedRequestsCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)securityRejectedRequestsCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }

    @Override
    public synchronized void setRejectedRequestsCount(UInteger rejectedRequestsCount) {
        this.getVariableComponent("RejectedRequestsCount").ifPresent(n -> {
            n.setValue(new DataValue(new Variant((Object)rejectedRequestsCount)));
            this.fireAttributeChanged(13, this.getValue());
        });
    }
}

