/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.opcua.sdk.server.model.objects;

import com.digitalpetri.opcua.sdk.core.model.objects.BaseObjectType;
import com.digitalpetri.opcua.sdk.core.model.objects.ProgramStateMachineType;
import com.digitalpetri.opcua.sdk.core.model.objects.StateType;
import com.digitalpetri.opcua.sdk.core.model.objects.TransitionType;
import com.digitalpetri.opcua.sdk.core.model.variables.FiniteStateVariableType;
import com.digitalpetri.opcua.sdk.core.model.variables.FiniteTransitionVariableType;
import com.digitalpetri.opcua.sdk.core.model.variables.ProgramDiagnosticType;
import com.digitalpetri.opcua.sdk.core.nodes.ObjectNode;
import com.digitalpetri.opcua.sdk.core.nodes.VariableNode;
import com.digitalpetri.opcua.sdk.server.api.UaNamespace;
import com.digitalpetri.opcua.sdk.server.model.objects.FiniteStateMachineNode;
import com.digitalpetri.opcua.sdk.server.util.UaObjectType;
import com.digitalpetri.opcua.stack.core.types.builtin.DataValue;
import com.digitalpetri.opcua.stack.core.types.builtin.LocalizedText;
import com.digitalpetri.opcua.stack.core.types.builtin.NodeId;
import com.digitalpetri.opcua.stack.core.types.builtin.QualifiedName;
import com.digitalpetri.opcua.stack.core.types.builtin.Variant;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UByte;
import com.digitalpetri.opcua.stack.core.types.builtin.unsigned.UInteger;
import java.util.Optional;

@UaObjectType(name="ProgramStateMachineType")
public class ProgramStateMachineNode
extends FiniteStateMachineNode
implements ProgramStateMachineType {
    public ProgramStateMachineNode(UaNamespace namespace, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, Optional<LocalizedText> description, Optional<UInteger> writeMask, Optional<UInteger> userWriteMask, UByte eventNotifier) {
        super(namespace, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public FiniteStateVariableType getCurrentState() {
        Optional<VariableNode> currentState = this.getVariableComponent("CurrentState");
        return currentState.map(node -> (FiniteStateVariableType)((Object)node)).orElse(null);
    }

    @Override
    public FiniteTransitionVariableType getLastTransition() {
        Optional<VariableNode> lastTransition = this.getVariableComponent("LastTransition");
        return lastTransition.map(node -> (FiniteTransitionVariableType)((Object)node)).orElse(null);
    }

    @Override
    public Boolean getCreatable() {
        Optional<Object> creatable = this.getProperty("Creatable");
        return creatable.orElse(null);
    }

    @Override
    public Boolean getDeletable() {
        Optional<Object> deletable = this.getProperty("Deletable");
        return deletable.orElse(null);
    }

    @Override
    public Boolean getAutoDelete() {
        Optional<Object> autoDelete = this.getProperty("AutoDelete");
        return autoDelete.orElse(null);
    }

    @Override
    public Integer getRecycleCount() {
        Optional<Object> recycleCount = this.getProperty("RecycleCount");
        return recycleCount.orElse(null);
    }

    @Override
    public UInteger getInstanceCount() {
        Optional<Object> instanceCount = this.getProperty("InstanceCount");
        return instanceCount.orElse(null);
    }

    @Override
    public UInteger getMaxInstanceCount() {
        Optional<Object> maxInstanceCount = this.getProperty("MaxInstanceCount");
        return maxInstanceCount.orElse(null);
    }

    @Override
    public UInteger getMaxRecycleCount() {
        Optional<Object> maxRecycleCount = this.getProperty("MaxRecycleCount");
        return maxRecycleCount.orElse(null);
    }

    @Override
    public ProgramDiagnosticType getProgramDiagnostics() {
        Optional<VariableNode> programDiagnostics = this.getVariableComponent("ProgramDiagnostics");
        return programDiagnostics.map(node -> (ProgramDiagnosticType)((Object)node)).orElse(null);
    }

    @Override
    public BaseObjectType getFinalResultData() {
        Optional<ObjectNode> finalResultData = this.getObjectComponent("FinalResultData");
        return finalResultData.map(node -> (BaseObjectType)((Object)node)).orElse(null);
    }

    @Override
    public StateType getReady() {
        Optional<ObjectNode> ready = this.getObjectComponent("Ready");
        return ready.map(node -> (StateType)((Object)node)).orElse(null);
    }

    @Override
    public StateType getRunning() {
        Optional<ObjectNode> running = this.getObjectComponent("Running");
        return running.map(node -> (StateType)((Object)node)).orElse(null);
    }

    @Override
    public StateType getSuspended() {
        Optional<ObjectNode> suspended = this.getObjectComponent("Suspended");
        return suspended.map(node -> (StateType)((Object)node)).orElse(null);
    }

    @Override
    public StateType getHalted() {
        Optional<ObjectNode> halted = this.getObjectComponent("Halted");
        return halted.map(node -> (StateType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getHaltedToReady() {
        Optional<ObjectNode> haltedToReady = this.getObjectComponent("HaltedToReady");
        return haltedToReady.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getReadyToRunning() {
        Optional<ObjectNode> readyToRunning = this.getObjectComponent("ReadyToRunning");
        return readyToRunning.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getRunningToHalted() {
        Optional<ObjectNode> runningToHalted = this.getObjectComponent("RunningToHalted");
        return runningToHalted.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getRunningToReady() {
        Optional<ObjectNode> runningToReady = this.getObjectComponent("RunningToReady");
        return runningToReady.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getRunningToSuspended() {
        Optional<ObjectNode> runningToSuspended = this.getObjectComponent("RunningToSuspended");
        return runningToSuspended.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getSuspendedToRunning() {
        Optional<ObjectNode> suspendedToRunning = this.getObjectComponent("SuspendedToRunning");
        return suspendedToRunning.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getSuspendedToHalted() {
        Optional<ObjectNode> suspendedToHalted = this.getObjectComponent("SuspendedToHalted");
        return suspendedToHalted.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getSuspendedToReady() {
        Optional<ObjectNode> suspendedToReady = this.getObjectComponent("SuspendedToReady");
        return suspendedToReady.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public TransitionType getReadyToHalted() {
        Optional<ObjectNode> readyToHalted = this.getObjectComponent("ReadyToHalted");
        return readyToHalted.map(node -> (TransitionType)((Object)node)).orElse(null);
    }

    @Override
    public synchronized void setCurrentState(FiniteStateVariableType currentState) {
        this.getVariableComponent("CurrentState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)currentState))));
    }

    @Override
    public synchronized void setLastTransition(FiniteTransitionVariableType lastTransition) {
        this.getVariableComponent("LastTransition").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)lastTransition))));
    }

    @Override
    public synchronized void setCreatable(Boolean creatable) {
        this.getPropertyNode("Creatable").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)creatable))));
    }

    @Override
    public synchronized void setDeletable(Boolean deletable) {
        this.getPropertyNode("Deletable").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)deletable))));
    }

    @Override
    public synchronized void setAutoDelete(Boolean autoDelete) {
        this.getPropertyNode("AutoDelete").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)autoDelete))));
    }

    @Override
    public synchronized void setRecycleCount(Integer recycleCount) {
        this.getPropertyNode("RecycleCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)recycleCount))));
    }

    @Override
    public synchronized void setInstanceCount(UInteger instanceCount) {
        this.getPropertyNode("InstanceCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)instanceCount))));
    }

    @Override
    public synchronized void setMaxInstanceCount(UInteger maxInstanceCount) {
        this.getPropertyNode("MaxInstanceCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)maxInstanceCount))));
    }

    @Override
    public synchronized void setMaxRecycleCount(UInteger maxRecycleCount) {
        this.getPropertyNode("MaxRecycleCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)maxRecycleCount))));
    }

    public synchronized void setProgramDiagnostics(ProgramDiagnosticType programDiagnostics) {
        this.getVariableComponent("ProgramDiagnostics").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)programDiagnostics))));
    }
}

